/***************************************************************************
                          tagadlg.cpp  -  description
                             -------------------
    begin                : Sat Nov 27 1999
    copyright            : (C) 1999 by Yacovlev Alexander & Dmitry Poplavsky
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "tagadlg.h"
#include <kfiledialog.h>
#include "quantaview.h"
#include "quantadoc.h"
#include "qextfileinfo.h"

TagADlg::TagADlg(QWidget *parent, const char *name) : QDialog(parent,name,true){
	setCaption(name);
	initDialog();
	connect( buttonOk, SIGNAL(clicked()), SLOT(accept()) );
	connect( buttonCancel, SIGNAL(clicked()), SLOT(reject()) );
	connect( buttonHREF, SIGNAL(clicked()), this, SLOT(slotFileSelect()) );
}

TagADlg::~TagADlg(){
}

/**  */
void TagADlg::slotFileSelect(){
		QString basePath = ((QuantaView *)parent())->getDocument()->basePath;
		
		QString fileName = KFileDialog::getOpenFileName(basePath, "*.html *.htm|HTML files\n*|All files");
		if (fileName.isEmpty()) return;
		
		QExtFileInfo file(fileName);
		file.convertToRelative(basePath);
		QString shortName = file.filePath();
		comboHREF->setEditText(shortName);
}
