/***************************************************************************
                          docfolder.cpp  -  description
                             -------------------
    begin                : Fri Mar 3 2000
    copyright            : (C) 2000 by Yacovlev Alexander & Dmitry Poplavsky
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "docfolder.h"
#include "docitem.h"
#include <kconfig.h>
#include <qstrlist.h>
#include <qpixmap.h>

#include "pics/mini-book1.xpm"
#include "pics/mini-book2.xpm"
#include "pics/mini-doc.xpm"
#include "pics/folder.xpm"
#include "pics/folder_open.xpm"

DocFolder::DocFolder(QListViewItem *parent, QString _name, KConfig *config)
  : QListViewItem(parent)
{
  name = _name;
  main = false;

  QStrList list;

  config->readListEntry( name.data(), list );

  char *item;

  for ( list.last(); ( item = list.current() ) ; list.prev() ) {
    if ( item[0] != '#' ) {
      QString url = config->readEntry( item );
      DocItem *el = new DocItem( this, QString(item), url);
      el->setPixmap( 0, QPixmap((const char**)mini_doc_xpm) );
    }
  }

  for ( list.last(); ( item = list.current() ) ; list.prev() ) {
    if ( item[0] == '#' ) { // current item is folder
      item++; // remove leading #
      DocFolder *el = new DocFolder(this, QString(item), config);
      el->setPixmap( 0, QPixmap((const char**)mini_book1_xpm) );
      el->setOpen( false );
    }
  }
}

DocFolder::DocFolder(QListView *parent, QString _name, KConfig *config)
  : QListViewItem(parent)
{
  name = _name;
  main = false;
  QStrList list;

  config->readListEntry( name.data(), list );

  char *item;

  for ( list.last(); ( item = list.current() ) ; list.prev() ) {
    if ( item[0] != '#' ) {
      QString url = config->readEntry( item );
      DocItem *el = new DocItem( this, QString(item), url);
      el->setPixmap( 0, QPixmap((const char**)mini_doc_xpm) );
    }
  }

  for ( list.last(); ( item = list.current() ) ; list.prev() ) {
    if ( item[0] == '#' ) { // current item is folder
      item++; // remove leading #
      DocFolder *el = new DocFolder(this, QString(item), config);
      el->setPixmap( 0, QPixmap((const char**)mini_book1_xpm) );
      el->setOpen( false );
    }
  }
}


DocFolder::~DocFolder(){
}


const char * DocFolder::text( int column ) const
{
  return name.data();
}

void DocFolder::setup()
{
    setExpandable( TRUE );
    QListViewItem::setup();
}
/**  */
void DocFolder::setOpen( bool o)
{
  QListViewItem::setOpen( o );
  if ( !main ) {
    if (o)
  		setPixmap( 0, QPixmap((const char**)mini_book2_xpm) );
    else
  		setPixmap( 0, QPixmap((const char**)mini_book1_xpm) );
  } else {
    if (o)
  		setPixmap( 0, QPixmap((const char**)folder_open_xpm) );
    else
  		setPixmap( 0, QPixmap((const char**)folder_xpm) );
  }
}
