#ifndef __BALL_H_INCLUDED__
#define __BALL_H_INCLUDED__

/*#ifndef __MAIN_H_INCLUDED__
 *        #error include main.h before including this file
 *#endif*/

#include <qobject.h>
#include <qpoint.h>
#include <qpainter.h>
#include <qpixmap.h>

class CMaze;

#define BLMOVING 1	/* Ball moves steadily */
#define BLJUMPING 2	/* Jumps from one place to another */
#define BLQUIET 3	/* Does not move at all */
#define BLQUIET2 4

class CBall : public QObject
{
	Q_OBJECT
 protected:
	CBall(CMaze* parent);

 public:
	virtual ~CBall();
	void init(QPoint* pos = NULL);
	void draw(QPainter* pt);

 protected:
	void redraw(QPoint last);
	QPoint LPtoDP(QPoint pt);
	QRect LPtoDP(QRect rct);
	QPoint getFreePos();
	virtual bool moveFunc(long c) = 0;
	virtual bool changeAppearance() = 0;

	void getPixmap();

 signals:
	void sigUpdate(const QRect&);
	/*   void sigAccess(QPoint pos);*/

 public slots:
	void slotStart();
        void slotFinish();
	void slotTimer(long c);

// Class Data
 public: 
	char moveType() { return _moveType; }
	QPoint pos() { return _pos; }
	virtual char score() = 0;
	CMaze* maze() { return _maze; }

 protected:
	CMaze* _maze;
	char _moveType;
	QPoint _pos;
	bool _active;
	QPixmap* _activePixmap;
	int _pixmapIndex;
};

class CQuietBall : public CBall
{
 public:
	CQuietBall(CMaze* parent);
	virtual char score() { return 50; }

 protected:
	char _qbType; // 0 if ball changes color, 1 if ball changes size
	char _lastSize; // 0 for big .. 2 for small
	virtual bool moveFunc(long c);
	virtual bool changeAppearance();

};

class CMovingBall : public CBall
{
 public:
	CMovingBall(CMaze* parent,char speed = 5);
	virtual char score() { return 100; }

 protected:
	char _speed;
	char _dir;
	virtual bool moveFunc(long c);
	virtual bool changeAppearance() { return false; }
};

class CJumpingBall : public CBall
{
 public:
	CJumpingBall(CMaze* parent,char p = 5,char speed = 10);
	virtual char score() { return 80; }

 protected:
	char _speed;
	char _p; // Probability that a ball moves (p/100)
	virtual bool moveFunc(long c);
	virtual bool changeAppearance() { return false; }
};

#endif // !__BALL_H_INCLUDED__
