/***************************************************************************
    feuerwehr.cpp  fr KWA - Kanadische Waldbrandaustreter
    Lschzug,  Klassen-Implementation
                             -------------------
    begin                : Sat Sep 30 2000
    copyright            : (C) 2000 by Ulrich Bochert
    email                : schroeder_bochert@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "feuerwehr.h"
#include "kwa.h"
#include <stdio.h>
#include <math.h>
static double PI=3.1415926536;
FeuerWehr::FeuerWehr(int n, float xPos, float yPos,
                     int Zeile, int Spalte, double Rtg, int B, int W)//Konstruktor
{
//        printf("fwkonstruktor\n");
        init( n, xPos,  yPos, Zeile, Spalte, Rtg, B, W);
        Benzin=double(B);
        BenzinAlt=B;
        Wasser=W;
        name=n;
        x=xPos;
        y=yPos;
        z=Zeile; //Felder pro Zeile
        s=Spalte;//Felder pro Spalte
        Richtung=Rtg;
        Fahrt=0.1;
        willLoeschen=true;
        Abgebrannt=false;
        //printf("fwkonstr x %1.5f y %1.5f", x,y);
}
void FeuerWehr::init(int n, float xPos, float yPos,
                     int Zeile, int Spalte, double Rtg, int B, int W)
{
//        printf("fw init\n");
        Benzin=double(B);
        BenzinAlt=B;
        Wasser=W;
        name=n;
        x=xPos;
        y=yPos;
        z=Zeile; //Felder pro Zeile
        s=Spalte;//Felder pro Spalte
        Richtung=Rtg;
        Fahrt=0.1;
        willLoeschen=true;
        Abgebrannt=false;
        //printf("fwkonstr x %1.5f y %1.5f", x,y);
}

float FeuerWehr::getXPos()
        {
        return x;
        }

float FeuerWehr::getYPos()
        {
        return y;
        }
void FeuerWehr::setXPos(double xPos)
        {
        x=xPos;
        }

void FeuerWehr::setYPos(double yPos)
        {
        y=yPos;
        }
void FeuerWehr::fahren(float BV)
        {
        //printf("FWfahren\n");
        if (Benzin==0) return;
        float BenzinVerbrauch=BV;
        x=x+Fahrt*sin(Richtung*PI/180.0);
        if (x>=z||x<0)
                {
                if (x>=z)
                        x=double(z)-0.001;
                if (x<0)
                        x=0;
                Richtung=360.0-Richtung;
                //printf("FW emitRichtung 1\n");
                emit RichtungChanged(Richtung);
                }
        y=y-Fahrt*cos(Richtung*PI/180.0);
        if (y>=s||y<0)
                {
                if (y>=s) y=double(s)-0.001;
                if (y<0)  y=0;
                if (Richtung<=180.0) Richtung=180.0-Richtung;
                if (Richtung> 180.0) Richtung=540.0-Richtung;
                //printf("FW emitRichtung 2\n");
                emit RichtungChanged(Richtung);
                }
         Benzin=Benzin-pow(Fahrt, 2)*BenzinVerbrauch;
         if (int(Benzin)<BenzinAlt)
         {
                 if (Benzin<0) Benzin=0;
                 emit BenzinChanged(int(Benzin));
                 BenzinAlt=int(Benzin);
         }
         }

void FeuerWehr::setRichtung(int xPos, int yPos)
{
        //printf("FWsetRichtung\n");
        double xVect=double(xPos-x);
        double yVect=double(yPos-y);
        //printf("FW x %1.2f y %1.2f\n", xVect, yVect);
        double Normierung=sqrt((pow(xVect,2)+pow(yVect,2)));
        //printf("FWNormierung %1.2f\n", Normierung);
        xVect=xVect/Normierung;
        yVect=yVect/Normierung;
        //printf("FW Vect x %1.2f y %1.2f\n", xVect, yVect);
        if (yVect<0.0 && xVect>0.0)
                Richtung=90.0-acos(xVect)*180.0/PI;
        else if (yVect<0.0 && xVect<0.0)
                Richtung=450.0-acos(xVect)*180.0/PI;
        else if (yVect>0.0 && xVect<0.0)
                Richtung=acos(xVect)*180.0/PI+90.0;
        else if (yVect>0.0 && xVect>0.0)
                Richtung=acos(xVect)*180/PI+90.0;
        //printf("FW Richtung  %1.2f \n", Richtung);
        //printf("FW emitRichtung 3\n");
        emit RichtungChanged(Richtung);
}
void FeuerWehr::setWillLoeschen(bool L)
{
        //printf("FWselected %d\n", S);
        willLoeschen=L;
        //if (Wasser==0) willLoeschen=false;
        emit WillLoeschenChanged(L);
}
bool FeuerWehr::getWillLoeschen()
{
        //printf("FWselected %d\n", selected);
        return willLoeschen;
}
void FeuerWehr::setSelected(bool S)
{
        //printf("FWselected %d\n", S);
        selected=S;
}
bool FeuerWehr::getSelected()
{
        //printf("FWselected %d\n", selected);
        return selected;
}
double FeuerWehr::getRichtung()
{
        return Richtung;
}
void FeuerWehr::setRichtung(double R)
{
        Richtung=R;
        emit RichtungChanged(Richtung);
}
void FeuerWehr::setFahrt(double S)
{
        if( S<0) S=0;
        if( S>5) S=5;
        if( S!=Fahrt)
        {
                Fahrt=S;
                //printf("fw emit Fahrt %3.3f\n", S);
                emit FahrtChanged(Fahrt);
        }
}
double FeuerWehr::getFahrt()
{
        return Fahrt;
}
double FeuerWehr::getWasser()
{
        return Wasser;
}
void FeuerWehr::setWasser(double W)
{
        if (W>0)
                Wasser=W;
        else
        {
                Wasser=0;
                willLoeschen=false;
        }
        if (WasserAlt!=int(Wasser/100))
        {
                WasserAlt=int(Wasser/100);
                emit WasserChanged(Wasser/100);
        }
}
int FeuerWehr::getBenzin()
{
        return int(Benzin);
}
void FeuerWehr::setBenzin(int B)
{
        Benzin=B;
        BenzinAlt=B;
        emit BenzinChanged(Benzin);
}
bool FeuerWehr::getAbgebrannt()
{
        return Abgebrannt;
}
void FeuerWehr::setAbgebrannt(bool A)
{
        Abgebrannt=A;
}
void FeuerWehr::FahrtSlot(double S)//Slot
{
        Fahrt=S;
        //printf("FahrtSlot %3.3f\n", S);
}
void FeuerWehr::RichtungSlot(double R)//Slot
{
        Richtung=R;
}
void FeuerWehr::WillLoeschenSlot(bool L)//Slot
{
        //printf("fw w l chgd\n");
        willLoeschen=L;
        if (Wasser==0) willLoeschen=false;
        emit WillLoeschenChanged(L);
}
#include "feuerwehr.moc"
