#include "Cards.h"

Card::Card(QwSpritePixmapSequence& s, int ct, int cn, int cs, int upframe, int downframe)
  : BaseCard(s,ct)
{
  cnum = cn;
  csuit = cs;
  next = NULL;
  prev= NULL;
  picked_up=0;
  faceup=0;
  faceupFrame=upframe;
  facedownFrame=downframe;
}

Card::~Card()
{
  next = NULL;
  prev = NULL;
}

bool Card::setCardType(int ct)
{
  _setCardType(ct);
  return 1;
} 

int Card::cardNum() {return cnum;}

int Card::cardSuit() {return csuit;}

void Card::setFacedownFrame(int frame_num) {
  facedownFrame = frame_num;
  if (!faceup) frame(facedownFrame);
}

void Card::setFace(bool face)
{
  faceup = face;
  if (faceup) frame(faceupFrame);
  else frame(facedownFrame);
}

bool Card::faceUp() {
  return faceup;
}

BaseCard* Card::nextCard() {  return next; }
BaseCard* Card::prevCard() {  return prev; }

bool Card::setNextCard(BaseCard* card) {
  next = card;
  return 1;
}

bool Card::setPrevCard(BaseCard* card) {
  prev = card;
  return 1;
}

void Card::cleanCard()
{
  next = NULL;
  prev = NULL;
  picked_up=0;
  px=0;
  py=0;
  pz=0;
}

bool Card::isTopCard() {
  if (next) return 0;
  return 1;
}

bool Card::isCardAbove(BaseCard *card)
{
  BaseCard* n = this->next;
  if (n) {
    for (;;) {
      if (n == card) return 1;
      n = n->nextCard();
      if (!n) return 0;
    }
  }
  return 0;
}

bool Card::isCardBelow(BaseCard *card)
{
  BaseCard* n = this->prev;
  if (n) {
    for (;;) {
      if (n == card) return 1;
      n = n->prevCard();
      if (!n) return 0;
    }
  }
  return 0;
}

BaseCard* Card::topCard()
{
  BaseCard* n = this;
  for (;;) {
    if (n->nextCard()) n = n->nextCard();
    else return n;
    if (n == this) 
      { 
	debug("Cycle in cards... Exiting.");
	exit(1);
      }
  }
}

bool Card::pickupCards()  
{    
  if (!picked_up) {
    px = x();
    py = y();
    pz = z();
    picked_up = 1;
    if (next) { next->pickupCards(); }
    return 1;
  }
  else {return 0;}
}

void Card::putdownCards()
{
  if (picked_up) {
    picked_up = 0;
    if (next) { next->putdownCards(); }
  }                          
}

bool Card::dragCardsTo(int nx, int ny, int nz, int dx=0, int dy=0, bool force=0)
{
  if (picked_up || force) {
    Card* n = this;
    for (;;) {
      n->moveTo(nx,ny);
      n->z(nz);
      if (n->next) {
	n = (Card*)n->next;
	nx = nx + dx;
	ny = ny + dy;
	nz++;
      }
      else { return 1; }
    }
  }
  else return 0;
}

void Card::putbackCards() 
{
  if (picked_up) {
    moveTo(px,py);
    z(pz);
    picked_up = 0;
    if (next) { next->putbackCards(); }
  }
}


bool Card::dropCards(BaseCard *on_card,int dx, int dy)
{
  if (picked_up && on_card->isTopCard() && this != on_card && !isCardAbove(on_card)) {
    if (prev) { prev->setNextCard(NULL); }
    prev = on_card;
    prev->setNextCard(this);
    dragCardsTo(prev->x()+dx, prev->y()+dy, prev->z()+1, dx, dy);
    putdownCards();
    return 1;
  }
  return 0;
}

void Card::moveCardsTo(int nx, int ny)
{
  if (next) next->moveCardsTo(nx + (next->x() - x()), ny + (next->y() - y()));
  moveTo(nx,ny);
}

