#ifndef KSCORE_H
#define KSCORE_H
#include "khtmldlg.h"

struct KScore
{
  long gold;
  char name[30], nick[30];
  short other, level;
  char m_char, amulet;
};

class KScoreList
{
public:
  int loaded;
  KScoreList(int _user);
  virtual ~KScoreList() {}
  virtual int putScore(long gold, char *name, char *nick, short other,
    short level, char m_char, char amulet);
  virtual QString &desc(int i);
  virtual QString &score(int i);
  virtual void setNick(const char *name, const char *nick);
  virtual int current();
  QString scorefile;
protected:
  KScore scores[10];
  QString descs[10], scorestr[10];
  int nScores, curr;
  int user;
  virtual int loadFile(const char *fn);
  virtual int writeFile(const char *fn);
};

class KScoreDlg:public KHTMLDlg
{
  Q_OBJECT
public:
  KScoreDlg(bool _user, QWidget *);
  virtual ~KScoreDlg() {if (list) delete list;}
  virtual int putScore(long gold, char *name, char *nick, short other,
    short level, char m_char, char amulet);
  virtual void listScores();
protected:
  KScoreList *list;
  char currn[10];
  bool user;
};
#endif