#include <qobjectlist.h>
#include <kiconloader.h>
#include <kquickhelp.h>
#include <kstatusbar.h>
#include <ktoolbar.h>
#include <kcursor.h>
#include <ctype.h>
#include <kapp.h>
#include "rogue/rogue.h"
#include "rogue/dun.h"
#include "krogueqh.h"
#include "roguec.h"

#define ITEM(x) (tl->getWidget(x))

KRQHEvFilter evfilter;

void krqhSetToolBar(KToolBar *tl)
{
  KRQuickHelp::add(ITEM(2), i18n("<b>Restore</b>\n\n"
      "Restore a games previously saved to disk.\n"
      "The savegame file will be deleted afterward.\n"
      "You cannot modify it, copy or try to restore\n"
      "someone else's file."));
  KRQuickHelp::add(ITEM(3), i18n("<b>Save</b>\n\n"
      "Save the game to disk. To restore it use the\n"
      "restore button (on the left). You will be able\n"
      "to restore it only once. You cannot modify it\n"
      "or copy."));
  KRQuickHelp::add(ITEM(18), i18n("<b>Inventory</b>\n\n"
      "Shows your inventory (i.e. all the objects that\n"
      "you have). You can click on an item with the right\n"
      "mouse button to obtain a popup menu."));
  KRQuickHelp::add(ITEM(4), i18n("<b>Eat</b>\n\n"
      "Eat some food. You will know when you become\n"
      "hungry, weak or fainting of hunger - a message\n"
      "will appear and a note will be visible on the\n"
      "status bar (<link food.html>more...</link>)"));
  KRQuickHelp::add(ITEM(5), i18n("<b>Quaff</b>\n\n"
      "Quaff a magic potion found in the Dungeons"
      " (<link potion.html>more...</link>)"));
  KRQuickHelp::add(ITEM(6), i18n("<b>Read</b>\n\n"
      "Read a magic scroll found in the Dungeons"
      " (<link scroll.html>more...</link>)"));
  KRQuickHelp::add(ITEM(7), i18n("<b>Zap</b>\n\n"
      "Zap a wand or staff (i.e. use its magic power\n"
      "against a monster). To zap it you should be\n"
      "on the same line as the monster. Each wand\n"
      "and staff have a limited number of bolts"
      " (<link wand.html>more...</link>)"));
  KRQuickHelp::add(ITEM(8), i18n("<b>Wield</b>\n\n"
      "Wield a weapon (i.e. have it ready to use in\n"
      "hand). Usually you should wield a mace,\n"
      "long sword or two-handed sword. If you throw\n"
      "arrows you can wield a short bow before. If you\n"
      "throw darts, daggers or shurikens you can wield\n"
      "them to cause more damage"
      " (<link weapon.html>more...</link>)"));
  KRQuickHelp::add(ITEM(9), i18n("<b>Throw</b>\n\n"
      "Throw a weapon on a monster. That can allow\n"
      "you to kill a monster without being involved\n"
      "in hand-to-hand combat. To cause more damage\n"
      "while throwing darts, daggers and shurikens\n"
      "you can wield them. If you throw arrows you\n"
      "can wield a bow"
      " (<link weapon.html>more...</link>)"));
  KRQuickHelp::add(ITEM(10), i18n("<b>Drop</b>\n\n"
      "Drop an item on the floor. You cannot do it\n"
      "if an item is already on the floor at that\n"
      "place. You should drop useless things as\n"
      "your pack has a limited capacity"));
  KRQuickHelp::add(ITEM(14), i18n("<b>Downstair</b>\n\n"
      "Go to the next level. This button is enabled if\n"
      "you are on the stairs. On the next level you will\n"
      "find new items, more gold but also more dangerous\n"
      "monsters"));
  KRQuickHelp::add(ITEM(15), i18n("<b>Upstair</b>\n\n"
      "Go to the previous level. You can do that only if\n"
      "you have the Amulet of Yendor (which is hidden on\n"
      "the 26th level or below)"));
  KRQuickHelp::add(ITEM(16), i18n("<b>Rest</b>\n\n"
      "Skip a move. You can hold it if you want to rest\n"
      "for some time or push it once if you want to rest\n"
      "for one move"));
  KRQuickHelp::add(ITEM(17), i18n("<b>Search</b>\n\n"
      "Look for a secret passage or trap. To search\n"
      "you should press this button and hold it for\n"
      "some time. Use it near the walls and on corridors\n"
      "ends. It's equivalent to the 's' key "
      " (<link hidden.html>more...</link>)"));
  krqhSetTlTakeOff(tl);
  krqhSetTlLPutOn(tl);
  krqhSetTlRPutOn(tl);
  KRQuickHelp::add(tl, i18n("<b>Toolbar</b>\n\n"
      "Select a button to get help on it"));
}

void krqhSetTlTakeOff(KToolBar *tl)
{
  KRQuickHelp::add(ITEM(11), i18n("<b>Take off</b>\n\n"
      "Take off your current armor. You won't\n"
      "be able to do that if your armor is cursed.\n"
      "You should do this first if you want to\n"
      "wear a new armor"
      " (<link armor.html>more...</link>)"));
}

void krqhSetTlWear(KToolBar *tl)
{
  KRQuickHelp::add(ITEM(11), i18n("<b>Wear</b>\n\n"
      "You can use this button to wear a\n"
      "new armor"
      " (<link armor.html>more...</link>)"));
}

void krqhSetTlLPutOn(KToolBar *tl)
{
  KRQuickHelp::add(ITEM(12), i18n("<b>Put on a ring</b>\n\n"
      "Put on a magic ring on the left hand"
      " (<link ring.html>more...</link>)"));
}

void krqhSetTlRPutOn(KToolBar *tl)
{
  KRQuickHelp::add(ITEM(13), i18n("<b>Put on a ring</b>\n\n"
      "Put on a magic ring on the right hand"
      " (<link ring.html>more...</link>)"));
}

void krqhSetTlLRemove(KToolBar *tl)
{
  KRQuickHelp::add(ITEM(12), i18n("<b>Remove the ring</b>\n\n"
      "Remove the ring from the left hand"
      " (<link ring.html>more...</link>)"));
}

void krqhSetTlRRemove(KToolBar *tl)
{
  KRQuickHelp::add(ITEM(13), i18n("<b>Remove the ring</b>\n\n"
      "Remove the ring from the right hand"
      " (<link ring.html>more...</link>)"));
}

void krqhRemoveTl(KToolBar *tl, int item)
{
  KRQuickHelp::remove(ITEM(item));
}

#undef ITEM

void krqhSetMoreButton(QWidget *more)
{
  KRQuickHelp::add(more, i18n("<b>The more button</b>\n\n"
      "This button is displayed if more then\n"
      "one message has to be displayed in\n"
      "one move. To see the next message\n"
      "press Space or Return."));
}

void krqhSetMsgBar(QWidget *w)
{
  KRQuickHelp::add(w, i18n("<b>The message bar</b>\n\n"
      "All the game messages are displayed here.\n"
      "If the message is in <b>bold</b> it is a current\n"
      "message. If it is normal it's an old message."));
}

void krqhSetStatusItem(QWidget *w, int f)
{
  switch (f)
  {
    case 0:
      KRQuickHelp::add(w, i18n("  <b>Level</b>\n"
        "The level of the Dungeons on which you\n"
        "are. To go to the next level find the\n"
        "stairs and use the downstair button \n"
        "(<link moving.html>more...</link>)"));
      break;
    case 1:
      KRQuickHelp::add(w, i18n("  <b>Gold</b>\n"
        "The amount of gold that you have. Your\n"
	"place in the high scores list will depend\n"
	"on this "
        "(<link general.html>more...</link>)"));
	break;
    case 2:
      KRQuickHelp::add(w, i18n("  <b>Hit points</b>\n"
        "Your hit points shows how healthy you\n"
        "are. If a monster hits you your hit points\n"
        "decrease. If they drop to 0 you die "
        "(<link hp.html>more...</link>)"));
      break;
    case 3:
      KRQuickHelp::add(w, i18n("  <b>Strength</b>\n"
        "If your strength is high your hit force\n"
        "will be a bit higher. The strength can by\n"
	"increased by <link potion.html>magic potions</link> "
        "(<link str.html>more...</link>)"));
      break;
    case 4:
      KRQuickHelp::add(w, i18n("  <b>Armor protection</b>\n"
        "Each point of your armor prtection\n"
        "decreases a bit the monsters hit\n"
        "force (<link armor.html>more...</link>)"));
      break;
    case 5:
      KRQuickHelp::add(w, i18n("  <b>Experience</b>\n"
        "For killing each monster you gain some\n"
        "experience points. If you have more than\n"
        "10, 20, 40, 80, ... points you go to the next\n"
        "experience level. That increase your\n"
        "maximum of hit points the chance of hitting a\n"
        "monster etc. "
        "(<link exp.html>more...</link>)"));
      break;
    case 6:
      KRQuickHelp::addSig(w, &evfilter, SLOT(hungryQh(KQHWnd *, int, int)));
      w->installEventFilter(&evfilter);
      break;
  }
}

void krqhSetStatusBar(KStatusBar *st)
{
  QPoint p=st->mapToGlobal(QPoint(3, 3));
  QWidget *prev=NULL, *w;
  int f=0, y=p.x()+st->width()-6;
  for (; p.x()<=y; p+=QPoint(10, 0))
  {
    w=kapp->widgetAt(p, true);
    if (!w || w==kapp->mainWidget()) break;
    if (w!=st && w!=prev)
    {
      krqhSetStatusItem(w, f);
      f++;
      prev=w;
    }
  }
}

static void compDam(const char *d, int *min, int *max)
{
  int min2=0, max2=0;
  sscanf(d, "%dd%d/%dd%d", min, max, &min2, &max2);
  (*max)*=*min;
  max2*=min2;
  *min+=min2;
  *max+=max2;
}

extern "C"
{
extern char *m_names[];
extern short halluc;
extern object mon_tab[];
int trap_at(int row, int col);
}

QString krqhGetHungryInfo(void)
{
  if (!hunger_str[0]) return i18n("Status bar");
  if (hunger_str[0]=='h') return i18n("  <b>Hungry</b>\n"
    "You are hungry. You may want to <link food.html>eat</link> something");
  if (hunger_str[0]=='w') return i18n("  <b>Weak</b>\n"
    "You are weak because of hunger. You may want\n"
    "to <link food.html>eat</link> something");
  if (hunger_str[0]=='f') return i18n("  <b>Fainting</b>\n"
    "You are fainting because of hunger. If you\n"
    "won't <link food.html>eat</link> something you will die of starvation");
  return NULL;
}

QString krqhGetMonsterInfo(int monid)
{
  QString str, s2;
  object *mon=&mon_tab[monid];
  str="<b>";
  str+=i18n(m_names[monid]);
  str+="</b>";
  if (tolower(str[3])!=('a'+monid) && tolower(str[3])!=m_names[monid][0])
  {
    str+=" (";
    str+=m_names[monid];
    str+=")";
  }
  str+="\n\n";
  if (halluc)
  {
    str+=i18n("You have quaffed a potion of hallucination\n"
              "so what you see is not what the monster really is");
    return str;
  }
  str+=i18n("Base hit points: ");
  str+=s2.setNum(mon->hp_to_kill);
  int maxd, mind;
  compDam(mon->damage, &mind, &maxd);
  if (!(mon->m_flags&STATIONARY))
  {
    ((str+=i18n("\nHit force: "))+=s2.setNum(mind))+="-";
    str+=s2.setNum(maxd);
  }
  str+=i18n("\nExperience gain: ");
  str+=s2.setNum(mon_tab[monid].kill_exp);
  if (mon->m_flags&FLIES)
    str+=i18n("\n\n<b>flies</b>\n"
              "   can move faster");
  if (mon->m_flags&ASLEEP && !(mon->m_flags&WAKENS) && !(mon->m_flags&WANDERS))
    str+=i18n("\n\n<b>sleeps</b>\n"
              "   sleeps all the time unless you\n"
              "   wake him");
  if (mon->m_flags&FREEZES)
    str+=i18n("\n\n<b>freezes</b>\n"
              "   can freeze the player or even\n"
              "   make him die of hypotermia");
  if (mon->m_flags&STINGS)
    str+=i18n("\n\n<b>bites</b>\n"
              "   can decrease the strength of the\n"
              "   player");
  if (mon->m_flags&SEEKS_GOLD)
    str+=i18n("\n\n<b>seeks gold</b>\n"
              "   if not attacked, seeks some gold\n"
              "   and sleeps on it");
  if (mon->m_flags&STEALS_GOLD)
    str+=i18n("\n\n<b>steals gold</b>\n"
              "   steals gold from the player");
  if (mon->m_flags&STEALS_ITEM)
    str+=i18n("\n\n<b>steals items</b>\n"
              "   steals items from the player");
  if (mon->m_flags&RUSTS)
    str+=i18n("\n\n<b>rusts armor</b>\n"
              "   rusts the armor of the player and\n"
              "   makes it weaker");
  if (mon->m_flags&CONFUSES)
    str+=i18n("\n\n<b>confusing gaze</b>\n"
              "   the gaze of that monster can confuse\n"
              "   the player");
  if (mon->m_flags&INVISIBLE)
    str+=i18n("\n\n<b>invisible</b>\n"
              "   it is not visible unless you quaffed a\n"
              "   potion of detect monster, see invisible\n"
              "   or put on a ring of see invisible");
  if (mon->m_flags&IMITATES)
    str+=i18n("\n\n<b>imitates</b>\n"
              "   can imitate an object on the floor");
  if (mon->m_flags&DROPS_LEVEL)
    str+=i18n("\n\n<b>drops levels</b>\n"
              "   can decrease the level of expirience\n"
	      "   of the player");
  if (mon->m_flags&DRAINS_LIFE)
    str+=i18n("\n\n<b>drains life</b>\n"
              "   can decrease the strength or maximal\n"
              "   hit points of the player");
  if (mon->m_flags&FLITS)
    str+=i18n("\n\n<b>flits</b>\n"
              "   moves like a confused monster");
  if (mon->m_flags&STATIONARY)
    str+=i18n("\n\n<b>stationary</b>\n"
              "   it cannot move");
  if (mon->m_flags&HOLDS)
    str+=i18n("\n\n<b>holds</b>\n"
              "   the player cannot move if he is near it");
  if (mon->m_flags&FLAMES)
    str+=i18n("\n\n<b>breathes out fire</b>\n"
              "   can hit the player with a flame");
  return str;
}

QString krqhGetTrapInfo(int trapid)
{
  QString str=NULL;
  if (trapid==TRAP_DOOR)
    str=i18n("<b>trap door</b>\n\n"
        "makes you fall to the level below");
  if (trapid==BEAR_TRAP)
    str=i18n("<b>bear trap</b>\n\n"
        "holds you for a number of moves");
  if (trapid==TELE_TRAP)
    str=i18n("<b>teleport trap</b>\n\n"
        "teleports you to another part of\n"
	"the level");
  if (trapid==DART_TRAP)
    str=i18n("<b>poison dart trap</b>\n\n"
        "hits you with poison darts. They\n"
	"decrease your hit points and sometimes\n"
	"your strength");
  if (trapid==SLEEPING_GAS_TRAP)
    str=i18n("<b>sleeping gas trap</b>\n\n"
        "makes you sleep for a number of moves");
  if (trapid==RUST_TRAP)
    str=i18n("<b>rust trap</b>\n\n"
        "rusts your armor and makes it worse");
  if (str.isNull())
    str=i18n("<b>Error</b>\n\n"
             "No quickhelp for this item");
  return str;
}

inline void itemstr(QString &str, const char *tit, const char *name)
{
  str.sprintf(i18n("<b>%s</b>\n\n"
      "To pick it up move on it\n"
      "                         <link %s.html>more...</link>"), 
      tit, name);
}

QString krqhGetDItemInfo(int whatx, int whaty)
{
  int obj=vdungeon[whaty][whatx]&OBJMASK, fl;
  QString str;
  object *lobj;
  if (wizard && (lobj=object_at(&level_objects, whaty, whatx))!=NULL)
  {
    char ostr[MSGLEN];
    get_desc(lobj, ostr);
    str=ostr;
    return str;
  }
  switch (obj)
  {
    case V_ROGUE:
	str=i18n("<b>Rogue</b>\n\n"
                 "It's you. You can move\n"
                 "using arrow keys");
	break;
    case V_ARMOR:
        itemstr(str, i18n("Armor"), "armor");
	break;
    case V_WEAPON:
	itemstr(str, i18n("Weapon"), "weapon");
	break;
    case V_SCROLL:
	itemstr(str, i18n("Magic scroll"), "scroll");
	break;
    case V_POTION:
        itemstr(str, i18n("Magic Potion"), "potion");
	break;
    case V_GOLD:
        itemstr(str, i18n("Gold"), "general");
	break;
    case V_FOOD:
	itemstr(str, i18n("Food"), "food");
	break;
    case V_WAND:
	itemstr(str, i18n("Wand"), "wand");
	break;
    case V_RING:
        itemstr(str, i18n("Magic Ring"), "ring");
	break;
    case V_AMULET:
        str=i18n("<b>Amulet of Yendor</b>\n\n"
                 "This is what you are seeking in the dungeons\n"
                 "If you pick it up you will be able to go upstair\n"
                 "                                       <link general.html>more...</link>");
	break;
    case V_FLAME:
        str=i18n("<b>Flame</b>\n\n"
                 "A flame. Probably breathed out by a dragon");
	break;
    case V_NOTHING:
        switch(fl=(vdungeon[whaty][whatx]>>FLSH))
	{
	  case V_HORWALL:
	  case V_VERTWALL:
	      str=i18n("<b>Wall</b>\n\n"
                       "A wall around the room. Sometimes there are\n"
                       "<link hidden.html>hidden doors</link> in walls");
	      break;
	  case V_FLOOR:
	  case V_DARK+V_FLOOR:
	      str=i18n("<b>Floor</b>\n\n"
                       "The floor. There is nothing on it");
	      break;
	  case V_STAIRS:
	  case V_STAIRS+V_DARK:
	      str=i18n("<b>Stairs</b>\n\n"
                       "The stairs. You can use them go go to the\n"
                       "next level. Move on them and use the\n"
                       "downstair command");
	      break;
	  case V_TRAP:
	  case V_TRAP+V_DARK:
	      str=krqhGetTrapInfo(trap_at(whaty, whatx));
	      break;
	  case V_TUNNEL:
	      str=i18n("<b>Corridor</b>\n\n"
                       "Probably a corridor from one room to another");
	      break;
	  case V_DOOR:
	      str=i18n("<b>Door</b>\n\n"
                       "Probably an entrance to a corridor");
	      break;
	  case V_NOTHING:
	      str=i18n("<b>Nothing</b>\n\n"
                       "You don't know what is here. Maybe nothing\n"
                       "or an unexplored room");
	      break;
	  default:
	      str=i18n("<b>Error</b>\n\n"
                       "No quickhelp for this item");
	}
	break;
    default:
	if (obj>=V_MONSTER && obj<V_MONSTER+26)
	{
          str=krqhGetMonsterInfo(obj-V_MONSTER);
	  break;
	}
	str=i18n("<b>Error</b>\n\n"
                 "No quickhelp for this item");
	break;
  }
  return str;
}

KQHMouseGrab::KQHMouseGrab(QWidget *parent, const char *name)
:QWidget(parent, name) 
{
  connect(&qhwnd, SIGNAL(hintend()), SLOT(hintend()));
  connect(&qhwnd, SIGNAL(hyperlink(QString)), KRQuickHelp::obj, 
      SLOT(hyperlinkRequested(QString)));
}

void KQHMouseGrab::endgrab()
{
  releaseMouse();
  emit grabEnd();
  delete this;
}

void KQHMouseGrab::hintend()
{
  emit grabEnd();
  delete this;
}

void KQHMouseGrab::mousePressEvent(QMouseEvent *e)
{
  if (e->button()==RightButton)
  {
    endgrab();
    return;
  }
  if (e->button()==LeftButton)
  {
    QWidget *w=kapp->widgetAt(e->globalPos(), true);
    kapp->restoreOverrideCursor();
    if (w==NULL || w==KRQuickHelp::toolbar->getWidget(QHBUTTONID))
    {
      endgrab();
      return;
    }
    const char *str=KRQuickHelp::helpForWidget(w);
    if (str==NULL)
    {
      KRQHSlot *slot=KRQuickHelp::slotForWidget(w);
      if (slot!=NULL)
      {
        disconnect(&qhwnd, SIGNAL(hintend()), this, SLOT(hintend()));
        connect(this, SIGNAL(needQuickHelp(KQHWnd *, int, int)), slot->recv, slot->slot);
	emit needQuickHelp(&qhwnd, e->globalPos().x(), e->globalPos().y());
	disconnect(this, SIGNAL(needQuickHelp(KQHWnd *, int, int)), slot->recv, slot->slot);
        connect(&qhwnd, SIGNAL(hintend()), SLOT(hintend()));
	return;
      }
      str=i18n("No quickhelp for that item.");
    }
    releaseMouse();
    qhwnd.popup(str, e->globalPos().x(), e->globalPos().y());
    return;
  }
}

QIntDict<const char> KRQuickHelp::widgDict;
QIntDict<KRQHSlot> KRQuickHelp::sigDict;
KToolBar *KRQuickHelp::toolbar;
KRQuickHelp *KRQuickHelp::obj;

const char *KRQuickHelp::add(QWidget *w, const char *s)
{
  widgDict.insert((long)w, s);
  return KQuickHelp::add(w, s);
}

void KRQuickHelp::remove(QWidget *w)
{
  widgDict.remove((long)w);
  KQuickHelp::remove(w);
}

void KRQuickHelp::addSig(QWidget *w, const char *name)
{
  addSig(w, w, name);
}

void KRQuickHelp::addSig(QWidget *w, QObject *recv, const char *name)
{
  KRQHSlot *slot=new KRQHSlot;
  CHECK_PTR(slot);
  slot->recv=recv;
  slot->slot=name;
  sigDict.insert((long)w, slot);
}

const char *KRQuickHelp::helpForWidget(QWidget *w)
{
  return widgDict[(long)w];
}

KRQHSlot *KRQuickHelp::slotForWidget(QWidget *w)
{
  return sigDict[(long)w];
}

void KRQuickHelp::addToolButton(KToolBar *tl)
{
  if (!obj) obj=new KRQuickHelp;
  toolbar=tl;
  tl->insertSeparator();
  tl->insertButton(Icon("context_help.xpm"), QHBUTTONID, SIGNAL(clicked()),
    obj, SLOT(buttonClick()), true, i18n("Quickhelp"));
}

void KRQuickHelp::buttonClick()
{
  KQHMouseGrab *gm=new KQHMouseGrab(kapp->mainWidget());
  connect(gm, SIGNAL(grabEnd()), SLOT(grabEnd()));
  toolbar->setToggle(QHBUTTONID, true);
  toolbar->toggleButton(QHBUTTONID);
  gm->hide();
  kapp->setOverrideCursor(KCursor::crossCursor());
  gm->grabMouse();
}

void KRQuickHelp::grabEnd()
{
  toolbar->toggleButton(QHBUTTONID);
  toolbar->setToggle(QHBUTTONID, false);
  QEvent e(Event_Leave);
  kapp->sendEvent(toolbar->getWidget(QHBUTTONID), &e);
}

KRQHEvFilter::KRQHEvFilter()
{
}

void KRQHEvFilter::hungryQh(KQHWnd *wnd, int x, int y)
{
  QString str=krqhGetHungryInfo();
  if (!str.isNull())
    wnd->popup(str, x, y);
}

void KRQHEvFilter::hungryQh()
{
  if (!qhwnd)
  {
    qhwnd=new KQHWnd;
    connect(qhwnd, SIGNAL(hyperlink(QString)), KRQuickHelp::obj, 
        SLOT(hyperlinkRequested(QString)));
  }
  hungryQh(qhwnd, curr.x(), curr.y());
}

bool KRQHEvFilter::eventFilter(QObject *obj, QEvent *ev)
{
  if (ev->type()==Event_MouseButtonPress && hunger_str[0])
  {
    QMouseEvent *mev=(QMouseEvent *)ev;
    if (mev->button()==RightButton)
    {
      QPopupMenu qhmenu;
      curr=mev->globalPos();
      qhmenu.insertItem(i18n("Quickhelp"), this, SLOT(hungryQh()));
      qhmenu.exec(curr);
      return true;
    }
  }
  return false;
}
