#ifndef KCHARFILE_H
#define KCHARFILE_H
#include <qstring.h>

struct obj;

class KCharFile
{
public: 
  KCharFile();
  virtual ~KCharFile();
  virtual char *mask()=0;
  virtual void store(const QString &, short other);
protected:
  virtual void write(const QString &)=0;
  virtual void writeCenter(const QString &)=0;
  virtual void title(const QString &)=0;
  virtual void endTitle()=0;
  virtual void section(const QString &)=0;
  virtual void drawMap()=0;
  virtual void writeObj(obj *, char *)=0;
};

class QFile;
class QTextStream;

class KTextCharFile:public KCharFile
{
public:
  KTextCharFile() {}
  virtual ~KTextCharFile() {}
  virtual char *mask() {return "*.txt";}
  virtual void store(const QString &, short other);
protected:
  QFile *file;
  QTextStream *t;
  virtual char getMapChar(int i);
  virtual void write(const QString &);
  virtual void writeCenter(const QString &);
  virtual void title(const QString &);
  virtual void endTitle() {}
  virtual void section(const QString &);
  virtual void drawMap();
  virtual void writeObj(obj *, char *);
};

class KHTMLCharFile:public KCharFile
{
public:
  KHTMLCharFile() :inTitle(0), parend(0), parcent(0)
    {memset(usePixmaps, 0, sizeof(usePixmaps));}
  virtual ~KHTMLCharFile() {}
  virtual char *mask() {return "*.tgz";}
  virtual void store(const QString &, short other);
protected:
  bool inTitle;
  bool parend, parcent;
  bool usePixmaps[10];
  QFile *file;
  QTextStream *t;
  virtual void setPar(bool newPar, bool center);
  virtual void write(const QString &);
  virtual void writeCenter(const QString &);
  virtual void title(const QString &);
  virtual void endTitle();
  virtual void section(const QString &);
  virtual void drawMap();
  virtual void writeObj(obj *, char *);
};

#endif