#include "optionsdlg.h"
#include <kapp.h>
#include <stdlib.h>
#include <qdir.h>

QString num2str(int val)
{
	QString		retval;
	retval.setNum(val);
	return retval;
}

OptionsDialog::OptionsDialog(QWidget *parent, const char *name)
	: QTabDialog(parent,name,true)
{
	setCancelButton(i18n("Cancel"));
	setOkButton(i18n("OK"));

	Server = new ServerOptions(this);
	addTab(Server,i18n("Server"));
	View = new ViewOptions(this);
	addTab(View,i18n("View"));
	Computer = new ComputerOptions(this);
	addTab(Computer,i18n("Computer"));

	resize(400,300);
}

OptionsDialog::~OptionsDialog()
{
}

void OptionsDialog::setOptions(BoardOptionsStruct *o, bool connected)
{
	Server->NumCols->setText(num2str(o->NumCols).data());
	Server->NumRows->setText(num2str(o->NumRows).data());
	Server->NumPuis->setText(num2str(o->NumPuis).data());
	Server->ServerProgram->setText(o->ServerProgram.data());
	Server->Host->setText(o->Host.data());
	Server->Port->setText(num2str(o->Port).data());
	Server->LocalMode->setChecked(o->LocalMode);
	Server->SocketName->setText(o->SocketName.data());

	View->UsePixmap->setChecked(o->UseBackgroundPixmap);
	View->Color->setColor(o->BackgroundColor);
	QDir	dir(KApplication::kde_wallpaperdir().data());
	const QFileInfoList	*list = dir.entryInfoList("*.jpg",QDir::Files,QDir::Name);
	QFileInfoListIterator	it(*list);
	for (;it.current();++it) {
		View->Pixmap->insertItem(it.current()->fileName().data());
		if (o->BackgroundPixmap == it.current()->absFilePath()) View->Pixmap->setCurrentItem(View->Pixmap->count()-1);
	}
	View->PixmapPreview->setPixmap(QPixmap(o->BackgroundPixmap.data()));

	if (connected) {
		Server->ServerProgram->setEnabled(false);
		Server->Host->setEnabled(false);
		Server->Port->setEnabled(false);
		Server->LocalMode->setEnabled(false);
		Server->SocketName->setEnabled(false);
	}

	Computer->Level->setCurrentItem(o->Level);
}

void OptionsDialog::getOptions(BoardOptionsStruct *o, bool connected)
{
	o->UseBackgroundPixmap = View->UsePixmap->isChecked();
	o->BackgroundColor = View->Color->color();
	o->BackgroundPixmap = (KApplication::kde_wallpaperdir() + "/" + View->Pixmap->currentText());
	o->NumCols = QString(Server->NumCols->text()).toInt();
	o->NumRows = QString(Server->NumRows->text()).toInt();
	o->NumPuis = QString(Server->NumPuis->text()).toInt();
	if (!connected) {
		o->ServerProgram = Server->ServerProgram->text();
		o->Host = Server->Host->text();
		o->Port = QString(Server->Port->text()).toInt();
		o->LocalMode = Server->LocalMode->isChecked();
		o->SocketName = Server->SocketName->text();
	}
	o->Level = Computer->Level->currentItem();
}
