// kplumber.h				-*-c++-*-
//
// This program is free software. See the file COPYING for details.
// Author: Torsten Klein, 1998

#ifndef KPLUMBER_H
#define KPLUMBER_H

#include <stdio.h>

#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kfiledialog.h>
#include <kaccel.h>
#include <kiconloader.h>



#include <qwidget.h>
#include <qdialog.h>
#include <qtablevw.h>
#include <qpixmap.h>
#include <qpushbt.h>
#include <qlcdnum.h>
#include <kmenubar.h>
#include <klined.h>
#include <qlabel.h>

class KPlumber : public QTableView
{
    Q_OBJECT
public:
    KPlumber(QWidget *parent = 0);
//    ~KPlumber();
    void setSize(int rows, int cols);
    void restart();
    int nrows() { return numRows(); }
    int ncols() { return numCols(); }

public slots:
    void markEnds();

signals:
    void moved();
    void won();

protected:
    virtual void paintCell(QPainter *p, int row, int col);
    virtual void mousePressEvent(QMouseEvent *e);
    virtual QSize sizeHint() const;

private:
    void make_table();
    void randomize_table();
    void mark(QPainter *p, int row, int col, int dir);

    int numconns(int row, int col);
    char &state(int row, int col)
        { return states[row * numCols() + col]; }

    char *states;		// 2d matrix, accessor above
    int endpairs;		// number of pipe end pairs
    int connpairs;		// number of connected end pairs
    // (the game ends when connpairs == endpairs)
    bool playing;
    bool marked;

    QPixmap pm[16];
};

class HiScoreWindow : public QWidget
{
    Q_OBJECT
public:
    HiScoreWindow(QWidget *parent = 0);
    void readScores();
    void writeScores();
    void setScores();
    void newScore(int time, int moves, int rows, int cols);
 
    QString getline(FILE *f);
    int getint(FILE *f);
    QString scorefile();

private:
    const int categories = 3;

    QLabel *lbl_fast_name[categories], *lbl_fast_time[categories];
    QLabel *lbl_least_name[categories], *lbl_least_moves[categories];
    QLabel *lbl_largest;

    QString fast_name[categories];
    int fast_time[categories];
    QString least_name[categories];
    int least_moves[categories];
    QString largest_name;
    int largest_rows, largest_cols;
    int largest_time, largest_moves;

    QString last_name;
};

class NewScoreDialog : public QDialog
{
    Q_OBJECT
public:
    NewScoreDialog(QWidget *parent, QString default_name);
    QString playerName();

private:
    QLineEdit *name_ed;
};

class Game : public QWidget
{
    Q_OBJECT
public:
    Game(QWidget *parent = 0);

public slots:
    void step();
    void start();
    void celebrate();
    // menu actions
    void show_hiscores();
    void set_small();
    void set_medium();
    void set_large();
    void set_custom();

protected:
    void timerEvent(QTimerEvent *);

    void setSize(int rows, int cols);

private:
    enum { MENU_SMALL, MENU_MEDIUM, MENU_LARGE, MENU_CUSTOM };
    enum { MENU_MARK };

    int moves;
    int seconds;

    // child widgets
    KPlumber *gb;
    QPushButton *restart;
    QLCDNumber *timedisp;
    QLCDNumber *movedisp;

    QPopupMenu *game_menu;
    QPopupMenu *option_menu;

    HiScoreWindow *hiscorewindow;
};

class SizeDialog : public QDialog
{
    Q_OBJECT
public:
    SizeDialog(QWidget *parent, int default_rows, int default_cols);

    int cols();
    int rows();
    
protected:
    KLined *rows_ed, *cols_ed;
};

#endif // KPLUMBER_H
