#include <qmsgbox.h>
#include <qstring.h>
#include <iostream.h>
#include <stdlib.h>
#include "playfield.h"
#include "pbutton.h"


PlayField::PlayField(QWidget *parent, const char *name): QWidget(parent, name),
  fluidCol(black)
{
  inGame=false;
  playField=new PipeField(100);
  for(int i=0;i<10;i++)
    {
      for(int j=0;j<10;j++)
	{
	  PipeButton *p=new PipeButton(this);
	  playField->insert(10*i+j,p);
          connect( p, SIGNAL(clicked()), SLOT(buttonClicked()));
	  connect( p, SIGNAL(linkFull(PipeButton::Direction)), this, 
		   SLOT(linkFilled(PipeButton::Direction)));
	  connect( p, SIGNAL(pipeBroken()), this, 
		   SLOT(brokenPipe()));
	  p->setGeometry(SQUAREDIM*i,SQUAREDIM*j+10,SQUAREDIM,SQUAREDIM);
	  p->setLink(PipeButton::Empty);
	  p->show();
	}
    }
  nextLink=PipeButton::Empty;
  emit requireLink();
  show();
}

PlayField::~PlayField()
{
  delete(playField);
}


void PlayField::buttonClicked()
{

  if(!inGame) return;
  PipeButton *p=(PipeButton*)sender();

  // cerr << "Got here! " << endl;
  // cerr << i << endl;

  if(nextLink==PipeButton::Bomb && p->getVFill()+p->getHFill()==0)
  {
    p->setLink(PipeButton::Empty);
    emit requireLink();
  } 
  else if(p->getLink()==PipeButton::Empty)
  {
    p->setLink(nextLink);
    emit requireLink();
  }
}

void PlayField::linkToBuild(PipeButton::LinkType which)
{
  nextLink=which;
}

void PlayField::gameStarted()
{
  // Clear the minig area. 
  for(int i=0;i<100;i++) 
    {
      playField->at(i)->setLink(PipeButton::Empty);
      playField->at(i)->setFluidCol(fluidCol);
    }
  flowArea=((rand()%8)+1)*10+(rand()%8)+1;

    PipeButton::Direction temp[]={PipeButton::North,PipeButton::East,
				   PipeButton::South,PipeButton::West};

  playField->at(flowArea)->setLink(PipeButton::Start);
  playField->at(flowArea)->setStartDir(flowDir=temp[rand()%4]);
  inGame=true;
  
  /*
  playField->at(0)->setLink(PipeButton::Down);
  playField->at(10)->setLink(PipeButton::Down);
  playField->at(1)->setLink(PipeButton::Right);
  playField->at(11)->setLink(PipeButton::Right);
  playField->at(2)->setLink(PipeButton::Downright);
  playField->at(12)->setLink(PipeButton::Downright);
  playField->at(3)->setLink(PipeButton::Leftup);
  playField->at(13)->setLink(PipeButton::Leftup);
  playField->at(4)->setLink(PipeButton::Upright);
  playField->at(14)->setLink(PipeButton::Upright);
  playField->at(5)->setLink(PipeButton::Leftdown);
  playField->at(15)->setLink(PipeButton::Leftdown);
  playField->at(6)->setLink(PipeButton::Cross);
  playField->at(16)->setLink(PipeButton::Cross);
  playField->at(7)->setLink(PipeButton::Cross);
  playField->at(17)->setLink(PipeButton::Cross);

  playField->at(20)->setLink(PipeButton::Start);
  playField->at(20)->setStartDir(PipeButton::North);
  playField->at(21)->setLink(PipeButton::Start);
  playField->at(21)->setStartDir(PipeButton::South);
  playField->at(22)->setLink(PipeButton::Start);
  playField->at(22)->setStartDir(PipeButton::West);
  playField->at(23)->setLink(PipeButton::Start);
  playField->at(23)->setStartDir(PipeButton::East);
  */
}

void PlayField::linkFilled(PipeButton::Direction d)
{
  switch(d)
    {
    case PipeButton::North:
      flowArea--;
      break;
    case PipeButton::South:
      flowArea++;
      break;
    case PipeButton::West:
      flowArea-=10;
      break;
    case PipeButton::East:
      flowArea+=10;
      break;
    }
  flowDir=d;
}


void PlayField::flowEvent()
{
  if(flowArea<0 || flowArea>99) emit gameOver();
  else
    {
      playField->at(flowArea)->flow(flowDir);
      emit scoreChanged(5);
    }
  /*
  playField->at(0)->flow(PipeButton::South);
  playField->at(10)->flow(PipeButton::North);
  playField->at(1)->flow(PipeButton::West);
  playField->at(11)->flow(PipeButton::East);
  playField->at(2)->flow(PipeButton::South);
  playField->at(12)->flow(PipeButton::West);
  playField->at(3)->flow(PipeButton::South);
  playField->at(13)->flow(PipeButton::East);
  playField->at(4)->flow(PipeButton::North);
  playField->at(14)->flow(PipeButton::West);
  playField->at(5)->flow(PipeButton::North);
  playField->at(15)->flow(PipeButton::East);
  playField->at(6)->flow(PipeButton::North);
  playField->at(16)->flow(PipeButton::South);
  playField->at(7)->flow(PipeButton::West);
  playField->at(17)->flow(PipeButton::East);

  playField->at(21)->flow(PipeButton::South);
  playField->at(20)->flow(PipeButton::North);
  playField->at(22)->flow(PipeButton::West);
  playField->at(23)->flow(PipeButton::East);
  */
}

void PlayField::brokenPipe()
{
  inGame=false;
  emit gameOver();
}

void PlayField::closeEvent(QCloseEvent *e)
{
  e->accept();
}

void PlayField::setFluid(Fluid x)
{
  switch(x)
    {
    case Oil: fluidCol=black; break;
    case Water: fluidCol=blue; break;
    case Acid: fluidCol=green; break;
    }
}
