/***************************************************************************
                          kscore.cpp  -  description
                             -------------------
    begin                : Mon Apr 24 2000
    copyright            : (C) 2000 by Norbert Andres
    email                : NAndres@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kscore.h"
#include <kapp.h>
#include <qmessagebox.h>

KScore::KScore(QWidget *parent, int wg, int lg, int sg, int hs): QDialog(parent, 0, TRUE)
{
	initDialog();
	setCaption(i18n("Statistic"));
	QFont f( title->font() );
	QFontInfo fi(f);
	f.setPointSize(fi.pointSize()+4);
	f.setBold(TRUE);
	title->setFont(f);
	title->setAlignment(AlignCenter);
	title->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	title->setBackgroundMode( QWidget::PaletteMidlight );
  title->setMinimumSize(0,0);
  title->setAutoResize(true);
	title->setFixedSize( title->sizeHint()+QSize(20, 5) );
	int w = title->width();
	int h = title->height();
	int x = (this->width()-title->width())/2;
	title->setGeometry(x,title->y(),w,h);
	lWonGames->setNum(wg);
	lLostGames->setNum(lg);
	lStoppedGames->setNum(sg);
	lHighscore->setNum(hs);
	newLostG=lg;
	newWonG=wg;
	newStoppedG=sg;
	newHScore=hs;
	connect(clearButton,SIGNAL(clicked()),this,SLOT(clearButtonClicked()));
	connect(closeButton,SIGNAL(clicked()),this,SLOT(closeButtonClicked()));
	exec();
}

KScore::~KScore()
{
}

void KScore::closeButtonClicked()
{
	close();
}

void KScore::clearButtonClicked()
{
	QMessageBox *mb = new QMessageBox(i18n("Attention!"), i18n("Do you really want to delete the scores?"), QMessageBox::Warning,
			QMessageBox::No, QMessageBox::Yes, QMessageBox::Cancel, this, 0, TRUE, 0 );
	switch (mb->exec())
	{
		case QMessageBox::Yes:
			clearScore();
			break;
		default:
			break;
	}
}

void KScore::clearScore()
{
	newLostG=newWonG=newStoppedG=newHScore=0;
	lWonGames->setNum(newWonG);
	lLostGames->setNum(newLostG);
	lStoppedGames->setNum(newStoppedG);
	lHighscore->setNum(newHScore);	
}