/***************************************************************************
                          dlgoptioncolors.cpp
                          -------------------
    description          : Color Options Dialog Class
    begin                : Mon Sep 20 1999
    copyright            : (C) 1999 by Stephan Uhlmann
                                       Andre Alexander Bell
    email                : suhlmann@gmx.de
                           andre.bell@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include "dlgoptioncolors.h"

DlgOptionColors::DlgOptionColors(QWidget *parent, const char *name, int i) : QDialog(parent,name,true){

	setCaption(i18n("Colors"));

	iType = i;	
	initDialog();

// colors are global and do not depend on the mud settings (which InterpretType is)
// even if mud is set to "no colors" it should be possible to change the colors
// (unless we save the colors in the mud settings, too which isn't a good idea)
//	slotInterpretType();

	connect( ok_Button, SIGNAL(clicked()), SLOT(accept()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(reject()) );
	connect( defaults_Button, SIGNAL(clicked()), SLOT(slotDefaults()) );
	connect( Reverse_Button, SIGNAL(clicked()), SLOT(slotReverse()) );
}

DlgOptionColors::~DlgOptionColors(){

	// no need to delete widgets that are children of this class
	// since they will be destroyed when destroying the parent
	// see: ~QObject()
}


QColor DlgOptionColors::getForegroundColor()
{
	return foreground_KColorButton->color();
}

QColor DlgOptionColors::getBackgroundColor()
{
	return background_KColorButton->color();
}

QColor DlgOptionColors::getLocalEchoColor()
{
	return localEchoColor_KColorButton->color();
}

QColor DlgOptionColors::getDebugHighlightColor()
{
	return debugHighlight_KColorButton->color();
}

QColor DlgOptionColors::getANSIColor(int ANSIColor)
{
  switch (ANSIColor)
  {
    case BLACK: return ansiBlack_KColorButton->color();
    case DARK_RED: return ansiDarkRed_KColorButton->color();
    case DARK_GREEN: return ansiDarkGreen_KColorButton->color();
    case DARK_YELLOW: return ansiDarkYellow_KColorButton->color();
    case DARK_BLUE: return ansiDarkBlue_KColorButton->color();
    case DARK_MAGENTA: return ansiDarkMagenta_KColorButton->color();
    case DARK_CYAN: return ansiDarkCyan_KColorButton->color();
    case DARK_WHITE: return ansiDarkWhite_KColorButton->color();
    case GRAY: return ansiGray_KColorButton->color();
    case LIGHT_RED: return ansiLightRed_KColorButton->color();
    case LIGHT_GREEN: return ansiLightGreen_KColorButton->color();
    case LIGHT_YELLOW: return ansiLightYellow_KColorButton->color();
    case LIGHT_BLUE: return ansiLightBlue_KColorButton->color();
    case LIGHT_MAGENTA: return ansiLightMagenta_KColorButton->color();
    case LIGHT_CYAN: return ansiLightCyan_KColorButton->color();
    case LIGHT_WHITE: return ansiLightWhite_KColorButton->color();
    default: return QColor(0,0,0);
  }
}

void DlgOptionColors::setForegroundColor(QColor fgc)
{
	foreground_KColorButton->setColor(fgc);
}

void DlgOptionColors::setBackgroundColor(QColor bgc)
{
	background_KColorButton->setColor(bgc);
}

void DlgOptionColors::setLocalEchoColor(QColor bgc)
{
	localEchoColor_KColorButton->setColor(bgc);
}

void DlgOptionColors::setDebugHighlightColor(QColor color)
{
	debugHighlight_KColorButton->setColor(color);
}

void DlgOptionColors::setANSIColor(int ANSIColor, QColor color)
{
  switch (ANSIColor)
  {
    case BLACK: ansiBlack_KColorButton->setColor(color); break;
    case DARK_RED: ansiDarkRed_KColorButton->setColor(color); break;
    case DARK_GREEN: ansiDarkGreen_KColorButton->setColor(color); break;
    case DARK_YELLOW: ansiDarkYellow_KColorButton->setColor(color); break;
    case DARK_BLUE: ansiDarkBlue_KColorButton->setColor(color); break;
    case DARK_MAGENTA: ansiDarkMagenta_KColorButton->setColor(color); break;
    case DARK_CYAN: ansiDarkCyan_KColorButton->setColor(color); break;
    case DARK_WHITE: ansiDarkWhite_KColorButton->setColor(color); break;
    case GRAY: ansiGray_KColorButton->setColor(color); break;
    case LIGHT_RED: ansiLightRed_KColorButton->setColor(color); break;
    case LIGHT_GREEN: ansiLightGreen_KColorButton->setColor(color); break;
    case LIGHT_YELLOW: ansiLightYellow_KColorButton->setColor(color); break;
    case LIGHT_BLUE: ansiLightBlue_KColorButton->setColor(color); break;
    case LIGHT_MAGENTA: ansiLightMagenta_KColorButton->setColor(color); break;
    case LIGHT_CYAN: ansiLightCyan_KColorButton->setColor(color); break;
    case LIGHT_WHITE: ansiLightWhite_KColorButton->setColor(color); break;
  }

}

void DlgOptionColors::setBgColor(int BgColor, QColor color)
{
  switch (BgColor)
  {
    case BG_BLACK: bgBlack_Color->setColor(color); break;
    case BG_RED: bgRed_Color->setColor(color); break;
    case BG_GREEN: bgGreen_Color->setColor(color); break;
    case BG_YELLOW: bgYellow_Color->setColor(color); break;
    case BG_BLUE: bgBlue_Color->setColor(color); break;
    case BG_MAGENTA: bgMagenta_Color->setColor(color); break;
    case BG_CYAN: bgCyan_Color->setColor(color); break;
    case BG_WHITE: bgWhite_Color->setColor(color); break;
  }
}

QColor DlgOptionColors::getBgColor(int BgColor)
{
	switch (BgColor)
	{
		case BG_BLACK: return bgBlack_Color->color();
		case BG_RED: return bgRed_Color->color();
		case BG_GREEN: return bgGreen_Color->color();
		case BG_YELLOW: return bgYellow_Color->color();
		case BG_BLUE: return bgBlue_Color->color();
		case BG_MAGENTA: return bgMagenta_Color->color();
		case BG_CYAN: return bgCyan_Color->color();
		case BG_WHITE: return bgWhite_Color->color();
		default: return QColor(0,0,0);
	}
}

void DlgOptionColors::slotDefaults()
{
	ansiBlack_KColorButton->setColor(QColor(0, 0, 0));
	ansiDarkRed_KColorButton->setColor(QColor(128, 0, 0));
	ansiDarkGreen_KColorButton->setColor(QColor(0, 128, 0));
	ansiDarkYellow_KColorButton->setColor(QColor(128, 128, 0));
	ansiDarkBlue_KColorButton->setColor(QColor(0, 0, 128));
	ansiDarkMagenta_KColorButton->setColor(QColor(128, 0, 128));
	ansiDarkCyan_KColorButton->setColor(QColor(0, 128, 128));
	ansiDarkWhite_KColorButton->setColor(QColor(192, 192, 192));
	ansiGray_KColorButton->setColor(QColor(128, 128, 128));
	ansiLightRed_KColorButton->setColor(QColor(255, 0, 0));
	ansiLightGreen_KColorButton->setColor(QColor(0, 255, 0));
	ansiLightYellow_KColorButton->setColor(QColor(255, 255, 0));
	ansiLightBlue_KColorButton->setColor(QColor(0, 0, 255));
	ansiLightMagenta_KColorButton->setColor(QColor(255, 0, 255));
	ansiLightCyan_KColorButton->setColor(QColor(0, 255, 255));
	ansiLightWhite_KColorButton->setColor(QColor(255, 255, 255));

	bgBlack_Color->setColor(QColor(0, 0, 0));
	bgRed_Color->setColor(QColor(128, 0, 0));
	bgGreen_Color->setColor(QColor(0, 128, 0));
	bgYellow_Color->setColor(QColor(128, 128, 0));
	bgBlue_Color->setColor(QColor(0, 0, 128));
	bgMagenta_Color->setColor(QColor(128, 0, 128));
	bgCyan_Color->setColor(QColor(0, 128, 128));
	bgWhite_Color->setColor(QColor(192, 192, 192));
}

void DlgOptionColors::slotReverse()
{
  QColor TempColor;

  //switch Black-Colors
  TempColor=ansiBlack_KColorButton->color();
	ansiBlack_KColorButton->setColor(getANSIColor(GRAY));
	ansiGray_KColorButton->setColor(TempColor);
	
  //switch Red-Colors
  TempColor=ansiDarkRed_KColorButton->color();
	ansiDarkRed_KColorButton->setColor(getANSIColor(LIGHT_RED));
	ansiLightRed_KColorButton->setColor(TempColor);

  //switch Green-Colors
	TempColor=ansiDarkGreen_KColorButton->color();
	ansiDarkGreen_KColorButton->setColor(getANSIColor(LIGHT_GREEN));
	ansiLightGreen_KColorButton->setColor(TempColor);
	
  //switch Yellow-Colors
  TempColor=ansiDarkYellow_KColorButton->color();
	ansiDarkYellow_KColorButton->setColor(getANSIColor(LIGHT_YELLOW));
	ansiLightYellow_KColorButton->setColor(TempColor);
	
  //switch Blue-Colors
  TempColor=ansiDarkBlue_KColorButton->color();
	ansiDarkBlue_KColorButton->setColor(getANSIColor(LIGHT_BLUE));
	ansiLightBlue_KColorButton->setColor(TempColor);
	
  //switch Magenta-Colors
  TempColor=ansiDarkMagenta_KColorButton->color();
	ansiDarkMagenta_KColorButton->setColor(getANSIColor(LIGHT_MAGENTA));
	ansiLightMagenta_KColorButton->setColor(TempColor);
	
  //switch Cyan-Colors
  TempColor=ansiDarkCyan_KColorButton->color();
	ansiDarkCyan_KColorButton->setColor(getANSIColor(LIGHT_CYAN));
	ansiLightCyan_KColorButton->setColor(TempColor);
	
  //switch White-Colors
  TempColor=ansiDarkWhite_KColorButton->color();
	ansiDarkWhite_KColorButton->setColor(getANSIColor(LIGHT_WHITE));
	ansiLightWhite_KColorButton->setColor(TempColor);
}

void DlgOptionColors::slotInterpretType()
{
	bool flag=((iType== 0) || (iType==1));
	
	ansiBlack_KColorButton->setEnabled(flag);
	ansiDarkRed_KColorButton->setEnabled(flag);
	ansiDarkGreen_KColorButton->setEnabled(flag);
	ansiDarkYellow_KColorButton->setEnabled(flag);
	ansiDarkBlue_KColorButton->setEnabled(flag);
	ansiDarkMagenta_KColorButton->setEnabled(flag);
	ansiDarkCyan_KColorButton->setEnabled(flag);
	ansiDarkWhite_KColorButton->setEnabled(flag);
	ansiGray_KColorButton->setEnabled(flag);
	ansiLightRed_KColorButton->setEnabled(flag);
	ansiLightGreen_KColorButton->setEnabled(flag);
	ansiLightYellow_KColorButton->setEnabled(flag);
	ansiLightBlue_KColorButton->setEnabled(flag);
	ansiLightMagenta_KColorButton->setEnabled(flag);
	ansiLightCyan_KColorButton->setEnabled(flag);
	ansiLightWhite_KColorButton->setEnabled(flag);
	bgBlack_Color->setEnabled(flag);
	bgRed_Color->setEnabled(flag);
	bgGreen_Color->setEnabled(flag);
	bgYellow_Color->setEnabled(flag);
	bgBlue_Color->setEnabled(flag);
	bgMagenta_Color->setEnabled(flag);
	bgCyan_Color->setEnabled(flag);
	bgWhite_Color->setEnabled(flag);
	
	black_Label->setEnabled(flag);
	darkRed_Label->setEnabled(flag);
	darkGreen_Label->setEnabled(flag);
	darkYellowD_Label->setEnabled(flag);
	darkBlue_Label->setEnabled(flag);
	darkMagenta_Label->setEnabled(flag);
	darkCyan_Label->setEnabled(flag);
	darkWhite_Label->setEnabled(flag);
	gray_Label->setEnabled(flag);
	lightRed_Label->setEnabled(flag);
	lightGreen_Label->setEnabled(flag);
	lightYellow_Label->setEnabled(flag);
	lightBlue_Label->setEnabled(flag);
	lightMagenta_Label->setEnabled(flag);
	lightCyan_Label->setEnabled(flag);
	lightWhite_Label->setEnabled(flag);
	
	bgBlack_Label->setEnabled(flag);
	bgRed_Label->setEnabled(flag);
	bgGreen_Label->setEnabled(flag);
	bgYellow_Label->setEnabled(flag);
	bgBlue_Label->setEnabled(flag);
	bgMagenta_Label->setEnabled(flag);
	bgCyan_Label->setEnabled(flag);
	bgWhite_Label->setEnabled(flag);
	
	defaults_Button->setEnabled(flag);
	Reverse_Button->setEnabled(flag);
}
