/***************************************************************************
                          kmastermind.h  -  description
                             -------------------
    begin                : Don Aug 17 11:36:09 MEST 2000
    copyright            : (C) 2000 by Armin Dworschak
    email                : armind@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMASTERMIND_H
#define KMASTERMIND_H

#include <kapp.h>                     // KDE-Zeugs
#include <ktmainwindow.h>
#include <kpixmap.h>
#include <klocale.h>

#include <qwidget.h>                  // Qt-Zeugs
#include <qpopupmenu.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qpalette.h>
#include <qcolor.h>
#include <qpainter.h>

#include <stdlib.h>                  // C++-Zeugs
#include <time.h>

enum StatusBarItem {Farbe};

class Kmastermind : public KTMainWindow {
  Q_OBJECT

public: 
  /** constructor */
  Kmastermind();
  /** destructor */
  ~Kmastermind();

 signals:
  void clicked(int);  // Farbe auswaehlen

 private slots:
  void auswahl(int);  // slot zu ausgewaehlter Farbe
  void slotNormal();  // Spiel Kids gedrueckt    Den Variablen Werte geben
  void slotExtrem();  // Spiel Young gedrueckt              "
  void slotAddults(); // Spiel Addults gedrueckt            "

 protected:
  virtual void paintEvent (QPaintEvent*);      // neu zeichnen, falls mal
																							 //	verdeckt, oder so
  virtual void mouseDoubleClickEvent(QMouseEvent* e); // Position auswaehlen
																											// und verarbeiten

 private:
  KPixmap buffer;
  QColor braun;        // Eigene Farbe
  QPoint p;            // Position des MausDoppelklicks
  int spielart;        // Zeilenanzahl fuer Kids, Young, Addults
  int spiel[6], wahl[6], hilf[6]; // Felder fuer die Zufallsfarben und die
																	// Wahl des Spielers
  bool control[6];                // Alle Felder belegt?
  int xkr,ykr, xb;            		// Variablen fuer Positionen
  int id;     								    // Buttongroup-ID
  int xrahm, yrahm, xnull, ynull, kreis, dim;      // Geometrie
  int bl, wh, halt, z, farbe;                      // Zum Auswerten (vor allem)
  long sek;                                        // Zufallsgenerator
  bool malen;                                      // Malen ja oder nein
  void newgame();          // Leeres Spielfeld zeichnen,
													 // Zufallsfarben erzeugen
  void auswerten();        //   Nomen
  void gewonnen();         //   ist hier
  void verloren();         //   Omen
  void zeigen();           // Enthuellt die verborgenen Zufallsfarben

  QPainter brett, puffer;  // Spielfeld
  QPopupMenu* spielmenu;
  QPushButton *weiss, *rot, *gelb, *blau, *gruen, *schwarz,*violett, *orange;
};
#endif

