/***************************************************************************
                          kmastermind.cpp  -  description
                             -------------------
    begin                : Don Aug 17 11:36:09 MEST 2000
    copyright            : (C) 2000 by Armin Dworschak
    email                : armind@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kmastermind.h"

Kmastermind::Kmastermind(){
 /*
 * Leeres Spielfeld zeichnen und Menuleiste+Statusleiste+Farbknoepfe
 *	 einrichten
 */
 spielmenu = new QPopupMenu;
 spielmenu->insertItem(i18n("New Game: For &Kids"), this, SLOT(slotNormal()));
 spielmenu->insertItem(i18n("New Game: For &Young People"), this, SLOT(slotExtrem()));
 spielmenu->insertItem(i18n("New Game: &Addults only"), this, SLOT(slotAddults()));
 spielmenu->insertItem(i18n("&Quit"), kapp, SLOT(quit()));

 menuBar()->insertItem(i18n("&Game"), spielmenu);
 menuBar()->insertSeparator();
 menuBar()->insertItem(i18n("&Help"),kapp->getHelpMenu(true,
			i18n("This is the world-famous Kmastermind 1.0\n"
			 "Copyright 2000 by Armin Dworschak\n"
			 "Comments are welcome: armind@web.de\n")));

 statusBar()->insertItem(i18n("Welcome"), Farbe);

 QColor braun (165, 42, 42);
 setPalette(QPalette(QColor(braun)));

  QButtonGroup* farbwahl = new QButtonGroup();
  farbwahl->setPalette(QPalette(QColor(braun)));
  xb=0;
  weiss = new QPushButton(this);
  weiss->setPalette(QPalette(QColor(white)));
  weiss->setGeometry(4+xb*34,520-statusBar()->height()-37, 32, 35);
  weiss->show();
  weiss->setEnabled(false);
  farbwahl->insert(weiss) ;
  xb++;
  rot = new QPushButton(this);
  rot->setPalette(QPalette(QColor(red)));
  rot->setGeometry(4+xb*34,520-statusBar()->height()-37, 32, 35);
  rot->setEnabled(false);
  rot->show();
  farbwahl->insert(rot) ;
  xb++;
  gelb = new QPushButton(this);
  gelb->setPalette(QPalette(QColor(yellow)));
  gelb->setGeometry(4+xb*34,520-statusBar()->height()-37, 32, 35);
  gelb->setEnabled(false);
  gelb->show();
  farbwahl->insert(gelb);
	xb++;
  blau = new QPushButton(this);
  blau->setPalette(QPalette(QColor(blue)));
  blau->setGeometry(4+xb*34,520-statusBar()->height()-37, 32 ,35);
  blau->setEnabled(false);
  blau->show();
  farbwahl->insert(blau) ;
  xb++;
  gruen = new QPushButton(this);
  gruen->setPalette(QPalette(QColor(green)));
  gruen->setGeometry(4+xb*34,520-statusBar()->height()-37, 32, 35);
  gruen->setEnabled(false);
  gruen->show();
  farbwahl->insert(gruen) ;
  xb++;
  schwarz = new QPushButton(this);
  schwarz->setPalette(QPalette(QColor(darkGray)));
  schwarz->setGeometry(4+xb*34,520-statusBar()->height()-37, 32, 35);
  schwarz->setEnabled(false);
  schwarz->show();
  farbwahl->insert(schwarz) ;
 	xb++;
 	violett = new QPushButton(this);
 	violett->setPalette(QPalette(QColor(magenta)));
 	violett->setGeometry(4+xb*34,520-statusBar()->height()-37,32, 35);
  violett->setEnabled(false);
	violett->show();
	farbwahl->insert(violett) ;
	xb++;
	orange = new QPushButton(this);
	orange->setPalette(QPalette(QColor(cyan)));
	orange->setGeometry(4+xb*34,520-statusBar()->height()-37,32,35);
  orange->setEnabled(false);
	orange->show();
	farbwahl->insert(orange) ;

 QObject::connect(farbwahl, SIGNAL(clicked(int)),
  this, SLOT(auswahl(int))) ;
	slotNormal();

}

Kmastermind::~Kmastermind(){
}

void Kmastermind::slotNormal()
 {
 /*
 * Variablen fuer Spiel Normal festlegen
 */
 spielart=10;
 xrahm=180;
 xnull=(280-180)/2;
 yrahm=340;
 ynull=520-yrahm-statusBar()->height()-80;
 dim=30;
 kreis=26;
 halt=4;
 newgame();       // Spiel starten
 }

void Kmastermind::slotExtrem()
 {
 /*
 * Variablen fuer Spiel Extrem festlegen
 */
 spielart=12;
 xrahm=180;
 xnull=(280-180)/2;
 yrahm=400;
 ynull=520-yrahm-statusBar()->height()-60;
 dim=30;
 kreis=26;
 halt=4;
 newgame();         // Spiel starten
 }

void Kmastermind::slotAddults()
 {
 spielart=15;
 xrahm=234;
 xnull=(280-234)/2;
 yrahm=420;
 ynull=520-yrahm-statusBar()->height()-45;
 dim=26;
 kreis=22;
 halt=6;
 newgame();         // Spiel starten
 }

void Kmastermind::newgame()
 {
 /*
 * Buttons aktivieren, eventuell umpositionieren und Spielfeld zeichnen
 */
  weiss->setEnabled(true);
	rot->setEnabled(true);
	gelb->setEnabled(true);
	blau->setEnabled(true);
  gruen->setEnabled(true);
  schwarz->setEnabled(true);

 if(spielart==10)
  {
	xb=0;
  weiss->move(39+xb*34, 520-statusBar()->height()-70);
  xb++;
	rot->move(39+xb*34, 520-statusBar()->height()-70);
	xb++;
	gelb->move(39+xb*34, 520-statusBar()->height()-70);
	xb++;
	blau->move(39+xb*34, 520-statusBar()->height()-70);
	xb++;
	gruen->move(39+xb*34, 520-statusBar()->height()-70);
	xb++;
	schwarz->move(39+xb*34, 520-statusBar()->height()-70);
	violett->hide();
  orange->hide();
  violett->setEnabled(false);
  orange->setEnabled(false);
	}
 else
	{
	xb=0;
	weiss->move(4+xb*34, 520-statusBar()->height()-37);
	xb++;
	rot->move(4+xb*34, 520-statusBar()->height()-37);
	xb++;
	gelb->move(4+xb*34, 520-statusBar()->height()-37);
	xb++;
	blau->move(4+xb*34, 520-statusBar()->height()-37);
	xb++;
	gruen->move(4+xb*34, 520-statusBar()->height()-37);
	xb++;
	schwarz->move(4+xb*34, 520-statusBar()->height()-37);
	violett->show();
  orange->show();
  violett->setEnabled(true);
  orange->setEnabled(true);	
	}


 QColor braun (165, 42, 42);               // Spielfeld zeichen
 buffer.resize(280,520);
 brett.begin(this);
 puffer.begin(&buffer);
 brett.setBrush(braun);
 puffer.setBrush(braun);
 brett.drawRect(0,0,280,520);
 puffer.drawRect(0,0,280,520);

 brett.setPen(black);
 puffer.setPen(black);
 brett.drawRect(xnull-2,ynull-2,xrahm+4, yrahm+4);
 puffer.drawRect(xnull-2,ynull-2,xrahm+4, yrahm+4);
 brett.drawRect(xnull,ynull,xrahm,yrahm);
 puffer.drawRect(xnull,ynull,xrahm,yrahm);

 brett.setPen(white);
 puffer.setPen(white);
 brett.drawLine(xnull+1,ynull+yrahm-spielart*dim-1,xnull+xrahm-2,ynull+yrahm-spielart*dim-1);
 puffer.drawLine(xnull+1,ynull+yrahm-spielart*dim-1,xnull+xrahm-2,ynull+yrahm-spielart*dim-1);
 brett.drawLine(xnull+halt*dim+1,ynull+yrahm-spielart*dim-1,xnull+halt*dim+1,ynull+yrahm-2);
 puffer.drawLine(xnull+halt*dim+1,ynull+yrahm-spielart*dim-1,xnull+halt*dim+1,ynull+yrahm-2);

 switch (spielart)
  {
  case 10:
	for(int y=1; y<5; y++)
		{
		brett.drawLine(xnull+dim*y,ynull+yrahm-spielart*dim ,xnull+dim*y,ynull+yrahm-2) ;
		puffer.drawLine(xnull+dim*y,ynull+yrahm-spielart*dim,xnull+dim*y,ynull+yrahm-2);
		}
 	for(int x=1; x<11; x++)
		{
		brett.drawLine(xnull+1,ynull+yrahm-dim*x,xnull+xrahm-2,ynull+yrahm-dim*x);
		puffer.drawLine(xnull+1,ynull+yrahm-dim*x,xnull+xrahm-2,ynull+yrahm-dim*x);
		}
  break;
  case 12:
	for(int y=1; y<5; y++)
		{
		brett.drawLine(xnull+dim*y,ynull+yrahm-spielart*dim ,xnull+dim*y,ynull+yrahm-2) ;
		puffer.drawLine(xnull+dim*y,ynull+yrahm-spielart*dim,xnull+dim*y,ynull+yrahm-2);
		}
 	for(int x=1; x<13; x++)
		{
		brett.drawLine(xnull+1,ynull+yrahm-dim*x,xnull+xrahm-2,ynull+yrahm-dim*x);
		puffer.drawLine(xnull+1,ynull+yrahm-dim*x,xnull+xrahm-2,ynull+yrahm-dim*x);
		}
  break;
  case 15:
	for(int y=1; y<7; y++)
		{
		brett.drawLine(xnull+dim*y,ynull+yrahm-spielart*dim ,xnull+dim*y,ynull+yrahm-2) ;
		puffer.drawLine(xnull+dim*y,ynull+yrahm-spielart*dim,xnull+dim*y,ynull+yrahm-2);
		}
 	for(int x=1; x<16; x++)
		{
		brett.drawLine(xnull+1,ynull+yrahm-dim*x,xnull+xrahm-2,ynull+yrahm-dim*x);
		puffer.drawLine(xnull+1,ynull+yrahm-dim*x,xnull+xrahm-2,ynull+yrahm-dim*x);
		}
	break;
  }

 brett.drawRect(xnull+3,ynull+2,halt*dim-2,dim);
 puffer.drawRect(xnull+3,ynull+2,halt*dim-2,dim);	
 brett.end();
 puffer.end();             // Hier haben wir endlich fertig

 /*
 * Computer waehlt die Zufallsfarben
 */

 time(&sek);
 srand((unsigned)sek);
 for(int i=0; i<halt; i++)
	{
	if (spielart==12)
		{
		spiel[i]=rand()%(halt+4)+1;
		}
		else
		{
 		spiel[i]=rand()%(halt+2)+1;
		}
	}

 farbe=0;                                // Alles zuruecksetzen
 xkr=0; ykr=0;
 for (int i=0; i<halt; i++)
		{
		control[i]=false;
		}
	z=0;
 }




void Kmastermind::mouseDoubleClickEvent( QMouseEvent* event)
 {
 /*
 * MausDoppelKlick verarbeiten: 1. Testen ob Farbe gewaehlt
 *                              2.    "   ob Doppelklick an erlaubter Stelle
 *                              3. Farbe an gewaehlte Stelle malen
 *                              4, Wenn Reihe voll ->auswerten
 */
 p=event->pos();
 statusBar()->changeItem(i18n("Please, choose a new color"), Farbe);
 if (farbe!=0 && (p.ry()<(ynull+yrahm-ykr*dim) && p.ry()>(ynull+yrahm-(ykr+1)*dim)))
	{
  if((p.rx()-xnull)<dim){xkr=0;malen=true;}
		else if((p.rx()-xnull)<dim*2){xkr=1;malen=true;}
			else if((p.rx()-xnull)<dim*3){xkr=2;malen=true;}
				else if((p.rx()-xnull)<dim*4){xkr=3;malen=true;}
					else if((p.rx()-xnull)<dim*5 && halt==6){xkr=4;malen=true;}
						else if((p.rx()-xnull)<dim*6 && halt==6){xkr=5;malen=true;}

  if(malen)
  	{
    brett.begin(this);
    puffer.begin(&buffer);
    switch(farbe)
  		{
  		case 1:
   		brett.setBrush(white);
   		puffer.setBrush(white);
  		break;
  		case 2:
   		brett.setBrush(red);
   		puffer.setBrush(red);
  		break;
  		case 3:
   		brett.setBrush(yellow);
   		puffer.setBrush(yellow);
  		break;
  		case 4:
   		brett.setBrush(blue);
   		puffer.setBrush(blue);
  		break;
  		case 5:
   		brett.setBrush(green);
   		puffer.setBrush(green);
  		break;
  		case 6:
   		brett.setBrush(darkGray);
   		puffer.setBrush(darkGray);
  		break;
          case 7:
  		brett.setBrush(magenta);
  		puffer.setBrush(magenta);
  		break;
          case 8:
  		brett.setBrush(cyan);
  		puffer.setBrush(cyan);
  		break;
  		}

    brett.drawEllipse(xnull+dim*xkr+2,ynull+yrahm-dim*(ykr+1)+2,kreis,kreis);
    puffer.drawEllipse(xnull+dim*xkr+2,ynull+yrahm-dim*(ykr+1)+2,kreis,kreis);
    brett.end();
    puffer.end();
		control[xkr]=true;
		wahl[xkr]= farbe;
  	malen=false;
		setCursor(arrowCursor);
		farbe=0;
		for (int i=0; i<halt; i++)
			{
			if(control[i])
				{
				z++;	
				if(z==halt)
					{
					auswerten();
					}
				}
			}
		z=0;
  	}
	}
 }

void Kmastermind::auswahl(int id)
 {
 /*
 * Cursorform aendern und gewaehlte Farbe in der Statusleiste anzeigen
 */
 setCursor(CrossCursor);
 farbe=id+1;
 switch(id)
	{
	case 0:
	statusBar()->changeItem(i18n("White"), Farbe);
	break;
	case 1:
	statusBar()->changeItem(i18n("Red"), Farbe);
	break;
	case 2:
	statusBar()->changeItem(i18n("Yellow"), Farbe);
	break;
	case 3:
	statusBar()->changeItem(i18n("Blue"), Farbe);
	break;
	case 4:
	statusBar()->changeItem(i18n("Green"), Farbe);
	break;
	case 5:
	statusBar()->changeItem(i18n("Gray"), Farbe);
	break;
        case 6:
	statusBar()->changeItem(i18n("Magenta"), Farbe);
	break;
        case 7:
	statusBar()->changeItem(i18n("Cyan"), Farbe);
	break;
	}
 }



void Kmastermind::auswerten()
 {
 /*
 * Die Auswertung einer gefuellten Reihe und Hinweise geben
 */
 z=0;
 for (int i=0; i<halt; i++)
		{
		control[i]=false;
		}
 bl=wh=0;
 for(int i=0; i<halt;i++){hilf[i]=spiel[i];}

 for(int i=0; i<halt; i++)
	{
	if(spiel[i]==wahl[i])
		{
		bl++;
		spiel[i]=10;
		wahl[i]=20;
		}
	}
 for(int i=0; i<halt; i++)
	{
	for(int t=0; t<halt; t++)
		{
		if(t!=i)
			{
			if(wahl[i]==spiel[t])
				{
				wh++;
				spiel[t]=30;
				break;
				}
			}
		}
	}

 for(int i=0; i<halt;i++){spiel[i]=hilf[i];}

 if(bl>0)
	{
	for(int i=0; i<bl; i++)
		{
		brett.begin(this);                // Richtige Farbe und Position
 		puffer.begin(&buffer);
		brett.setBrush(black);
		puffer.setBrush(black);
		brett.drawEllipse(xnull+halt*dim+3+12*i, ynull+yrahm-dim+3-dim*ykr,9,9);
		puffer.drawEllipse(xnull+halt*dim+3+12*i, ynull+yrahm-dim+3-dim*ykr,9,9);
		brett.end();
		puffer.end();
		}
	}

 if(wh>0)
	{
	for(int j=0; j<wh; j++)
		{
		brett.begin(this);                // Richtige Farbe
 		puffer.begin(&buffer);
		brett.setBrush(white);
		puffer.setBrush(white);
		brett.drawEllipse(xnull+halt*dim+3+12*j, ynull+yrahm-dim+15-dim*ykr,9,9);
		puffer.drawEllipse(xnull+halt*dim+3+12*j, ynull+yrahm-dim+15-dim*ykr,9,9);
		brett.end();
		puffer.end();
		}
	}

 if(bl==halt)
	{
	gewonnen();
 	}
 xkr=0;
 if(bl!=halt)ykr++;

 if(ykr==spielart)
	{
	verloren();
	}
 }


void Kmastermind::gewonnen()
 {
 /*
 * Die vom Computer gewaehlten Zufallszahlen im verdeckten Feld
 * anzeigen und Siegesmeldung ausgeben
 */
 zeigen();
 if(ykr<3)
	{
	QMessageBox::information(0, i18n("End of the game!"),
			i18n("You've more luck\n"
			"than judgement\n"));
	}
	else
	{
 	QMessageBox::information(0, i18n("End of the game!"),
			i18n("Congratulations\n"
			"You've won!\n"));
	}
 newgame();
 }


void Kmastermind::verloren()
 {
 /*
 *  Die vom Computer gewaehlten Zufallszahlen im verdeckten Feld
 * anzeigen und Trost spenden
 */
 zeigen();
 QMessageBox::information(0, i18n("Game over!"),
			i18n("Oh Sorry\n"
			"You've lost!\n"));
 newgame();
 }


void Kmastermind::zeigen()
 {
  /*
 *  Die vom Computer gewaehlten Zufallszahlen im verdeckten Feld
 * anzeigen
 */
 brett.begin(this);
 puffer.begin(&buffer);
 for(int i=0; i<halt; i++)
	{
	switch(spiel[i])
		{
		case 1:
 		brett.setBrush(white);
 		puffer.setBrush(white);
		break;
		case 2:
 		brett.setBrush(red);
 		puffer.setBrush(red);
		break;
		case 3:
 		brett.setBrush(yellow);
 		puffer.setBrush(yellow);
		break;
		case 4:
 		brett.setBrush(blue);
 		puffer.setBrush(blue);
		break;
		case 5:
 		brett.setBrush(green);
 		puffer.setBrush(green);
		break;
		case 6:
 		brett.setBrush(darkGray);
 		puffer.setBrush(darkGray);
		break;
		case 7:
		brett.setBrush(magenta);
		puffer.setBrush(magenta);
		break;
		case 8:
		brett.setBrush(cyan);
		puffer.setBrush(cyan);
		break;
		}

	brett.drawEllipse(xnull+4+dim*i, ynull+4,kreis,kreis);
	puffer.drawEllipse(xnull+4+dim*i, ynull+4,kreis,kreis);	
	}
 brett.end();
 puffer.end();
 }


void Kmastermind::paintEvent(QPaintEvent* event)
 {
 /*
 * Falls das Spiel mal neugezeichnet werden muss
 */
 bitBlt(this,0,0, &buffer);
 }
