#include <RaumW.h>
#include <RaumW.moc>

SteinC::SteinC (QWidget *parent): QWidget(parent)
{
	MerkFarbe = unsichtbar;
	SteinFarbeAendern();
}

void SteinC::SteinFarbeSetzen (int Farbe)
{
	MerkFarbe = Farbe;
	SteinFarbeAendern();
}

void SteinC::SteinBlink ()
{
	MerkFarbe = blink;
	SteinFarbeAendern();
}

void SteinC::Hintergrund ()
{
	MerkFarbe = unsichtbar;
	SteinFarbeAendern();
}

int SteinC::Farbe ()
{
	return(MerkFarbe);
}

void SteinC::SteinFarbeAendern()
{
	QPainter P;


	if (MerkFarbe == unsichtbar)
	{
		hide();
		return;
	}
	
	if (!isVisible())
	{
		show();
	}

	P.begin(this);
		switch(MerkFarbe)
		{
			case hell_blau:
				P.setPen(QColor(0,0,190));
				P.setBrush(QColor(70,150,255));
			break;
			
			case hell_gruen:
				P.setPen(QColor(0,140,0));
				P.setBrush(QColor(50,240,50));
			break;

			case orange:
				P.setPen(QColor(150,70,0));
				P.setBrush(QColor(255,150,40));
			break;
			
			case pink:
				P.setPen(QColor(150,70,0));
				P.setBrush(QColor(255,100,250));
			break;

			case dunkel_blau:
				P.setPen(QColor(0,0,50));
				P.setBrush(QColor(0,0,150));
			break;

			case oliv_gruen:
				P.setPen(QColor(0,40,0));
				P.setBrush(QColor(0,80,0));
			break;

			case rosa:
				P.setPen(QColor(200,100,100));
				P.setBrush(QColor(255,180,180));
			break;

			case dunkel_rot:
				P.setPen(QColor(100,0,0));
				P.setBrush(QColor(199,0,0));
			break;

			case rot_braun:
				P.setPen(QColor(10,0,0));
				P.setBrush(QColor(110,0,0));
			break;

			case weiss:
				P.setPen(QColor(200,200,200));
				P.setBrush(QColor(235,235,235));
			break;

			case blink:
				P.setPen(QColor(250,250,250));
				P.setBrush(QColor(0,0,0));
			break;

		} // switch MerkFarbe

		P.drawRect( 0, 0, width(), height() );
	P.end();


} //SteinFarbeAendern()

void SteinC::paintEvent(QPaintEvent *PE)
{
	SteinFarbeAendern();
}

/*************************************Klassen-Ende*********************************************/

/*************************************Klassen-Anfang*******************************************/
Schippe::Schippe (QWidget *parent): QWidget (parent)
{
	MerkHoehe = 0;
	Bewegung = 0;
	BewegungStopp = 0;
	BSi = 0;
	RestSumme = 0;

	int i;
	for (i=0; i!=5; i++)
	{
		SchippeStein[i] = new SteinC(this);
		SchippeStein[i]->move(0,i*MerkHoehe);
	}
	
	resize( 0, MerkHoehe );
	
	timerB = new CpTimerObj(50);
	connect ( timerB, SIGNAL(timerCalled()), this, SLOT (timerBS()) );

}


bool Schippe::Aufnehmen(int Farbe)
{
int i;

	if (SchippeStein[4]-> Farbe() != unsichtbar) return(FALSE);

	for (i = 4; i > 0; i--)
	{

		SchippeStein[i]->SteinFarbeSetzen(SchippeStein[i-1]->Farbe());
	}

	SchippeStein[0]->SteinFarbeSetzen(Farbe);
	
	resize (width(),height() + MerkHoehe );


	return(TRUE);
}

int Schippe::Abwerfen()
{
int i, color = unsichtbar;

	if ( SchippeStein[0]->Farbe() == unsichtbar ) return (unsichtbar);

	color = SchippeStein[0]->Farbe();

	for ( i = 0; i < 4; i++ )
		SchippeStein[i]->SteinFarbeSetzen(SchippeStein[i+1]->Farbe());

	SchippeStein[4]->SteinFarbeSetzen(unsichtbar);
	
	resize ( width(), height() - MerkHoehe );

	return (color);
}

void Schippe::paintEvent(QPaintEvent *PaintE)
{
	QPainter P;
	P.begin(this);
		P.setPen(black);
		P.setBrush(black);
		P.drawRect( 0,height()-(MerkHoehe-(MerkHoehe/4)),width(),(MerkHoehe-(MerkHoehe/4)) );
	P.end();
}

void Schippe::resizeEvent(QResizeEvent *E)
{
	int i;

	for (i=0; i!=5; i++)
	{
		SchippeStein[i]->move(0,i*MerkHoehe);
		SchippeStein[i]->resize(width(),MerkHoehe);
	}
	
	
}

void Schippe::tipp(int hoehe)
{
	MerkHoehe = hoehe;

	int i;
	for ( i = 0; i < 5; i++ )
	{
		if (SchippeStein[i]->Farbe() == unsichtbar) break;
	}

	resize( width(), (MerkHoehe*i) +(MerkHoehe-(MerkHoehe/4)) );

}

int Schippe::SchippeStellung()
{
	int Spalte = x()/width();

	if ( (x()% width() > 0) && !(BewegungStopp < 0) ) 
	{
		Spalte ++;
	}



	return Spalte;
}


void Schippe::timerBS()
{
	if (BewegungStopp == 0) return;

	if (BewegungStopp > 0) //rechts
	{
		if ( x() + width()/5 > 4*width() )
		{
			BewegungStopp = 0;

			move( x() +(RestSumme/5), 0 );
			RestSumme = 0;

			return;
		}

		RestSumme = RestSumme + width() % 5;
		move (x() + width()/5, 0);
		BSi ++;
	}
	else //links
	{
		if (x() - width()/5 < 0)
		{
			BewegungStopp = 0;

			move( x() +(RestSumme/5), 0 );
			RestSumme = 0;

			return;
		}

		RestSumme = RestSumme - width() % 5;
		move (x() - width()/5, 0);
		BSi --;
	}

	emit( IchHabeMichBewegt() );
	if ( (BSi % 5 == 0) && (Bewegung == 0) )
	{

		move( x() +(RestSumme/5), 0 );
		RestSumme = RestSumme % 5;

		BewegungStopp = 0;
	}

} //timerBS


void Schippe::BewegeLinks()
{
	Bewegung = -1;
	BewegungStopp = -1;
}

void Schippe::BewegeRechts()
{
	Bewegung = 1;
	BewegungStopp = 1;
}

void Schippe::Stopp()
{
	Bewegung = 0;
}

/*************************************Klassen-Ende*********************************************/


/*************************************Klassen-Anfang*******************************************/

RaumW::RaumW (QWidget *parent): QWidget(parent)
{

	Level=0;
	Punkte=0;
	int a, b;
	a = 0; b= 0;
	blinkStep = 0;
	Checken=true;
	fallen = 0;

	for (a = 0 ; a < 5; a++)
	{
		for (b = 0; b < 5; b++)
		{
			RaumA[a][b]= -1;
		}
	}

	BNullCheck();
	
	for (a=0; a != 5; a++)
	{
		for (b=0; b!=5; b++)
		{
			SteinA[a][b] = new SteinC (this);
			
		}
	}
	SchippeV = new Schippe (this);
	
	LevelAusgabe();
	setFocusPolicy( QWidget::StrongFocus );
	setFocus();
	connect (SchippeV,SIGNAL(IchHabeMichBewegt()), SLOT (VorSetzen() ) );

}

void RaumW::BNullCheck()
{
	int a, b;
	for (a = 0; a < 5; a++)
	{
		for (b = 0; b < 5; b++)
		{
			RaumB[a][b]= 0;
		}
		// int RaumB[5][5];
	}
} //BNullCgeck



bool RaumW::vgl(int a1, int a2, int a3, int a4=-2 ,
	int a5=-2, int a6=-2, int a7=-2,
	int a8=-2,int a9=-2 ,int a10=-2,int a11=-2,int a12=-2,int a13=-2,int a14=-2, 
	int a15=-2,int a16=-2,int a17=-2,int a18=-2,int a19=-2,int a20=-2, int
	a21=-2)  
{
	int ii = 0;
	int iii = 0;
	int a[20];
	a[0] = a1;
	a[1] = a2;
	a[2] = a3;
	a[3] = a4;
	a[4] = a5;
	a[5] = a6;
	a[6] = a7;
	a[7] = a8;
	a[8] = a9;
	a[9] = a10;
	a[10] = a11;
	a[11] = a12;
	a[12] = a13;
	a[13] = a14;
	a[14] = a15;
	a[15] = a16;
	a[16] = a17;
	a[17] = a18;
	a[18] = a19;
	a[19] = a20;


	for (int c= 0; c <=18; c++)
	{

		for (iii = 0; iii <= 18; iii++)
		{
			if (a[iii]==10) a[iii]=a[iii+1];
		}	
	}



	while (a[0] == a[ii] || a[ii]==-2 || a[ii]==10)
	{
		if (a[ii]== -1) return (FALSE);
		ii++;
		if (ii>=20) return (TRUE);
	}
	return (FALSE);
}

void RaumW::klaxCheck()
{
	if (!Checken) return;


	int a, b;

	///////////////////// KLAX 3er ////////////////////
	for (a = 0; a < 5; a++)
	{
		for (b = 0; b < 5; b++ )
		{
			if ( vgl (RaumA[a][b], RaumA[a][b+1], RaumA[a][b+2]))
			{
				RaumB[a][b] = -1;
				RaumB[a][b+1] = -1;
				RaumB[a][b+2] = -1;
				klax ++;
				Punkte = Punkte + 50;
				PunkteL = PunkteL + 50;
			}// if Klax 3er
		}//for a
	}//for b

	
        ///////////////////////////////KLAX 4er //////////////
	for (a = 0; a < 5 ; a++)
	{
		for (b = 0; b < 2; b++)
		{
			if (vgl (RaumA[a][b],RaumA[a][b+1],RaumA[a][b+2],RaumA[a][b+3] ) )
			{
				RaumB[a][b]=-1;
				RaumB[a][b+1]=-1;
				RaumB[a][b+2]=-1;
				RaumB[a][b+3]=-1;
				Punkte = Punkte +10000-(2*50);
				PunkteL = PunkteL +10000 - (2*50);
			}// if Klax 4er
		}// for b
	}//for a

	
        ////////////////////////////////Horizo 3er////////////////////
	for (a = 0; a < 3; a++)
	{
		for (b = 0; b < 5; b++)
		{
			if (vgl (RaumA[a][b],RaumA[a+1][b],RaumA[a+2][b]) )
			{
				RaumB [a][b] = -1;
				RaumB [a+1][b] = -1;
				RaumB [a+2] [b] = -1;
				klax ++;
				horizo ++;
				Punkte += 1000;
				PunkteL = PunkteL + 1000;
			}// if Horizo 3
		}// for b
	}// for a 	

	

        //////////////////////////// Horizo 4er /////////////////////
	for (a = 0; a < 2; a++)
	{
		for (b = 0; b < 5; b++ )
		{
			if (vgl (RaumA[a][b], RaumA[a+1][b], RaumA[a+2][b], RaumA[a+3][b]) )
			{
				Punkte += 5000 - (2*1000);
				PunkteL += 5000 - (2*1000);
				horizo --;
				RaumB[a][b] = -1;
				RaumB[a+1][b] = -1;
				RaumB[a+2][b] = -1;
				RaumB[a+3][b] = -1; 
			}// if horizo 4
 		} // for b
	}// for a

        //////////////////////////////////////// Horizo 5er/////////////
	a = 0;
	for (b = 0; b < 5; b++)
	{
		if (vgl (RaumA[a][b],RaumA[a+1][b],RaumA[a+2][b],RaumA[a+3][b], RaumA[a+3][b], RaumA[a+4][b]) )
		{
			Punkte = Punkte + 10000 - (2*5000)+ 1000;
			PunkteL += 10000 - (2*5000)+ 1000;
			RaumB[a][b] = -1;
			RaumB[a+1][b] = -1;
			RaumB[a+2][b] = -1;
			RaumB[a+3][b] = -1;
			RaumB[a+4][b] = -1;
		}// if horizo 5
	}// for b
	
	/////////////////// diago /3er ////////////////////
	for (a = 0; a < 3; a++)
	{
		for (b=0; b!=5; b++)
		{
			if (vgl (RaumA[a][b],RaumA[a+1][b+1],RaumA[a+2][b+2]) )
			{
				Punkte = Punkte + 5000;
				PunkteL +=5000;
				diago +=1;
				klax +=1;
				RaumB[a][b]=-1;
				RaumB[a+1][b+1]=-1;
				RaumB[a+2][b+2]=-1;
			}//if diago /3er

		}//for b
	} // for b

	////////////////////// diago \3er /////////////////////
	for (a=5; a >=2; a--)
	{
		for (b=0; b!=3; b++)
		{
                	if (vgl ( RaumA[a][b], RaumA[a-1][b+1], RaumA[a-2][b+2]) )
			{
                       		Punkte = Punkte + 5000;
				PunkteL +=5000;
				diago +=1;
				klax +=1;
				RaumB[a][b]=-1;
				RaumB[a-1][b+1]=-1;
				RaumB[a-2][b+2]=-1;
			}// if diago \3er
			
		}//for b
	}// for a

/////////////////// diago /4er ////////////////////
	for (a = 0; a < 2; a++)
	{
		for (b=0; b!=2; b++)
		{
			if (vgl (RaumA[a][b],RaumA[a+1][b+1],RaumA[a+2][b+2], RaumA[a+3][b+3]) )
			{
				Punkte = Punkte + 10000;
				PunkteL +=10000;
				RaumB[a][b]=-1;
				RaumB[a+1][b+1]=-1;
				RaumB[a+2][b+2]=-1;
				RaumB[a+3][a+3]=-1;
			}//if diago /4er

		}//for b
	} // for b

	////////////////////// diago \4er /////////////////////
	for (a=5; a >=3; a--)
	{
		for (b=0; b!=2; b++)
		{
                	if (vgl ( RaumA[a][b], RaumA[a-1][b+1], RaumA[a-2][b+2], RaumA[a-3][b+3]) )
			{
                       		Punkte = Punkte + 10000;
				PunkteL +=10000;
				RaumB[a][b]=-1;
				RaumB[a-1][b+1]=-1;
				RaumB[a-2][b+2]=-1;
				RaumB[a-3][b+3]=-1;
			}// if diago \4er
			
		}//for b
	}// for a

	/////////////////// diago /5er ////////////////////
	if (vgl (RaumA[a][b],RaumA[a+1][b+1],RaumA[a+2][b+2], RaumA[a+3][b+3], RaumA[a+4][b+4]) )
	{
		Punkte = Punkte + 1000;
		PunkteL +=10000;
		RaumB[a][b]=-1;
		RaumB[a+1][b+1]=-1;
		RaumB[a+2][b+2]=-1;
		RaumB[a+3][a+3]=-1;
		RaumB[a+4][b+4]=-1;
	}//if diago /5er

	////////////////////// diago \5er /////////////////////
      	if (vgl ( RaumA[a][b], RaumA[a-1][b+1], RaumA[a-2][b+2], RaumA[a-3][b+3], RaumA[a-4][b+4]) )
	{
       		Punkte = Punkte + 10000;
		PunkteL +=10000;
		RaumB[a][b]=-1;
		RaumB[a-1][b+1]=-1;
		RaumB[a-2][b+2]=-1;
		RaumB[a-3][b+3]=-1;
		RaumB[a-4][b+4]=-1;
	}// if diago \4er

	//LevelAusgabe();
	RaumABCheck();

} //klaxCheck()

void RaumW::RaumABCheck ()
{
	int a, b;
	bool geloest = FALSE;

      	for (a = 0; a < 5; a++)
	{
		for (b = 0; b < 5; b++)
		{
			if (RaumB[a][b] == -1)
			{
				geloest = TRUE;
			}
		}
	}
		
	if (Checken)
		if (geloest)
		{
			blinkStep = 0;
			Checken = false;
			blt=new CpTimerObj(100);
			connect ( blt, SIGNAL(timerCalled()), SLOT(nextBlink()) );
			return;
		}//if
	else Checken = true;
	
	for (a = 0; a < 5; a++)
	{
		for (b = 0; b < 5; b++)
		{
			if (RaumB[a][b] == -1)
			{
				RaumA[a][b] = -1;
				geloest=true;
			}
		}
	}
	
	if (geloest) RaumAFallCheck();

}//RaumABCheck

void RaumW::nextBlink() //SLOT
{
	if (BlinkV >= 10)
	{
		BlinkV=0;
	}

	emit PauseClearFliessband(true, false);
	BlinkV++;
	
	for (int i=0; i<5; i++)
	{
		for (int ii=0; ii<5; ii++)
		{
			if (RaumB[i][ii] == -1)
			{
				SteinA[i][ii]->SteinFarbeSetzen(BlinkV);
		
			}
		}//for ii
	}// for i

	blinkStep++;
	//Blinken
	if (blinkStep>=16)
	{
		delete blt;
		RaumABCheck();
		Checken=true;
		emit PauseClearFliessband(false, false);
	}
}//nextBlink

void RaumW::RaumAFallCheck ()
{
	BNullCheck();

	int a, b, c;

	
        for (c=5; c >= 0 ; c--)
	{
		for (a = 4; a >= 0; a--)
		{
			for (b = 4; b >= 1; b--)
			{

				if (RaumA[a][b-1] == -1)
				{

					RaumA[a][b-1] = RaumA[a][b];
					SteinA[a][b-1]->SteinFarbeSetzen(RaumA[a][b]);
	
					RaumA[a][b] = -1;
					SteinA[a][b]->SteinFarbeSetzen(unsichtbar);
				}
			} //for b
		} //for a
	} //for c
	LevelAusgabe();
	klaxCheck();


} //RaumAFallCeck


void RaumW::VorSetzen() //slot
{
	int Stellung = SchippeV->SchippeStellung();

	for (int i = 0; i < 5; i ++)
	{
		SteinA [Stellung][i] -> raise();
	}
}

void RaumW::neuerStein ( int Farbe, int Spalte ) //slot
{


	if (SchippeV->SchippeStellung() != Spalte )
	{
		fall();
		return;
	}

	if (!SchippeV->Aufnehmen(Farbe))
	{
		fall();
		return;
	}

}

void RaumW::fall()
{
	fallen++;

	if( fallen == 5 )
	{
		QMessageBox::information ( this, "GameOver!", "Game over! You're a looser.");
		KApplication::getKApplication()->quit();
	}
}

void RaumW::resizeEvent (QResizeEvent *E)
{
	int a, b;
	
	for (a = 0; a < 5; a++)
	{
		for (b = 0; b < 5; b++)
		{
			
			SteinA[a][b]->resize(width()/5, height()/6);
			SteinA[a][b]->move( a*(width()/5), (5-b)*(height()/6) );

		} //for b
	} // for a
	
	SchippeV->tipp (height()/6);
	SchippeV->resize( width()/5, SchippeV->height() );
	
	
} // resizeEvent RaumW

void RaumW::KannAbwerfen()
{

	int Spalte = SchippeV->SchippeStellung();

	if ( RaumA[Spalte][4] != -1 )
	{
		return;
	}

	debug ("Kann Abwerfen");

	int Farbe = SchippeV->Abwerfen();

	if (Farbe == unsichtbar)
	{
		return;
	}

	RaumA[Spalte][4] = Farbe;
	SteinA[Spalte][4]->SteinFarbeSetzen(Farbe);

	RaumAFallCheck();
}



void RaumW::keyPressEvent(QKeyEvent *E)
{

	switch (E->key())
	{
		case 4100: //Return
			KannAbwerfen();
		break;

		case 4101: //Enter
			KannAbwerfen();
		break;

		case 32: //Space
			KannAbwerfen();
		break;

		case 4128: //Shift
			KannAbwerfen();
		break;

		case 4117: //Down
			KannAbwerfen();
		break;

		case 4114: //Left
			SchippeV->BewegeLinks();
		break;

		case 4115: //Up
			
		break;

		case 4116: //Right
			SchippeV->BewegeRechts();
		break;

	}// Switch (E->key)
}

void RaumW::keyReleaseEvent (QKeyEvent *E)
{
	SchippeV->Stopp();
}


bool RaumW::LevelAusgabe()
{
	if (Level == 0)
	{
		Level++;
		klax=0;
		PunkteL=0;
		horizo=0;
		BKlax=3;
		NewLevel=(true);
	}
	
	if (Level == 1)
	{
		if (NewLevel==true)	
		{
			NewLevel=false;	
	        	QMessageBox::information( this, "Levelinformation",
			"Level 1 is starting now\n
			You need 3 Klax" );	
		}
		////////////////////////////////////////
		debug ("Bedingung: %d-%d",BKlax,klax);
		///////////////////////////////////////
		if (BKlax-klax<=0)
		{
			emit PauseClearFliessband(true, true);
	        	QMessageBox::information( this, "Levelinformation",
			"Level 1 finished" );	
			
			NewLevel=true;
			Level++;
			BKlax=5;

			QString Text;
			QString Zahlen;
			Zahlen.setNum( Punkte );
			Text = QString( ("You have ") +(Zahlen)
				+(" points.") );
					KMsgBox::message( this, "Points",
					Text );
			SetzeLevelWerteAufNull();

		}
		
	}
	if (Level==2)
	{
		if (NewLevel==true)	
		{
			NewLevel=false;	
	        	QMessageBox::information( this, "Levelinformation",
			"Level 2 is starting now\n
			You need 5 Klax" );	
			emit PauseClearFliessband(false, false);
		}
                ///////////////////////////////////////
		debug ("Bedingung: %d-%d",BKlax,klax);
                ///////////////////////////////////////
		if (BKlax-klax<=0)
		{
			emit PauseClearFliessband(true, true);
	        	QMessageBox::information( this, "Levelinformation",
			"Level 2 finished" );	
			
			NewLevel=true;
			Level++;
			/////////////
			BDiago=3;
			diago=0;
			//////////////

			QString Text;
			QString Zahlen;
			Zahlen.setNum( Punkte );
			Text = QString( ("You have ") +(Zahlen)
				+(" points.") );
					QMessageBox::information( this, "Points",
					Text);
			SetzeLevelWerteAufNull();

		}
	}
	
        if (Level==3)
	{
		if (NewLevel==true)	
		{
			NewLevel=false;	
	        	QMessageBox::information( this, "Levelinformation",
			"Level 3 is starting now\n
			You need 3 Diagonal" );	
			emit PauseClearFliessband(false, false);
		}
                ///////////////////////////////////////
		debug ("Bedingung: %d-%d",BDiago,diago);
                ///////////////////////////////////////
		if (BDiago-diago<=0)
		{
			emit PauseClearFliessband(true, true);
	        	QMessageBox::information( this, "Levelinformation",
			"Level 3 finished" );	
			
			NewLevel=true;
			Level++;
			/////////////
			BPunkte=10000;
			//////////////


			QString Text;
			QString Zahlen;
			Zahlen.setNum( Punkte );
			Text = QString( ("You have ") +(Zahlen)
				+(" points.") );
					QMessageBox::information( this, "Points",
					Text);

			SetzeLevelWerteAufNull();
		}
	}

        if (Level==4)
	{
		if (NewLevel==true)	
		{
			NewLevel=false;	
	        	QMessageBox::information( this, "Levelinformation",
			"Level 4 is starting now\n
			You need 10,000 Points" );	
			emit PauseClearFliessband(false, false);
		}
                ///////////////////////////////////////
		debug ("Bedingung: %d-%d",BPunkte,PunkteL);
                ///////////////////////////////////////
		if (BPunkte-PunkteL<=0)
		{
			emit PauseClearFliessband(true, true);
	        	QMessageBox::information( this, "Levelinformation",
			"Level 4 finished" );	
			
			NewLevel=true;
			Level++;
			/////////////
			BKlax=10;
			klax=0;
			//////////////

			QString Text;
			QString Zahlen;
			Zahlen.setNum( Punkte );
			Text = QString( ("You have ") +(Zahlen)
				+(" points.") );
					QMessageBox::information( this, "Points",
					Text);
			SetzeLevelWerteAufNull();
		}
	}




        if (Level==5)
	{
		if (NewLevel==true)	
		{
			NewLevel=false;	
	        	QMessageBox::information( this, "Levelinformation",
			"Level 5 is starting now\n
			You need 10 Klax" );	
			emit PauseClearFliessband(false, false);
		}
                ///////////////////////////////////////
		debug ("Bedingung: %d-%d",BKlax,klax);
                ///////////////////////////////////////
		if (BKlax-klax<=0)
		{
			emit PauseClearFliessband(true, true);
	        	QMessageBox::information( this, "Levelinformation",
			"Level 5 finished" );	
			
			NewLevel=true;
			Level++;
			/////////////
			diago=0;
			BDiago=6;
			//////////////

			QString Text;
			QString Zahlen;
			Zahlen.setNum( Punkte );
			Text = QString( ("You have ") +(Zahlen)
				+(" points.") );
					QMessageBox::information( this, "Points",
					Text);
			SetzeLevelWerteAufNull();
		}
	}


        if (Level==6)
	{
		if (NewLevel==true)	
		{
			NewLevel=false;	
	        	QMessageBox::information( this, "Levelinformation",
			"Level 6 is starting now\n
			You need 6 Diagonal" );	
			emit PauseClearFliessband(false, false);
		}
                ///////////////////////////////////////
		debug ("Bedingung: %d-%d",BDiago,diago);
                ///////////////////////////////////////
		if (BDiago-diago<=0)
		{
			emit PauseClearFliessband(true, true);
	        	QMessageBox::information( this, "Levelinformation",
			"Level 6 finished" );	
			
			NewLevel=true;
			Level++;
			/////////////
			BPunkte=25000;
			PunkteL=0;
			//////////////

			QString Text;
			QString Zahlen;
			Zahlen.setNum( Punkte );
			Text = QString( ("You have ") +(Zahlen)
				+(" points.") );
					QMessageBox::information( this, "Points",
					Text);
			SetzeLevelWerteAufNull();
		}
	}

        if (Level==7)
	{
		if (NewLevel==true)	
		{
			NewLevel=false;	
	        	QMessageBox::information( this, "Levelinformation",
			"Level 7 is starting now\n
			You need 25,000 Points" );	
			emit PauseClearFliessband(false, false);
		}
                ///////////////////////////////////////
		debug ("Bedingung: %d-%d",BPunkte,PunkteL);
                ///////////////////////////////////////
		if (BPunkte-PunkteL<=0)
		{
			emit PauseClearFliessband(true, true);
	        	QMessageBox::information( this, "Levelinformation",
			"Level 7 finished" );	
			
			NewLevel=true;
			Level++;
			/////////////
			BKlax=15;
			klax=0;
			//////////////

			QString Text;
			QString Zahlen;
			Zahlen.setNum( Punkte );
			Text = QString( ("You have ") +(Zahlen)
				+(" points.") );
					QMessageBox::information( this, "Points",
					Text);
			SetzeLevelWerteAufNull();
		}
	}

        if (Level==8)
	{
		if (NewLevel==true)	
		{
			NewLevel=false;	
	        	QMessageBox::information( this, "Levelinformation",
			"Level 8 is starting now\n
			You need 10 Klax" );	
			emit PauseClearFliessband(false, false);
		}
                ///////////////////////////////////////
		debug ("Bedingung: %d-%d",BKlax,klax);
                ///////////////////////////////////////
		if (BKlax-klax<=0)
		{
			emit PauseClearFliessband(true, true);
	        	QMessageBox::information( this, "Levelinformation",
			"Level 7 finished" );	
			
			NewLevel=true;
			Level++;
			/////////////
			BDiago=6;
			diago=0;
			//////////////

			QString Text;
			QString Zahlen;
			Zahlen.setNum( Punkte );
			Text = QString( ("You have ") +(Zahlen)
				+(" points.") );
					QMessageBox::information( this, "Points",
					Text);
			SetzeLevelWerteAufNull();

			QMessageBox::information ( this, "GameOver!", "GameOver! You've won this game.\nTP");

		}
	}












}



bool RaumW::SetzeLevelWerteAufNull()	
{
	
	klax=0;
	PunkteL=0;
	horizo=0;
	PunkteFurFrei=0;
	for (int i = 0; i < 5; i++)
	{
		for (int ii = 0; ii < 5; ii++)
		{
			RaumB[i][ii]=-1;
			if (RaumA[i][ii]==-1)
			{
				Punkte=Punkte+200;
				PunkteFurFrei+=200;
			}
		}
	}

	//Text(PunkteFurFrei);
	QString Text;
	QString Zahlen;

	Zahlen.setNum( PunkteFurFrei );
	Text = QString( ("You got ") +(Zahlen)
		+(" points for free Places in the room.") );
	
	QMessageBox::information( this, "Level points information", Text);
		
	RaumABCheck();
}
