/***************************************************************************
                          scoreboard.h  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Sun May 2 1999                                           
    copyright            : (C) 1999 by Henning Busacker                         
    email                : henning.busacker@duesseldorf.netsurf.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef SCOREBOARD_H
#define SCOREBOARD_H

#include <qdialog.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include "qrolistbox.h"
/**Zeigt die Highscores fr ein angegebenes Spiel.
Die Daten werden ber das Applications
KConfig  bearbeitet
  *@author Henning Busacker
  */

class Scoreboard : public QDialog  {
 Q_OBJECT
public:
/** Aufruf Scoreboard zum setzen eines Wertes */
	Scoreboard(QWidget *parent,const char* name,const char* game,const QStrList* level,const int speed,const int score );
/** Aufruf Scoreboard zur Anzeige */
	Scoreboard(QWidget* parent,const char* name,const char* game,const QStrList* level,const int speed);
/** Destructor */
	~Scoreboard();
	virtual void show();
protected slots:
/** Combobox geaendert */
	void slotLevelChanged(int);
/** Name wurde mit Return quittiert */
	void slotNameAccepted(const char*);

private:
/** Aufbau des Dialogs */
	void init();
/** liest die vorhandenen Highscores ein und liefert bei einem Score > 0 den neuen Index zurueck */
	int getValues();
/** sichert den neuen Spielstand */
	void saveValues();

/** interne Highscoreliste fuer Vergleich */
        QStrList sl[11];
/** Liste fuer Scoreboard */
	QROListbox* lb;
/** Combobox fuer die Level */
        QComboBox* cb;
/** OK button */
	QPushButton* ok;
/** Spielername */
	QString player;
/** EditItem */
	EditListBoxItem* el;
/** Flag Aufrufmodus */
	bool displayonly;
/** Name des Spiels */
        const char* Game;
/** Liste mit den Levelnamen */
        const QStrList* Level;
/** aktueller vorgewaehler Level */
        int Speed;
/** Score zum setzen */
        const int Score;
/** an dieser Stelle wurde der aktuelle Highscore eingefuegt */
	int insertpos;
};

#endif















