/***************************************************************************
                          kfun21.cpp  -  description                              
                             -------------------                                         

    version              : 0.1
    begin                : Son Jan 24 23:06:19 CET 1999
                                           
    copyright            : (C) 1999 by Henning Busacker                         
    email                : henning.busacker@duesseldorf.netsurf.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kfun21.h>
#include <qstring.h>
#include "resource.h"
#include "basiccard.h"
#include "scoreboard.h"



Kfun21App::Kfun21App()
{
	setCaption("Kfun21 " VERSION);

  ///////////////////////////////////////////////////////////////////
  // read the config file options
	readOptions();
  	QString picdir=kapp->kde_datadir()+ "/kpat/pics/";
	cardmaps=new cardMaps(i18n("Fun21 - Play cards against the clock"),picdir,bAnimate);
  ///////////////////////////////////////////////////////////////////
  // call init() to invoke all other construction parts
	init();

}

Kfun21App::~Kfun21App()
{
   delete cardmaps;
}

void Kfun21App::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menu_bar->setItemEnabled(id_,true);
}

void Kfun21App::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menu_bar->setItemEnabled(id_,false);
}


void Kfun21App::init()
{ 
  levelnames=0;
  ///////////////////////////////////////////////////////////////////
  // set up the base application features
  initView();
  initMenuBar();

  menu_bar->setMenuBarPos(menu_bar_pos);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
}

void Kfun21App::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  



  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  QPopupMenu *file_menu = new QPopupMenu();
  file_menu->insertItem(Icon("mini/kfun21app.xpm"), i18n("New &Game"), ID_FILE_NEW );
  file_menu->insertItem(i18n("&Highscore..."), ID_FILE_HIGHSCORE );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_APP_EXIT );

  // file_menu key accelerators
  file_menu->setAccel(CTRL+Key_N, ID_FILE_NEW);
  file_menu->setAccel(CTRL+Key_H, ID_FILE_HIGHSCORE);
  file_menu->setAccel(CTRL+Key_Q, ID_APP_EXIT);

  ///////////////////////////////////////////////////////////////////
  // options_menu entry speed_menu
  speed_menu = new QPopupMenu();
  speed_menu->setCheckable(true);
  for (unsigned int i=0;i<levelnames->count();i++) {
  	speed_menu->insertItem(levelnames->at(i),  ID_OPTIONS_SPEED+i);
  }
  speed_menu->setItemChecked(ID_OPTIONS_SPEED+iSpeed,true);

  ///////////////////////////////////////////////////////////////////
  // options_menu entry game_menu
  game_menu = new QPopupMenu();
  game_menu->setCheckable(true);
  game_menu->insertItem(i18n("Fun21"), ID_OPTIONS_GAMES+0);
  game_menu->insertItem(i18n("Tower"), ID_OPTIONS_GAMES+1);

  game_menu->setItemChecked(ID_OPTIONS_GAMES+iGameID,true);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry option_menu
  options_menu = new QPopupMenu();
  options_menu->insertItem(i18n("&Animate"),  ID_OPTIONS_ANIMATE );
  options_menu->insertItem(i18n("&Game..."),  game_menu );
  options_menu->insertItem(i18n("&Speed..."), speed_menu );
  
  options_menu->setItemChecked(ID_OPTIONS_ANIMATE,bAnimate);
 
  //options_menu key accelerators
  options_menu->setAccel(CTRL+Key_A, ID_OPTIONS_ANIMATE);
//  options_menu->setAccel(CTRL+Key_G, ID_OPTIONS_GAMES);
//  options_menu->setAccel(CTRL+Key_S, ID_OPTIONS_SPEED);

   

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  QPopupMenu *help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menu_bar the current menuBar and the position due to config file
  menu_bar = menuBar();
  menu_bar->insertItem(i18n("&File"), file_menu);
  menu_bar->insertItem(i18n("&Options"), options_menu);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


  menu_bar->insertSeparator(); 
  menu_bar->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(file_menu);
  CONNECT_CMD(options_menu);
  CONNECT_CMD(speed_menu);
  CONNECT_CMD(game_menu);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC CONNECTS HERE



}

void Kfun21App::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  if (iGameID==0)
      view = new fun21(this);
  if (iGameID==1)
      view = new tower(this);
  setView(view);
  view->setSpeed(iSpeed);
  levelnames=view->levelNames();
  bViewEnabled = true;
  this->resize(rMainGeom.width(), rMainGeom.height());
}



void Kfun21App::resizeEvent(QResizeEvent *evt)
{
    KTMainWindow::resizeEvent(evt);

    rMainGeom= this->geometry();
    view->resize(rMainGeom.width(),rMainGeom.height());
    updateRects();
}


bool Kfun21App::queryExit()
{
    saveOptions();
    int exit=KMsgBox::yesNo(this, i18n("Exit"), i18n("Really Quit ?"));

    if(exit==1)
      return true;
    else
      return false;
}

void Kfun21App::saveOptions()
{
  KConfig *config = kapp->getConfig();


  config->setGroup("General Settings");
  config->writeEntry("MainGeometry",rMainGeom);
  config->writeEntry("MenuBarPos", (int)menu_bar->menuBarPos());
  config->writeEntry("Animate",bAnimate);
    config->writeEntry("GameID",iGameID);
  config->setGroup((iGameID==0?"FUN21":"TOWER"));
  config->writeEntry("Speed",iSpeed);

}

void Kfun21App::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();
  QRect r(0,0,500,400);
  config->setGroup("General Settings");
  rMainGeom = config->readRectEntry("MainGeometry",&r);
  menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top); 
  bAnimate = config->readBoolEntry("Animate",true);
  iGameID = config->readNumEntry("GameID",0);

  config->setGroup((iGameID==0?"FUN21":"TOWER"));
  iSpeed = config->readNumEntry("Speed",0);
  
}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void Kfun21App::slotFileNew()
{

  ///////////////////////////////////////////////////////////////////
  // delete the current main view and create new view

  if (bViewEnabled)
    {
     delete view;
    }
  initView();
  updateRects();

}

void Kfun21App::slotFileHighscore()
{
  ///////////////////////////////////////////////////////////////////
  // show Highscoretable for current gameID
  Scoreboard* s=new Scoreboard(0,"Scoreboard",game_menu->text(iGameID+ID_OPTIONS_GAMES),levelnames,iSpeed);
  s->exec();
  delete s;

}

void Kfun21App::slotOptionsAnimate()
{
  bAnimate=!bAnimate;
  options_menu->setItemChecked(ID_OPTIONS_ANIMATE,bAnimate);
  KConfig *config = kapp->getConfig();
  config->setGroup("General Settings");
  config->writeEntry("Animate",bAnimate);

}
void Kfun21App::slotOptionsSpeedMenu(int id_)
{
  // Set speed in Variable and toggle Menu. Notify also View
  if (iSpeed != (id_ - ID_OPTIONS_SPEED)) {
    speed_menu->setItemChecked(ID_OPTIONS_SPEED+iSpeed,false);
    iSpeed = id_ - ID_OPTIONS_SPEED;
    speed_menu->setItemChecked(id_,true);
    if(bViewEnabled) view->setSpeed(iSpeed);
  }
}

void Kfun21App::slotOptionsGameMenu(int gameID)
{
  // Set game in Variable iGameID and toggle Menu. 
  // Start new game if necessary
	if (iGameID != (gameID-ID_OPTIONS_GAMES)) {
		game_menu->setItemChecked(ID_OPTIONS_GAMES+iGameID,false);
		if (bViewEnabled)
			delete view;
    	iGameID = gameID - ID_OPTIONS_GAMES;
		game_menu->setItemChecked(gameID,true);
    	initView();
    	updateRects();
	}
}

void Kfun21App::slotAppExit()
{ 

  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(this->queryExit())
    {
      saveOptions();
      KTMainWindow::deleteAll();
      kapp->quit();
    }
  else return;
}



///////////////////////////////////////////////////////////////////
// THESE MACROS CONSTRUCT THE SWITCH FOR THE SIGNAL commandCallback(int)


BEGIN_CMD(Kfun21App)
  ON_CMD(ID_FILE_NEW,                 slotFileNew(),            i18n("Start new game"))
  ON_CMD(ID_FILE_HIGHSCORE,           slotFileHighscore(),      i18n("Show Highscores"))

  ON_CMD(ID_OPTIONS_ANIMATE,          slotOptionsAnimate(),           i18n("Toggle Startup Animation"))
  case ID_OPTIONS_SPEED+0: ;
  case ID_OPTIONS_SPEED+1: ;
  case ID_OPTIONS_SPEED+2: ;
  case ID_OPTIONS_SPEED+3: ;
  ON_CMD(ID_OPTIONS_SPEED+4,          slotOptionsSpeedMenu(id_),      "")
  ON_CMD(ID_OPTIONS_GAMES,            slotOptionsGameMenu(id_),      i18n("Select Game..."))
  ON_CMD(ID_OPTIONS_GAMES+1,          slotOptionsGameMenu(id_),      i18n("Select Game..."))

  ON_CMD(ID_APP_EXIT,                 slotAppExit(),            i18n(""))
END_CMD()

