/***************************************************************************
                          colorprogressbar.h  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Sun May 9 1999                                           
    copyright            : (C) 1999 by Henning Busacker                         
    email                : henning.busacker@duesseldorf.netsurf.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef COLORPROGRESSBAR_H
#define COLORPROGRESSBAR_H

#include <kprogress.h>
#include <qframe.h>
#include <qrangecontrol.h>

  /**This is a coloured Progressbar with three sections.
  * It is fully configurable. with color and range.
  * It is mostly based on Kprogress made by Martynas Kunigelis
  * @author Henning Busacker
  */

class ColorProgressBar : public QFrame, public QRangeControl {
	Q_OBJECT
public: 
  /**
  * Possible values for orientation
  */
  enum Orientation { Horizontal, Vertical };

  /**
  * Possible values for bar style.
  *
  * Solid means one continuous progress bar, Blocked means a
  * progress bar made up of several blocks.
  */
  enum BarStyle { Solid, Blocked };
  /**
  * Construct a default ColorProgressbar. Orientation is horizontal.
  */

	ColorProgressBar(QWidget * parent=0, const char * name=0);
  /**
  * Construct a KProgress bar with an orientation.
  */
	ColorProgressBar(Orientation,QWidget * parent=0, const char * name=0);
  /**
  * Construct a KProgress bar with minimum, maximum and initial value.
  */
	ColorProgressBar(int min,int max,int value,Orientation,QWidget * parent=0, const char * name=0);
  /**
  * Destructor
  */
	~ColorProgressBar();
  /**
  * set the color ranges and the colors from left to right or bottom to top
  * the highValue is meant to be in percent of the maximum
  */	
	void setLowRange(const QColor& c,int highValue);
	void setMidRange(const QColor& c,int highValue);
	void setHighRange(const QColor& c);
  /**
  * Set the progress bar style. Allowed values are Solid and Blocked.
  */
	void setBarStyle(BarStyle style);

	void setBarColor(const QColor&);
  /**
  * Set a pixmap to be shown in the progress bar.
  */
	void setBarPixmap(const QPixmap &);

  /**
  * Set the orientation of the progress bar.
  * Allowed values are Horizonzal and Vertical.
  */
	void setOrientation(Orientation);

  /**
  * If this is set to TRUE, the progress text will be displayed.
  *
  */
	void setTextEnabled(bool);
	
  /**
   *  Set the scalefactor for the width of the rectangles in block mode (original 0.67)
   */
	void setScaleFactor(float);
  /**
  * Retrieve the bar style.
  */
	 BarStyle barStyle() const { return bar_style; };

  /**
  * Retrieve the bar color.
  */
	const QColor &barColor() const { return bar_color; };

  /**
  * Retrieve the bar pixmap.
  */
	const QPixmap *barPixmap()  const { return bar_pixmap; };

  /**
  * Retrieve the orientation.
  */
	Orientation orientation() const { return orient; };

  /**
  * Returns TRUE if progress text will be displayed, FALSE otherwise.
  */
  	bool textEnabled() const { return text_enabled; };

	float scaleFactor() const {return scale; };
  /**
   * Returns the recommended width for vertical progress bars or
   * the recommended height for vertical progress bars
   */
  virtual QSize sizeHint() const;
#if QT_VERSION > 150
  virtual QSizePolicy sizePolicy() const;
#endif			
public slots:
  /**
   * set the Bar value
   */
	void setValue(int);
  /**
   * advance the bar value
   */
	void advance(int);
public:	
signals:
	void percentageChanged(int);

protected:
	void valueChange();
	void rangeChange();
	void styleChange( GUIStyle );
	void paletteChange( const QPalette & );
	int recalcValue(int);
	virtual void drawContents ( QPainter * );
	virtual void drawText(QPainter *);
	QRect fr;

private:
	QColor  color[3];
        int     low;
        int 	high;
	QPixmap		*bar_pixmap;
	QColor		bar_color;
	QColor		bar_text_color;
	QColor		text_color;
	BarStyle	bar_style;
	Orientation orient;
	bool		text_enabled;
	float		scale;
	void initialize();
	void adjustStyle();

};

#endif






