#ifndef _ENGINE_H_
#define _ENGINE_H_

#include <kprocess.h>
#include <qobject.h>

#include <iostream.h>
#define debug(m) cerr << "Sent: " << m << endl

class KChessWidget;

class Engine : public QObject {
        Q_OBJECT
 public:
	Engine(const char *chessProg, KChessWidget *_w);
	reinit();

	// To engine
	quit();
	black();
	white();
	move(const char *m);
	post();
	write(char *m) {
	    debug(m);
	    return proc->writeStdin(m, strlen(m));
	};

public slots:
	void readStdout(KProcess *proc, char *buffer, int buflen);
	void EngineDone(KProcess *proc);

 private:
	KProcess *proc;
	KChessWidget *w;
};

#endif // _ENGINE_H_ 
