/***************************************************************************
                          kbubblesMain.cpp  -  description
                             -------------------
    begin                : Sat Nov  6 17:24:36 CET 1999
    copyright            : (C) 1999 by Tony Bjrkenius
    email                : tony.bjorkenius@linux.nu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbubblesMain.h"

#include "config.h"

// KDE
#include <kapp.h>
#include <ktmainwindow.h>
#include <kstatusbar.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kmsgbox.h>
#include <kiconloader.h>


// QT
#include <qwidget.h>
#include <qstring.h>
#include <qpopupmenu.h>
#include <qevent.h>
#include <qkeycode.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qpoint.h>
#include <qdir.h>
#include <qfile.h>
#include <qlineedit.h>
#include <qmessagebox.h>

// OTHER
#include "kbubblesHighscore.h"
#include "kbubblesConfig.h"
#include "kbubbles.h"
#include "kbubblesCreateLevel.h"
#include <math.h>
#include <iostream.h>
#include "global.h"

#define POINTS 0
#define LEVEL 1
#define LIFES 2

KbubblesMain::KbubblesMain(QWidget *parent, const char *name) : KTMainWindow(name)
{
//	this->grabKeyboard();
	QString caption;
	caption.sprintf("KBubbles %s",VERSION);
	this->setCaption(caption.data());
	kbub = NULL;
	kbcl = NULL;
	usedByXSW = 0;
	cen_win = new QWidget(this,"Central widget");
	cen_win->setFixedSize( 320, 448 );
	cen_win->setBackgroundColor(QColor::QColor("blue"));

	this->setView(cen_win);

	this->start = 0;
	this->next_level = 0;
	this->lifes = 3;
	this->points = 0;
	this->last_level = 0;

	kconf = new KbubblesConfig(this,"Config",TRUE);
	
	game = new QPopupMenu();
	game->insertItem(i18n("Start new game"), this, SLOT(start_new_game() ) );
	game->insertSeparator();
	game->insertItem(i18n("Start level"), this, SLOT(setup_level() ) );
	game->insertItem(i18n("Stop game"), this, SLOT(stop_game() ) );
	game->insertSeparator();
	game->insertItem(i18n("Edit levels"), this, SLOT(edit_levels() ) );
	game->insertSeparator();
	game->insertItem(i18n("Quit"), kapp, SLOT(quit() ) );
	
	opt = new QPopupMenu();
	opt->insertItem(i18n("Configure"), this, SLOT(config_game() ) );
	opt->insertSeparator();
	opt->insertItem(i18n("Highscores"), this, SLOT(highscores() ) );
	
	help = new QPopupMenu();
	help->insertItem(i18n("About"), this, SLOT(about() ) );
	
	kmbar = menuBar();
	kmbar->insertItem(i18n("&File"), game);
	kmbar->insertItem(i18n("&Options"), opt);
	kmbar->insertSeparator();
  kmbar->insertItem(i18n("&Help"), help);

  kmbar->show();

  ktbar = toolBar();
	
	ktbar->insertButton(ICON(QString("kbubblesquit.xpm")),0,SIGNAL(clicked() ),
											kapp, SLOT(quit() ),
											TRUE, i18n("Quit") );
	ktbar->insertButton(ICON(QString("kbubblesnew.xpm")),1,SIGNAL(clicked() ),
											this, SLOT(start_new_game() ),
											TRUE, i18n("Start new game") );
	ktbar->insertButton(ICON(QString("kbubblesnext.xpm")),2,SIGNAL(clicked() ),
											this, SLOT(setup_level() ),
											TRUE, i18n("Continue on next level") );
	ktbar->insertButton(ICON(QString("kbubblesstop.xpm")),3,SIGNAL(clicked() ),
											this, SLOT(stop_game() ),
											TRUE, i18n("Quit this game") );
	ktbar->insertButton(ICON(QString("kbubblesconf.xpm")),4,SIGNAL(clicked() ),
											this, SLOT(config_game() ),
											TRUE, i18n("Configure") );
	
	ktbar->show();
  	
	ksbar = statusBar();
	QString str;
	str.sprintf("%s: 00000000",i18n("Points"));
	ksbar->insertItem(str,POINTS);
	str.sprintf("%s: 0",i18n("Points"));
	ksbar->changeItem(str,POINTS);
	str.sprintf("%s: 1",i18n("Level"));
	ksbar->insertItem(str,LEVEL);
	str.sprintf("%s: 2",i18n("Lifes"));
	ksbar->insertItem(str,LIFES);
	ksbar->show();
	this->show_help_label();
}

KbubblesMain::~KbubblesMain()
{
}

// Select which game file to use...
// Not done yet
void KbubblesMain::config_game()
{
	if (this->usedByXSW) // In the middle of game return
		return;
	kconf->change_config();
}

// Path + filename standard background image
void KbubblesMain::get_bg_img(QString *str)
{
	kconf->backgroundImage(str);
}

// Path to games data file
void KbubblesMain::get_level_path(QString *str)
{
	kconf->name_of_path(str);
}

// Path to games global data file
void KbubblesMain::get_kde_data_path(QString *str)
{
	kconf->name_of_data_path(str);
}

// Path+Filename to games data file
void KbubblesMain::get_level_filename(QString *str)
{
	kconf->name_of_level_file(str);
}

// Path+Filename to games highscore file
void KbubblesMain::get_hiscore_filename(QString *str)
{
	kconf->name_of_highscore_file(str);
}

// Show label with info on what keys to use
// Called from radius_setup();
void KbubblesMain::show_help_label()
{
	QFont font;
	help_label = new QLabel(i18n("S = Start/Restart game\n"
													"N = Continue on next level\n"
													"P = Return to paused game\n"
													"H = Show highscores\n"
													"A = Show about\n"
													"Q = Quit game\n\n"
													"-------------\n\n"
													"In game keys\n"
													"Right arrow = One step right\n"
													"Left arrow = One step left\n"
													"Space = Start bubble\n"
													"P = Pause\n"
													"F = Fail level\n"),
													cen_win,"help_label");
	
	help_label->setBackgroundColor(QColor::QColor("blue"));
	font.setPointSize(16);
	font.setWeight(QFont::Bold);
	help_label->setFont(font);
	help_label->setAutoResize("TRUE");
	help_label->move(30, 30);
	help_label->show();
}

// Get input from user
// Keys used:
// S = start new game, N = start next level, P = return to running game
// H = Highscore, A = about
// Q = quit
void KbubblesMain::keyReleaseEvent(QKeyEvent *key)
{
   switch (key->key()) {
   	case 'P':
   		if (kbub == NULL)
   			return;
   		this->releaseKeyboard();
   		emit upause_game();
   		break;
   	case 'Q':
   		kapp->quit();
   		break;
   	case 'S':
   		start_new_game();
   		break;
   	case 'N':
   		setup_level();
   		break;
   	case 'H':
   		highscores();
   		break;
   	case 'A':
   		about();		
			break;
		default:
			break;
		}
}

// Not implemented
void KbubblesMain::edit_levels()
{

	if (this->usedByXSW)  // If game or leveleditor is running
		return;
	this->usedByXSW = 1;
	QString str;
	ksbar->changeItem(i18n("Press H for Help"),POINTS);
	ksbar->changeItem("",LEVEL);
	ksbar->changeItem("",LIFES);
	
	kbcl = new kbubblesCreateLevel( cen_win, "kbcl");
	connect(kbcl,SIGNAL(done()), this, SLOT(done_edit_levels()));
	kbcl->show();
}

void KbubblesMain::done_edit_levels()
{
	delete kbcl;
	kbcl = NULL;
	this->usedByXSW = 0;
  QString str;
	str.sprintf("%s: %d",i18n("Points"),this->points);
  ksbar->changeItem(str,POINTS);
	str.sprintf("%s: %d",i18n("Level"),this->next_level+1);
	ksbar->changeItem(str,LEVEL);
	str.sprintf("%s: %d",i18n("Lifes"),this->lifes-1);
	ksbar->changeItem(str,LIFES);
}

// Shows highscore for current game
// Called from ::check_for_highscore or from menu
void KbubblesMain::highscores()
{
	if (kbcl != NULL)
		return;
	if (kbub != NULL)  // If game is running pause it
		emit pause_game();
	QString fname;
	this->get_hiscore_filename(&fname);
	KbubblesHighscore kbubhigh(this,"Highscore",TRUE);
	kbubhigh.show_highscore(fname.data());
	if (kbub != NULL)  // If game is running return
		emit upause_game();
}

void KbubblesMain::about()
{
	if (this->usedByXSW)  // If game is running pause it
		emit pause_game();
	QString str;
	str.sprintf("%s %s", i18n("About KBubbles"), VERSION);
	KMsgBox::message(this,str,
												i18n("Written by Tony Bjrkenius\nE-mail: tony.bjorkenius@linux.nu"));
	if (this->usedByXSW)  // I fgame is running return
		emit upause_game();
}

void KbubblesMain::start_new_game()
{
	if (kbub != NULL)	
		return;
	
	// Setting up initial values
  this->next_level = 0;
  this->lifes = 3;
  this->points = 0;
  QString str;
	str.sprintf("%s: %d",i18n("Points"),this->points);
  ksbar->changeItem(str,POINTS);
	str.sprintf("%s: %d",i18n("Level"),this->next_level+1);
	ksbar->changeItem(str,LEVEL);
	str.sprintf("%s: %d",i18n("Lifes"),this->lifes-1);
	ksbar->changeItem(str,LIFES);
	
	// Starting new game	
	this->setup_level();
}

void KbubblesMain::stop_game()
{
	if (kbcl != NULL)
		return;
  this->usedByXSW = 0;
	if (kbub != NULL) {
		this->lifes = 0;  // Lifes = 0 -> game will restart with new values
		emit stopPlayingGame();
//		this->grabKeyboard();
		return;
	}
	// if no game was running: Setting up initial values
  this->next_level = 0;
  this->lifes = 3;
  this->points = 0;
  QString str;
	str.sprintf("%s: %d",i18n("Points"),this->points);
  ksbar->changeItem(str,POINTS);
	str.sprintf("%s: %d",i18n("Level"),this->next_level+1);
	ksbar->changeItem(str,LEVEL);
	str.sprintf("%s: %d",i18n("Lifes"),this->lifes-1);
	ksbar->changeItem(str,LIFES);
}

void KbubblesMain::setup_level()
{
	if (this->kbub != NULL || this->kbcl != NULL)		
		return;
  this->usedByXSW = 1;
  this->releaseKeyboard();
	// Setting up level this->next_level
	QString fname;
	kconf->name_of_level_file(&fname);
  if ( fname.length() == 0) {
  	QMessageBox::warning(this, i18n("Error"), i18n("Selected level file doesn't exist"));
	  this->usedByXSW = 0;
		return;
	}
	link_level l;
  QFile f(fname.data());
	if ( !f.open(IO_ReadOnly) )
		exit (15);
	f.at(this->next_level * sizeof(struct link_level));
	f.readBlock((char *) &l, sizeof(struct link_level));
	if (f.atEnd())
		this->last_level = 1;
	f.close();
	
	QString img;
	if (l.image[0] != '\0') {
		kconf->name_of_path(&img);
	  img.append(l.image);
	  f.setName(img.data());
	  if (!f.exists()) {
	  	img.sprintf("%s/kbubbles/%s", kapp->kde_datadir().data(), l.image);
	  	f.setName(img.data());
	  	if (!f.exists()) {
				kconf->backgroundImage(&img);
			}
		}
	} else {
		kconf->backgroundImage(&img);
	}
	if (img.length() == 0) {
  	QMessageBox::warning(this, i18n("Error"), i18n("No background pixmap found"));
	  this->usedByXSW = 0;
		return;
	}
		  	
	kbub = new Kbubbles(img.data(),cen_win, "widget");
	connect(kbub, SIGNAL(result(int)),this,SLOT(new_level(int)));
	connect(kbub, SIGNAL(updatePoints(int)),this,SLOT(update_points(int)));
	connect(this, SIGNAL(restartGame()),kbub, SLOT(endLevel()));
	connect(this, SIGNAL(pause_game()),kbub, SLOT(pause()));
	connect(this, SIGNAL(upause_game()),kbub, SLOT(upause()));
	connect(this, SIGNAL(stopPlayingGame()),kbub, SLOT(endLevel()));
	kbub->setupLevel(l);
	kbub->show();
	
}

// Create and call a highscore object
// return position if new highscore 0 if not
// Called from ::new_level
int KbubblesMain::check_for_highscore()
{
	QString fname;
	get_hiscore_filename(&fname);

	KbubblesHighscore kbubhigh(this,"Highscore",TRUE);
	return kbubhigh.check_highscore(this->points,fname.data());
}
	

						
// SLOT called from twidget
// recives 1 if previus level was finished sucessfully otherwise 0
void KbubblesMain::new_level(int i)
{
	delete kbub;
	kbub = NULL;	
	
	this->next_level += i;
	
	if (this->last_level && i) { // Last level, restart game.....
		this->last_level = 0;
		KMsgBox::message(this,"KBubbles",
													i18n("CONGRATULATIONS\nYou finished the game"));
		check_for_highscore();
		this->next_level = 0;
		this->lifes = 3;
		this->update_points(-this->points);
		this->update_lifes();
		this->usedByXSW = 0;
	}
	
	if (i == 0) { // Failed level
		this->last_level = 0;
		this->lifes--; // Remove one life
		if (this->lifes == 0) { // No more lifes, restart game
			KMsgBox::message(this,"KBubbles",
														i18n("GAME OVER"));
			check_for_highscore();					
			this->next_level = 0;
			this->lifes = 3;
			this->update_points(-this->points);
			this->usedByXSW = 0;
		}
		if (this->lifes < 0) {
			KMsgBox::message(this,"KBubbles",
														i18n("GAME OVER"));
			this->next_level = 0;
			this->lifes = 3;
			this->update_points(-this->points);
			this->usedByXSW = 0;
		}
		this->update_lifes();
	}
	
	this->update_level();
	if (this->start) {
		setup_level();
		this->start = 0;
	}
}

// Changes text on status bar
void KbubblesMain::update_level()
{
	QString str;
	str.sprintf("%s: %d",i18n("Level"),this->next_level + 1);
	ksbar->changeItem(str.data(), LEVEL);
}

// Changes text on status bar
void KbubblesMain::update_lifes()
{
	QString str;
	str.sprintf("%s: %d",i18n("Lifes"),this->lifes - 1);
	ksbar->changeItem(str.data(), LIFES);
}

// SLOT called from TWidget to add new points
// Changes text on status bar
void KbubblesMain::update_points(int i)
{
  QString str;
  this->points += i;
  str.sprintf("%s: %d",i18n("Points"),this->points);
	ksbar->changeItem(str.data(), POINTS);
}
