/***************************************************************************
                          kbubblesConfig.cpp  -  description
                             -------------------
    begin                : Wed Jan 5 2000
    copyright            : (C) 2000 by Tony Bjrkenius
    email                : tony.bjorkenius@linux.nu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbubblesConfig.h"

// KDE
#include <kapp.h>

// QT
#include <qstring.h>
#include <qstrlist.h>
#include <qfile.h>
#include <qdir.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

// OTHER
#include <iostream.h>

KbubblesConfig::KbubblesConfig(QWidget* parent=0, const char *name=0, bool modal=TRUE)
	:	QDialog(parent,name,modal)
{
	path = new  QString;
	lvl = new QString;
	img = new QString;
	kdata = new QString;
	kdata->sprintf("%s/kbubbles/",kapp->kde_datadir().data());
	QString tmp;
	
	kconf = kapp->getConfig();
	// Should use a Version string to check with
	if (kconf != 0) {
		path->setStr(kconf->readEntry("PathToPrivate"));
		if (!path->isEmpty()) {
			lvl->setStr(kconf->readEntry("LvlFile"));
			img->setStr(kconf->readEntry("ImgFile"));
		} else {
			path->sprintf("%s/share/apps/kbubbles/",kapp->localkdedir().data());
			lvl->setStr("Trouble");
    	img->setStr("default.xpm");
			this->save_config();
		}
	}
	
	QDir dddir(path->data());
	if (!dddir.exists())
		dddir.mkdir(dddir.path());
			
	tmp.sprintf("%s%s.lvl",path->data(),lvl->data());
	if (!(QFile(tmp.data()).exists()))	{
	 	tmp.sprintf("%s%s.lvl",kdata->data(),lvl->data());
  	if (!(QFile(tmp.data()).exists())) {
    	QMessageBox::warning( this->parentWidget(),i18n("No Level file found"),
		    										i18n(	"No level file found, you need to create one\n"
		    													"before you can start play"));
		}
	}		
			
	tmp.sprintf("%s%s",path->data(),img->data());
	if (!(QFile(tmp.data()).exists()))	{
	 	tmp.sprintf("%s%s",kdata->data(),img->data());
	 	if (!(QFile(tmp.data()).exists())) {
	   	QMessageBox::warning( this->parentWidget(),i18n("The default Image file not found"),
	   												i18n( "The default image file not found, you need to put a pixmap named\n"
	   															"default in either your local or global kde_data directory"));
	 	}
	}		
			
	this->hide();
}

KbubblesConfig::~KbubblesConfig()
{
	
}

int KbubblesConfig::save_config()
{
	kconf->writeEntry("PathToPrivate",path->data());
	kconf->writeEntry("LvlFile",lvl->data());
	kconf->writeEntry("ImgFile",img->data());
	return 0;
}


int KbubblesConfig::change_config()
{

	QComboBox *newLevelName = new QComboBox(FALSE,this,"Combo");
//	newLevelName->setAutoResize(TRUE);
	newLevelName->move(5,5);
	QPushButton *ok = new QPushButton(i18n("&Ok"),this,"ok");
	connect(ok,SIGNAL( clicked() ), this, SLOT( accept() ));
	
	QPushButton *cancel = new QPushButton(i18n("&Cancel"),this,"cancel");	
	connect(cancel,SIGNAL( clicked() ), this, SLOT( reject() ) );

  QDir dir(path->data());
	QFont font;
	font.setPointSize(16);
	newLevelName->setFont(font);
	newLevelName->insertStrList( 	dir.entryList("*.lvl",
																QDir::Files | QDir::Readable | QDir::NoSymLinks,
																QDir::Name | QDir::IgnoreCase) );	
  dir.setPath(kdata->data());
  QStrList lst;
  lst = *dir.entryList("*.lvl",
  										QDir::Files | QDir::Readable | QDir::NoSymLinks,
  										QDir::Name | QDir::IgnoreCase );

	int i = 0;
	int found = 0;
	lst.first();
	QString tmp;
	while (lst.current() != NULL) {
		for (i = 0; i < newLevelName->count() && found == 0; i++) {
			if (!strcmp(newLevelName->text(i),lst.current()))
				found = 1;
		}
		if (found == 0) {
			newLevelName->insertItem(lst.current(), -1);
		}
		lst.next();
	}
			
	i = 0;		
	while ( (i < newLevelName->count() - 1) &&
					( strncmp( lvl->data() ,newLevelName->text(i), strlen(newLevelName->text(i))-4 ) ) ) {
		i++;
	}

	newLevelName->setCurrentItem(i);			
	
	ok->setGeometry(5,50,100,30);
	ok->setFocus();
	cancel->setGeometry(110,50,100,30);
	
	this->setFixedSize(230,100);
	
	if ( (this->exec()) == QDialog::Accepted) {
	  lvl->setStr(newLevelName->currentText());
	  lvl->truncate(lvl->length()-4);
	  save_config();
	}
	delete newLevelName;
	delete ok;
	delete cancel;

	return 0;
}

void KbubblesConfig::name_of_highscore_file(QString *str)
{
	str->sprintf("%s%s.hst",path->data(),lvl->data());	
}

void KbubblesConfig::name_of_path(QString *str)
{
	str->setStr(path->data());	
}

void KbubblesConfig::name_of_data_path(QString *str)
{
	str->setStr(kdata->data());
}

void KbubblesConfig::name_of_level_file(QString *str)
{
	str->sprintf("%s%s.lvl",path->data(),lvl->data());	
	if (!QFile(str->data()).exists()) {
		str->sprintf("%s%s.lvl",kdata->data(),lvl->data());	
		if (!QFile(str->data()).exists()) {
			str->setStr("");
		}
	}
}

void KbubblesConfig::backgroundImage(QString *str)
{
	str->sprintf("%s%s",kdata->data(),img->data());
	if (!QFile(str->data()).exists()) {
		str->setStr("");
	}
}
	