/***************************************************************************
                          kstatusled.cpp  -  description
                             -------------------
    begin                : Thu Dec 30 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>
#include "kstatusled.h"
#include <kapp.h>
#include <qpixmap.h>
#include <qstring.h>

KStatusLed::KStatusLed(QWidget *parent, const char *name ) : QFrame(parent,name)
{
	state = go;
//	setFixedWidth(20);

  QString picDir(kapp->kde_datadir() + "/kbattleship/pics/");
  redLed = new QPixmap(picDir + "redled.xpm");
  greenLed = new QPixmap(picDir + "greenled.xpm");
}

KStatusLed::~KStatusLed()
{
}

/**  */
void KStatusLed::setStatus(int newState)
{
	cerr << "Changing status to " << (newState == go ? " true ": " false") << endl;
	cerr << this << endl;
	
	state = newState;
	repaint();
}

/**  */
void KStatusLed::paintEvent(QPaintEvent * e)
{
	cerr << "Painting led " << name() << ", status" << (state == go ? " true ": " false") << endl;
	cerr << this << endl;
	QPixmap *pix;
	
	if (state == go)
		pix = greenLed;
	else
		pix = redLed;
		
	bitBlt(this,0,0,pix);
	
}
/**  */
void KStatusLed::toggleStatus()
{
	cerr << "Changing status to " << (state==stop ? " true ": " false") << endl;
	(state == go) ? (state = stop) : (state = go);
	repaint();
}
