/***************************************************************************
                          kmybattlefield.cpp  -  description
                             -------------------
    begin                : Fri Oct 15 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kmybattlefield.h"
//#include <kship.h>
#include <iostream.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <kmessage.h>
#include <kapp.h>


//#include "kserverstub.h"
#include "kbattleshipview.h"
#include "kbattleshipdoc.h"
#include "kbattleshipdocbase.h"
#include "kship.h"
#include "resource.h"

KMyBattleField::KMyBattleField (QWidget * parent, const char *name)
	:KBattleField (parent, name)
{
}

KMyBattleField::~KMyBattleField ()
{
}

/**  */
void KMyBattleField::cellClicked (int x, int y, int button)
{
  int shipSize = 0;
  int dir = 0;

	KBattleshipView * view = (KBattleshipView *) parent();
	if (!view->getDocBase())
		return;

	QList<KShip> &ships = view->getDocBase()->getShips();

  if (button == LeftButton)
	  dir = KShip::NS;
  else
  	dir = KShip::WE;

  if (ships.count() > 9)
    return;

  switch (ships.count())
    {
    case 0:			// no ships

      shipSize = 4;		// the first ship is the 4 cell one

      break;
    case 1:
    case 2:
      shipSize = 3;
      break;
    case 3:
    case 4:
    case 5:
      shipSize = 2;
      break;
    default:
      shipSize = 1;
      break;
    }

	if (view->getDocBase()->addShip(x,y,dir,shipSize))
		{
			repaint();
			view->getDocument()->slotUpdateAllViews(this);
		}
	
		
}

/**  */
void KMyBattleField::paintShips (QPainter * p)
{
	KBattleshipView * view = (KBattleshipView *) parent();
	
	if (!view->getDocBase())
		return;
	
	p->drawText(0,0,320,10,AlignCenter,view->getDocBase()->fleetName());
		
	QList<KShip> &ships = view->getDocBase()->getShips();
  KShip *s;

  for (s = ships.first (); s != 0; s = ships.next ())
    s->paint (p);
	
	// coordinates of the cell
  int x, y, w = 10, h = 10;
  // brush to do the painting
  QBrush redBrush (red);
  QBrush blackBrush (black);
  QBrush greenBrush (green);

  QString picDir(kapp->kde_datadir() + "/kbattleship/pics/");

  QPixmap hit(picDir + "hit.xpm");
  QPixmap destroy(picDir + "destroy.xpm");

  for (int i = 0; i < 15; i++)
    {
      for (int j = 0; j < 15; j++)
			{
	  		// calculate the coordinates in pixels
			  x = (i * 20) + 10;
			  y = (j * 20) + 10;
			  switch (view->getDocBase()->cellStatus(i,j,ME))
	  		  {
				    case 0:		//no status, does nothing
	
				      break;
				    case 1:		// fire, but no hit
	      			// paint a small hole in center of the cell
				      p->setBrush (blackBrush);
				      p->drawEllipse (x + 5, y + 5, w, h);
				      break;
				    case 2:		// fire and hit
				      // paint a fire
							p->drawPixmap(x,y,hit);
	
//				      p->setBrush (redBrush);
//				      p->drawEllipse (x, y, w, h);
				      break;
				    case 3:		// fire and destroyed
				      // paint a fire with a cross within
							p->drawPixmap(x,y,destroy);
	
//				      p->setBrush (greenBrush);
//				      p->drawEllipse (x, y, w, h);
				      break;
				    default:
				      break;
				    }
				}
    }


}


/**  */
void KMyBattleField::updateView()
{
 	KBattleshipView * view = (KBattleshipView *) parent();
	
	if (view->getDocBase()->status() == KBattleshipDocBase::PLACE)
		activate();
	else
		deactivate();

	if (view->getDocBase()->updatedArea() == MY_AREA || view->getDocBase()->updatedArea() == ALL_AREA)
		repaint();

}
