/***************************************************************************
                          kbattleshipdocbase.h  -  description
                             -------------------
    begin                : Sun Dec 12 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBATTLESHIPDOCBASE_H
#define KBATTLESHIPDOCBASE_H

#include <qobject.h>
#include <qstrlist.h>

#include "kbattleship.h"

/**this is the base class for the real document logic
  *@author Alessandro Praduroux
  */

class KMessage;
class KSocket;
class KShip;

class KBattleshipDocBase : public QObject  {	

	Q_OBJECT
	
public:

	/** the possible statuses */
	enum {NOSTATUS,PLACE,FIRE,WAIT};

  /** used to build the document, it is a factory method */
  static KBattleshipDocBase * buildDoc(QString serverName);
	
	KBattleshipDocBase();
	~KBattleshipDocBase();
	
  /**  */
  virtual void chat(QString text);

  /**  */
  virtual int cellStatus(int x, int y, int who);

  /**  */
  virtual bool addShip(int x, int y, int orientation, int size);

  /**  */
  virtual void fire(int x, int y);

  /** sets the name of the fleet */
  virtual void setName(QString name) = 0;

  /**  */
  virtual QString fleetName() = 0;

  /**  */
  virtual QString enemyName() = 0;

  /**  */
  const QStrList *getChatMsg() const;
  /**  */
  int status();
  /**  */
  QList<KShip> & getShips();
  /**  */
  int updatedArea();

protected slots: // Protected slots
  /**  */
  virtual void sendMessage(KMessage &msg);

  /**  */
  virtual void processMsg(KMessage &msg);
  /**  */
  virtual void endShips() = 0;
  /**  */
  KBattleshipApp * getApplication();

protected:
  /** the client socket, used to communicate with the other client */
	KSocket * cliSock;

  /** Your fleet name  */
  QString _name;

  /** Your enemy name */
  QString _enemy;

  /**  */
  int _status;

  /** the list of chat strings */
	QStrList chatMsg;

  /**  */
  QList<KShip> ships;

  /**  */
  int area;

  /**  */
	bool ready, enemyReady;

  int cells[2][15][15];
  	
protected slots: // Protected slots
  /**  */
  void slotReadEvent(KSocket *);

  /**  */
  void slotCloseEvent(KSocket *);

signals: // Signals
  /**  */
  void dataChanged();
};

#endif
