/***************************************************************************
                          kbattleshipdocbase.cpp  -  description
                             -------------------
    begin                : Sun Dec 12 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//standard include files
#include <fstream.h>

// include files for Qt

// include files for KDE
#include <kapp.h>
#include <ksock.h>

// application specific includes

#include "kbattleshipdocbase.h"
#include "kbattleshipclient.h"
#include "kbattleshipserver.h"
#include "kmessage.h"
#include "resource.h"
#include "kship.h"
#include "kstatusled.h"

KBattleshipDocBase::KBattleshipDocBase()
{
	ready = enemyReady = false;
	_status = NOSTATUS;
	for (int k = 0; k < 2; k++)
		{
	  	for (int i = 0; i < 15; i++)
    	{
     	 for (int j = 0; j < 15; j++)
					{
	  				cells[k][i][j] = STATUS_NONE;
					}
    	}
		}
}

KBattleshipDocBase::~KBattleshipDocBase(){
}

/** used to build the document, it is a factory method */
KBattleshipDocBase * KBattleshipDocBase::buildDoc(QString serverName)
{
	if(serverName =="")
		return new KBattleshipServer();
	else
		return new KBattleshipClient(serverName);
}

/**  */
void KBattleshipDocBase::sendMessage(KMessage &msg)
{
  if (!cliSock)
    return;
	ofstream o(cliSock->socket());
	o << &msg;

}
/**  */
void KBattleshipDocBase::slotReadEvent(KSocket *)
{
	ifstream input(cliSock->socket());
	KMessage msg;
	input >> &msg;
		
	//DEBUG!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1
	cerr << &msg << endl;
	//DEBUG!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1

	processMsg(msg);

}

/**  */
void KBattleshipDocBase::slotCloseEvent(KSocket *)
{
	//DEBUG!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1
	cerr << "connection closed by peer" << endl;
	//DEBUG!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1
	disconnect(this);
	delete cliSock;	
}

/** */
void KBattleshipDocBase::chat(QString text)
{
	// build the message
	KMessage msg;	
	msg.setType(IDM_CHAT);
	msg.addField("name",_name);
	msg.addField("content",text);
	
	// send it
	sendMessage(msg);

	area = CHAT_AREA;
		
	// now append the message to the list
	text = _name + ":" + text;
	chatMsg.append(text);
}

/**  */
void KBattleshipDocBase::processMsg(KMessage & msg)
{
	bool changed = false;
	switch (msg.getType())
		{
			case IDM_STATUS:
				{
					if (msg.getField("status").toInt() == ENDSHIP)
						{
							enemyReady = true;
							endShips();
							changed = true;
						}
					break;
				}
			case IDM_CHAT:
				{
					QString text = msg.getField("name");
					text = text + ":" + msg.getField("content");
					chatMsg.append(text);
					changed = true;
					area = CHAT_AREA;
					break;
				}
			
			case IDM_FIRE:
				{
					KMessage resp;
				  int x = msg.getField("x").toInt();
				  int y = msg.getField("y").toInt();
					resp.setType(IDM_RESP);
					resp.addField("x",x);
					resp.addField("y",y);
					// controllo di non essere stato colpito
				  KShip *test = 0;
				  QPoint p(y,x);
				  for (test= ships.first(); test != 0; test = ships.next())
				    {
				      if (test->hitTest(p))
				      	{
				      		if (test->destroyed())
				      			cells[ME][x][y] = STATUS_DESTROY;
				      			
				      		else
				      			cells[ME][x][y] = STATUS_HIT;
				      		break;
				      	}
				      else
				      	cells[ME][x][y] = STATUS_FIRE;
				    }			
				  resp.addField("status",cells[ME][x][y]);
				  sendMessage(resp);
				  cerr << "stato della cella " << x << "," << y << "= " << cells[ME][x][y] << endl;
				  if (cells[ME][x][y] == STATUS_FIRE)
				  	{
				  		_status = FIRE;
				  		getApplication()->slotStatusMsg(i18n("Please fire again"));
				  		getApplication()->setStatusLed(KStatusLed::go);
				  	}
				  changed = true;
				  area = MY_AREA;
				  break;
				}

			case IDM_RESP:
				{
				  int x = msg.getField("x").toInt();
				  int y = msg.getField("y").toInt();
				  int resp = msg.getField("status").toInt();
				  cells[ENEMY][x][y] = resp;
				
				  if (resp != STATUS_FIRE)
				  	{
				  		_status = FIRE;
				  		getApplication()->setStatusLed(KStatusLed::go);
				  		if (resp == STATUS_DESTROY)
				  			getApplication()->slotStatusMsg(i18n("Nice shot! Please fire again"));
				  		else
				  			getApplication()->slotStatusMsg(i18n("Please fire again"));
				  	}
				  else
				  	{
				  		_status = WAIT;
				  		getApplication()->slotStatusMsg(i18n("Bad luck! Now wait and hope!"));
							getApplication()->setStatusLed(KStatusLed::stop);
						}				  	
			  	
			  	changed = true;
			  	area = ENEMY_AREA;
				}
			default:
				break;
		}				
	
	cerr << "changed " << changed << endl;
	if (changed)
		emit dataChanged();
		
}

/**  */
const QStrList *KBattleshipDocBase::getChatMsg() const
{
	return &chatMsg;
}

/**  */
int KBattleshipDocBase::status()
{
	return _status;
}

/**  */
bool KBattleshipDocBase::addShip(int x, int y, int orientation, int size)
{
	cerr << "addShip: " << x << " " << y << " " << orientation << " " << size << endl;
	KShip *s = new KShip(size,orientation,QPoint(x,y));
	
	bool goodShip = true;

  KShip *conf;
  for (conf = ships.first(); conf != 0; conf = ships.next())
    {
      if (s->intersects(conf))
				goodShip = false;
    }

  // if it's within the bounding rect of the battle field and does not overlap other ships,
  // then append the ship to the list and notify the server
  if (!s->outOfBounds() && goodShip)
    {
      ships.append(s);
    }
  else
		{
			delete s;
			goodShip = false;
		}

	if (ships.count() == 10)
		{
			KMessage msg;
			msg.setType(IDM_STATUS);
			msg.addField("status",ENDSHIP);
			sendMessage(msg);
			ready = true;
			endShips();
		}
		
	return goodShip;
}

/**  */
QList<KShip> & KBattleshipDocBase::getShips()
{
	return ships;
}

/**  */
void KBattleshipDocBase::fire(int x, int y)
{
	KMessage msg;
	msg.setType(IDM_FIRE);
	msg.addField("x",x);
	msg.addField("y",y);
	cells[ENEMY][x][y] = STATUS_FIRE;
	area = ENEMY_AREA;
	sendMessage(msg);
}

/** */
int KBattleshipDocBase::cellStatus(int x, int y, int who)
{
	return cells[who][x][y];
}

/**  */

int KBattleshipDocBase::updatedArea()
{
	return area;
}

/**  */
KBattleshipApp * KBattleshipDocBase::getApplication()
{
	return (KBattleshipApp *) kapp;
}
