/***************************************************************************
                          kbattleshipdoc.cpp  -  description
                             -------------------
    begin                : dom dic 12 21:31:30 CET 1999
    copyright            : (C) 1999 by Alessandro Praduroux
    email                : pradu@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>

// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>

// application specific includes
#include "kbattleshipdoc.h"
#include "kbattleship.h"
#include "kbattleshipviewbase.h"

QList<KBattleshipViewBase> *KBattleshipDoc::pViewList = 0L;

KBattleshipDoc::KBattleshipDoc(QWidget *parent, const char *name)
	: QObject(parent, name), modified(false)
{
	base = 0;
  if(!pViewList)
  {
    pViewList = new QList<KBattleshipViewBase>();
  }
}

KBattleshipDoc::~KBattleshipDoc()
{
}

void KBattleshipDoc::addView(KBattleshipViewBase *view)
{
  pViewList->append(view);
}

void KBattleshipDoc::removeView(KBattleshipViewBase *view)
{
  pViewList->remove(view);
}

void KBattleshipDoc::setAbsFilePath(const QString &filename)
{
  absFilePath=filename;
}

const QString &KBattleshipDoc::getAbsFilePath() const
{
  return absFilePath;
}

void KBattleshipDoc::setTitle(const QString &_t)
{
  base->setName(_t);
}

const QString KBattleshipDoc::getTitle() const
{
	if (!base)
		{
			title=i18n("Untitled");
			return title;
		}
		
  return base->fleetName();
}

void KBattleshipDoc::slotUpdateAllViews(KBattleshipViewBase *sender)
{
  KBattleshipViewBase *w;
  if(pViewList)
  {
    for(w=pViewList->first(); w!=0; w=pViewList->next())
    {
      if(w!=sender)
        w->updateView();
    }
  }

}

bool KBattleshipDoc::saveModified()
{
  return true;
}

void KBattleshipDoc::closeDocument()
{
  deleteContents();
}

bool KBattleshipDoc::newDocument(QString server)
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  modified=false;
  absFilePath=QDir::homeDirPath();
  title=i18n("Untitled");
	base = KBattleshipDocBase::buildDoc(server);
	connect(base,SIGNAL(dataChanged()),this,SLOT(slotDataChanged()));

  return true;
}

bool KBattleshipDoc::openDocument(const QString &filename, const char *format /*=0*/)
{
  /*QFileInfo fileInfo(filename);
  title=fileInfo.fileName();
  absFilePath=fileInfo.absFilePath();	*/
  /////////////////////////////////////////////////
  // TODO: Add your document opening code here
  /////////////////////////////////////////////////
	
  modified=false;
  return true;
}

bool KBattleshipDoc::saveDocument(const QString &filename, const char *format /*=0*/)
{
  /////////////////////////////////////////////////
  // TODO: Add your document saving code here
  /////////////////////////////////////////////////

  modified=false;
  return true;
}

void KBattleshipDoc::deleteContents()
{
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  /////////////////////////////////////////////////

}

/**  */
KBattleshipDocBase * KBattleshipDoc::getDocBase()
{	
	return base;
}

/**  */
void KBattleshipDoc::slotDataChanged()
{
	slotUpdateAllViews(0);
}
/**  */
//Del di KDevelop: int KBattleshipDoc::updatedArea(){
//Del di KDevelop: }
