/***************************************************************************
                          playground.cpp  -  description
                             -------------------
    begin                : Fri Dec 10 1999
    copyright            : (C) 1999 by Ralf-Christian Juergensen
    email                : ralf-christian.juergensen@stud.fh-flensburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "playground.h"

// Create type 'OpFunc' for function-pointer to a map-class function. (and, or, xor)
typedef void (Map::*OpFunc) (int, int, bool);

PlayGround::PlayGround(Player startPlayer, const char* mapFileName) : map(mapFileName)
{
    player = startPlayer;
}

void PlayGround::newGame(Player p, const char* mapFileName)
{
    player = p;
    	
    map.load(mapFileName);
    
    cursor.set();	
    initRound();
}

void PlayGround::initRound(void)
{
    cursor.init();
}

void PlayGround::setCursor(void)
{
    int x = cursor.getXPos();   // current x position of the cursor
    int y = cursor.getYPos();   // current y position of the cursor
    Type t = cursor.getType();  // current type of the cursor

    OpFunc opFunc;              // function-pointer to map-operator
                    
    // if type is '?' generate 'real' type
    if(t == RND)
    {
        t = Type(3.0 * rand() / (RAND_MAX + 1.0));
    }
            
    try
    {
        switch(t)
        {
        case AND:
            opFunc = &Map::and;
            break;
        case OR:
            opFunc = &Map::or;
            break;
        case XOR:
            opFunc = &Map::xor;
            break;
        case RND:
            throw "No RND expected!";
            break;  
        }
        
        (map.*opFunc)(x,   y,   cursor.getBit(0));
        (map.*opFunc)(x+1, y,   cursor.getBit(1));
        (map.*opFunc)(x+2, y,   cursor.getBit(2));
        (map.*opFunc)(x,   y+1, cursor.getBit(3));
        (map.*opFunc)(x+2, y+1, cursor.getBit(4));
        (map.*opFunc)(x,   y+2, cursor.getBit(5));
        (map.*opFunc)(x+1, y+2, cursor.getBit(6));
        (map.*opFunc)(x+2, y+2, cursor.getBit(7));
    }
    catch (char* errorMsg)
    {
        cerr << "error!\n";
        cerr << errorMsg << '\n';
        cerr << "in PlayGround::setCursor().\n";
        exit(-1);
    }
}

void PlayGround::cursorUp(void)
{
    if(cursor.getYPos() > 0)
    {
        cursor.goUp();
    }
}

void PlayGround::cursorDown(void)
{
    // attention: the cursor is 3 fields high
    if(cursor.getYPos() < (map.getHeight() - 3))
    {
        cursor.goDown();
    }
}

void PlayGround::cursorLeft(void)
{
    if(cursor.getXPos() > 0)
    {
        cursor.goLeft();
    }
}

void PlayGround::cursorRight(void)
{
    // attention: the cursor is 3 fields wide
    if(cursor.getXPos() < (map.getWidth() - 3))
    {
        cursor.goRight();
    }
}

int PlayGround::getCursorX(void)
{
    return cursor.getXPos();
}

int PlayGround::getCursorY(void)
{
    return cursor.getYPos();
}

Player PlayGround::checkWinner(void)
{
    // get number of fields for player one that are 0(OFF)
    int offOne = getScore(ONE);
    int offTwo = getScore(TWO);
    
    // when both players are winner => winner is current player
    if((offOne == 0) && (offTwo == 0))
    {
        return player;
    }
    	
    if(offOne == 0)
    {
        return ONE;
    }
    	
    if(offTwo == 0)
    {
        return TWO;
    }
    	
    return NONE;	
}

void PlayGround::changePlayer(void)
{
    if(player == ONE)
    {
        player = TWO;
    }
    else
    {
        player = ONE;
    }
}

int PlayGround::getWidth(void)
{
    return map.getWidth();
}

int PlayGround::getHeight(void)
{
    return map.getHeight();
}

Type PlayGround::getCursorType(void)
{
    return cursor.getType();
}

bool PlayGround::getCursorBit(int no)
{
    return cursor.getBit(no);
}

Field PlayGround::getField(int x, int y)
{
    return map.getField(x, y);
}

Player PlayGround::getPlayer(void)
{
    return player;
}

int PlayGround::getScore(Player p)
{
    return map.checkFields(p, OFF);
}
