/***************************************************************************
                          digit.cpp  -  description
                             -------------------
    begin                : Don Dez  9 18:23:21 CET 1999
    copyright            : (C) 1999 by Ralf-Christian Juergensen
    email                : ralf-christian.juergensen@stud.fh-flensburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "digit.h"

Digit::Digit(const char* name) : KTMainWindow(name)
{
    menuSetup();
    
    scoreboard = new ScoreBoard(statusBar());
    statusBar()->insertWidget(scoreboard, width(), ID_SCOREBOARD);
    
    playground = NULL;
}

Digit::~Digit()
{
    delete gamePopup;
}

void Digit::newGame()
{
    if(playground == NULL)
    {
        playground = new KPlayGround(this, 0, ONE, QString(DIGIT_MAP_DIR)+"1.map");
        
        connect(playground, SIGNAL(winner(Player)), SLOT(printWinner(Player)));
        connect(playground, SIGNAL(nextRound()), SLOT(printScore()));
        
        setView(playground);
        
        playground->show();
     
        gamePopup->setItemEnabled(ID_NEW_MAP, true);
                   
        printScore();
        
        updateRects();
    }
    else
    {
        playground->newGame(ONE);
    }
}

void Digit::newMap()
{
    QString mapFileName;
    
    if(playground != NULL)
    {
        mapFileName = KFileDialog::getOpenFileName(DIGIT_MAP_DIR, "*.map", this, 0);
    	
        if(!mapFileName.isNull())
        {
            playground->newMap(mapFileName);
                
            updateRects();
        }
    }
}

void Digit::menuSetup()
{
    gamePopup = new QPopupMenu();
    gamePopup->insertItem(i18n("&New Game"), this, SLOT(newGame()), CTRL+Key_N, ID_NEW_GAME);
    gamePopup->insertItem(i18n("New &Map"), this, SLOT(newMap()), CTRL+Key_M, ID_NEW_MAP);
    gamePopup->insertSeparator();
    gamePopup->insertItem(i18n("E&xit"), kapp, SLOT(quit()), CTRL+Key_Q, ID_EXIT);

    gamePopup->setItemEnabled(ID_NEW_MAP, false);
    	
    // About-Text
    QString about;
    
    about.sprintf(i18n("%s %s\n"
                       "\n"
                       " Copyright 1998,1999 by Ralf-Christian Juergensen\n"
                       "<ralf-christian.juergensen@stud.fh-flensburg.de>\n"),
                       PROG_NAME, VERSION);

    QPopupMenu* helpPopup = kapp->getHelpMenu(true, about);

    menuBar()->insertItem(i18n("&Game"), gamePopup, ID_GAME);
    menuBar()->insertSeparator();
    menuBar()->insertItem(i18n("&Help"), helpPopup, ID_HELP);    
}

void Digit::printWinner(Player winner)
{
	QString winnerText;
	
	winnerText.sprintf(i18n("The winner is player %d."), int(winner));
	
	QMessageBox::information(0,
                             i18n("Winner"),
                             winnerText);
	
	playground->newGame(winner);
}

void Digit::printScore(void)
{
	scoreboard->setScore(playground->getScore(ONE), playground->getScore(TWO));

	scoreboard->setPlayer(playground->getPlayer());
}

void Digit::resizeEvent(QResizeEvent*)
{
    updateRects();
}
