#include "Draw3D.h"
#include <math.h>

Draw3D* Draw3D::globalInstance = 0;

Draw3D::Draw3D()
{
	currentColor = Color (255, 255, 255);

	coordinatesBuffer.xValues=coordinatesBuffer.yValues=0;
	coordinatesBuffer.size=coordinatesBuffer.maxValues=0;

	setPerspective (-1, 1, -1, 1, 1, 0.5, true);
}

Draw3D::~Draw3D()
{
	if (!coordinatesBuffer.xValues)
		delete[] coordinatesBuffer.xValues;

	if (!coordinatesBuffer.yValues)
		delete[] coordinatesBuffer.yValues;
}

void Draw3D::drawLine (const Position& pos0, const Position& pos1)
{
	int x0,y0,x1,y1;
	
	projectTo2D (&pos0, &x0, &y0);
	projectTo2D (&pos1, &x1, &y1);

	drawLine2D (x0, y0, x1, y1);
}

void Draw3D::drawLineStrip  (const Position pos[], const int n)
{
	maxAllocateBuffer (n);

	coordinatesBuffer.size=n;

	const Position *currentPos=pos;
	int *currentX=coordinatesBuffer.xValues,
		*currentY=coordinatesBuffer.yValues;

	// transform all coordinates
	for (int i=0; i<n; i++)
	{
		projectTo2D (currentPos, currentX, currentY);

		currentX++;
		currentY++;
		currentPos++;
	}

	drawLineStrip2D();
}

void Draw3D::drawPolygon  (const Position pos[], const int n)
{
	maxAllocateBuffer (n+1);

	coordinatesBuffer.size=n+1;

	const Position *currentPos=pos;
	int *currentX=coordinatesBuffer.xValues,
		*currentY=coordinatesBuffer.yValues;

	// transform all coordinates
	for (int i=0; i<n; i++)
	{
		projectTo2D (currentPos, currentX, currentY);

		currentX++;
		currentY++;
		currentPos++;
	}

	// don't calculate ending point
	*currentX=coordinatesBuffer.xValues [0];
	*currentY=coordinatesBuffer.yValues [0];

	drawLineStrip2D();
}

void Draw3D::drawFilledRectangleZ (const Position& p0, const Position& p1)
{
	maxAllocateBuffer (4);

	coordinatesBuffer.size=4;

	int *currentX=coordinatesBuffer.xValues,
		*currentY=coordinatesBuffer.yValues;

	// lower left corner
	projectTo2D (&p0, currentX, currentY);

	// lower right corner
	Position tmpPosition (p1.getX(), p0.getY(), p0.getZ());
	currentX++;
	currentY++;
	projectTo2D (&tmpPosition, currentX, currentY);

	// upper right corner
	currentX++;
	currentY++;
	projectTo2D (&p1, currentX, currentY);

	// upper left corner
	Position tmpPosition2 (p0.getX(), p1.getY(), p0.getZ());
	currentX++;
	currentY++;
	projectTo2D (&tmpPosition2, currentX, currentY);

	drawFilledPolygon2D();
}

void Draw3D::drawFilledRectangleX (const Position& p0, const Position& p1)
{
	maxAllocateBuffer (4);

	coordinatesBuffer.size=4;

	int *currentX=coordinatesBuffer.xValues,
		*currentY=coordinatesBuffer.yValues;

	// lower left corner
	projectTo2D (&p0, currentX, currentY);

	// lower right corner
	Position tmpPosition (p0.getX(), p0.getY(), p1.getZ());
	currentX++;
	currentY++;
	projectTo2D (&tmpPosition, currentX, currentY);

	// upper right corner
	currentX++;
	currentY++;
	projectTo2D (&p1, currentX, currentY);

	// upper left corner
	Position tmpPosition2 (p0.getX(), p1.getY(), p0.getZ());
	currentX++;
	currentY++;
	projectTo2D (&tmpPosition2, currentX, currentY);

	drawFilledPolygon2D();
}

void Draw3D::drawFilledRectangleY (const Position& p0, const Position& p1)
{
	maxAllocateBuffer (4);

	coordinatesBuffer.size=4;

	int *currentX=coordinatesBuffer.xValues,
		*currentY=coordinatesBuffer.yValues;

	// lower left corner
	projectTo2D (&p0, currentX, currentY);

	// lower right corner
	Position tmpPosition (p1.getX(), p0.getY(), p0.getZ());
	currentX++;
	currentY++;
	projectTo2D (&tmpPosition, currentX, currentY);

	// upper right corner
	currentX++;
	currentY++;
	projectTo2D (&p1, currentX, currentY);

	// upper left corner
	Position tmpPosition2 (p0.getX(), p0.getY(), p1.getZ());
	currentX++;
	currentY++;
	projectTo2D (&tmpPosition2, currentX, currentY);

	drawFilledPolygon2D();
}

void Draw3D::maxAllocateBuffer (int n)
{
	if (coordinatesBuffer.maxValues)
	{
		if (coordinatesBuffer.maxValues >= n)
			return;
		
		delete[] coordinatesBuffer.xValues;
		delete[] coordinatesBuffer.yValues;
	}
	
	coordinatesBuffer.xValues=new int[n];
	coordinatesBuffer.yValues=new int[n];
}

void Draw3D::projectTo2D (const Position *pos, int *x, int *y)
{
	// calculate X and Y coordinates in 2D room 
	// do a perspective projection, objects farer away look nearer to center
	double reduction;

	if (positiveZ)			// looking in positive z direction
		reduction=pow (perspectiveFactor, pos->getZ()-nearZ);
	else
		reduction=pow (perspectiveFactor, nearZ-pos->getZ());

	// x2D = [0,width]
	double x2D=middleX+(pos->getX()-middleX)*reduction;
	double y2D=middleY+(pos->getY()-middleY)*reduction;

	// now project to image coordinates
	// based on (0,0)=left lower corner

	*x=(int) (width*(x2D-leftX)/(rightX-leftX));
	*y=(int) (height*(y2D-lowerY)/(upperY-lowerY));
}

// Local Variables:
// compile-command: "make Draw3D.o"
// End:
