/* -*- C++ -*- */

#ifndef _BLOCKOUT_H_
#define _BLOCKOUT_H_

#include <kapp.h>
#include <ktopwidget.h>
#include <qpopmenu.h>
#include <qkeycode.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>

#include "Settings.h"
#include "GameViewWidget.h"

class BlockOut : public KTopLevelWidget
{
	Q_OBJECT
public:

	BlockOut (const char *name=NULL);
	~BlockOut();

protected:

	enum {SB_POINTS,SB_LEVEL,SB_WHAT_DOING,SB_NOTHING};

	KMenuBar *menu;
	KStatusBar *statusBar;
	KToolBar *firstToolBar;
	GameViewWidget *view;

	Obstacle *obstacle;
	PerformGamePlay *gamePlay;

	int sizeX, sizeY, sizeZ, startingLevel;
	
	void createMenu();
	void createStatusBar();
	void createToolBar();

	void saveProperties (KConfig *config);
	void readProperties (KConfig *config);
	
 protected slots:
	void saveProperties();

	void newPoints (int i);
	void gameEnded();
	void newLevel (int i);
	void settings();

	void newGame();
};

#endif _BLOCKOUT_H_
