/* This may look like C, but it's really -*- C++ -*- */

/*
    kdb - A Simple but fast database editor for the KDE
    Copyright (C) 1998  Thorsten Niedzwetzki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __MEMORYDB_H_
#define __MEMORYDB_H_

#include "database.h"
#include <string.h>
#include <qlist.h>
#include <qstring.h>
#include <qstrlist.h>

/* TMemoryDB is a derivation from TDataBase which assumes that
   databases are loaded fully into memory. This is applicable for very
   small files with the assumption that no two users are editing the
   same file. This may sound too restrictive, but it's perfectly right
   for files like /etc/password or quite small address databases. */
class TMemoryDB : public TDataBase {

public:
  TMemoryDB() : TDataBase(), fieldNames(0), data(0) { }
  virtual ~TMemoryDB();

  // removes all data
  virtual void clear();
  
  // reset field names to given list
  virtual bool setFieldNames(QStrList *fieldNames);

  // should compute its value using fieldNames list, false on error
  virtual char* getFieldName(unsigned int fieldNo) const;
  virtual QStrList* getFields() const;

  // should compute its value using fieldNames list
  // or -1 on error
  virtual unsigned int getFieldCount() const;

  virtual unsigned int getRecordCount() const;

  // should compute its value using the data list of -1 on error
  virtual bool appendRecordAsText(QStrList *record);
  virtual bool replaceRecordAsText(unsigned int recNo, QStrList *record);
  virtual QStrList* getRecord(int record) const;
  virtual bool removeRecord(int record);
  
  virtual bool loadFromFile(const char *) { return false; }
  virtual bool writeToFile(const char *) { return false; }

  virtual char* getItemAsText(int record, int field) const;
  
private:
  QStrList *fieldNames;
  QList<QStrList> *data;
  // a list of lists. Every list in that list is one record
};

#endif
