/* This may look like C, but it's really -*- C++ -*- */

/*
    debug.h - handling debug output
    Copyright (C) 1998  Thorsten Niedzwetzki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __DEBUG_H
#define __DEBUG_H

#ifndef NDEBUG

#include <iostream.h>
#include <stdlib.h>

#ifdef APPNAME

#define DISPLAY(x) { \
  cerr << APPNAME ":" __FILE__ "(" << __LINE__ << "): " #x << endl; \
  (x); \
}

#define MESSAGE(x) { \
  cerr << APPNAME ":" __FILE__ "(" << __LINE__ << "): " << x << endl; \
}

#else /* not APPNAME */

#define DISPLAY(x) { \
  cerr << __FILE__ "(" << __LINE__ << "): " #x << endl; \
  (x); \
}

#define MESSAGE(x) { \
  cerr << __FILE__ "(" << __LINE__ << "): " << x << endl; \
}

#endif /* APPNAME */

#endif /* not NDEBUG */

#endif /* not __DEBUG_H */
