/* This may look like C but it's really -*- C++ -*- */

/*
    kdb - A Simple but fast database editor for the KDE
    Copyright (C) 1998  Thorsten Niedzwetzki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __DBVIEWER_H
#define __DBVIEWER_H

#define DEFAULT_EXTENSION "csd"
#define STRLEN 4096

// -------------------- C --------------------
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

// ------------------- C++ -------------------
#include <fstream.h>
#include <iostream.h>
#include <strstream.h>

// ------------------- Qt --------------------
#include <qlabel.h>
#include <qcombo.h>
#include <qstring.h>
#include <qmenubar.h>
#include <qpopmenu.h>
#include <qmsgbox.h>
#include <qframe.h>
#include <qtooltip.h>
#include <qkeycode.h>
#include <qfiledlg.h>

// ------------------- KDE -------------------
#include <ktopwidget.h>
#include <ksimpleconfig.h>
#include <kconfigbase.h>
#include <kapp.h>
#include <kmenubar.h>
#include <kcolordlg.h>
#include <kiconloader.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <klocale.h>
#include <ktablistbox.h>
#include <kfiledialog.h>
#include <kstdaccel.h>
#include <kmsgbox.h>
#include <kwm.h>

// ---------------- My Files -----------------
#include "charsepdb.h"
#include "newtabledialog.h"
#include "editrecdialog.h"
#include "fileformatdialog.h"
#include "finddialog.h"
#include "main.h"

enum menuPosition {Top, Bottom, Float};

class TDBViewer : public KTopLevelWidget {
  Q_OBJECT

private:
  // buttons
  const int BTN_FILE_NEW  = 101;
  const int BTN_FILE_OPEN = 102;
  const int BTN_FILE_SAVE = 103;

  // status bar
  const int STAT_LEFT  = 1;
  const int STAT_RIGHT = 2;

  // menu bar;
  const int MENU_FILE    = 1;
  const int MENU_EDIT    = 4;
  const int MENU_OPTIONS = 7;
  const int MENU_HELP    = 9;

public:
  TDBViewer(char* name = 0, TCharSepDB* db = 0,
	    char* fileName = 0);
  ~TDBViewer();

  void setModified();

protected:
  void resizeEvent(QResizeEvent*);
  void paintEvent(QPaintEvent*);
  void closeEvent(QCloseEvent*);

  void setupWindow(); // called once by constructor
  static QList<TDBViewer> windowlist;

private slots:
  virtual void fileNew();
  virtual void fileOpen();
  virtual void fileSave();
  virtual void fileSaveAs();
  virtual void fileClose();
  virtual void filePrint();
  virtual void fileQuit();

  virtual void editHeader();
  virtual void editNew();
  virtual void editEdit();
  virtual void editFind();
  virtual void editCopy();
  virtual void editPaste();
  virtual void editCut();
  virtual void editDelete();

  virtual void optionsFileFormat();
  virtual void optionsFileContainsHeader();
  virtual void optionsConfirmActions();
  virtual void optionsAlwaysSave();

  virtual void itemHighlighted(int index, int column);
  virtual void itemSelected(int index, int);

private:
  // private member functions
  void saveConfig();
  void readConfigurationFile();

  void updateView();
  void setEditCommands();
  void updateStatusBar(unsigned int selectedRecord = 0);

  // private attributes
  TCharSepDB *db;
  char *fileName;
  bool modified;  // modified database in memory

  // flags
  bool confirmActions; // confirm actions (for new users)
  bool alwaysSave;  // save after each modification
  bool fileContainsHeader;  // does first record contain header info?
  char separator;

  // UI items
  KMenuBar *menu;
  KToolBar *toolbar;
  KStatusBar *stat;
  KTabListBox *lb;
  QPopupMenu *file, *edit, *options, *help;
};

#endif /* __DBVIEWER_H */
