/*
 * ark -- archiver for the KDE project
 *
 * Copyright (C) 2007 Henrique Pinto <henrique.pinto@kdemail.net>
 * Copyright (C) 2008 Harald Hvaal <haraldhv@stud.ntnu.no>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <KParts/MainWindow>
#include <KParts/OpenUrlArguments>

namespace KParts
{
class ReadWritePart;
}

class KRecentFilesAction;

class MainWindow: public KParts::MainWindow
{
    Q_OBJECT
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    bool loadPart();

    void dragEnterEvent(class QDragEnterEvent * event) Q_DECL_OVERRIDE;
    void dropEvent(class QDropEvent * event) Q_DECL_OVERRIDE;
    void dragMoveEvent(class QDragMoveEvent * event) Q_DECL_OVERRIDE;

public slots:
    void openUrl(const QUrl &url);
    void setShowExtractDialog(bool);

protected:
    void closeEvent(QCloseEvent *event) Q_DECL_OVERRIDE;

private slots:
    void updateActions();
    void newArchive();
    void openArchive();
    void quit();
    void showSettings();
    void writeSettings();

private:
    void setupActions();

    KParts::ReadWritePart *m_part;
    KRecentFilesAction    *m_recentFilesAction;
    QAction               *m_openAction;
    QAction               *m_newAction;
    KParts::OpenUrlArguments m_openArgs;
};

#endif // MAINWINDOW_H
