/*
 * kxsldbg.cpp
 *
 * Copyright (C) 2001  <kurt@granroth.org>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ************************************************************************* */

#include "kxsldbg.h"

#include <kshortcutsdialog.h>
#include <kconfig.h>
#include <klocale.h>

#include <kedittoolbar.h>

#include <kaction.h>
#include <kstandardaction.h>
#include <ktoolbar.h>
#include <ktoggleaction.h>

#include <klibloader.h>
#include <kmessagebox.h>
#include <kstatusbar.h>
#include "kxsldbgpartinterface.h"

#include <QtDBus>
#include <kactioncollection.h>

KXsldbg::KXsldbg()
{

    QDBusConnection bus = QDBusConnection::sessionBus();
    LocalKXsldbgPartInterface * interface = new LocalKXsldbgPartInterface("", "/KXsldbgPart", bus, this);
    connect(interface, SIGNAL(newCursorPosition(const QString &, int, int)) 
            , this, SLOT(newCursorPosition(const QString &, int, int))); 

    //connect(interface, SIGNAL(newDebuggerPosition(const QString, int)) 
    //        , this, SLOT(newCursorPosition(const QString &, int, 0))); 

    // set the shell's ui resource file
    setXMLFile("kxsldbg_shell.rc");

    // then, setup our actions
    setupActions();

    // and a status bar
    statusBar()->show();
    statusBar()->setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred));

#ifdef __GNUC__
#warning "kde4: port it"
#endif
    // this routine will find and load our Part.  it finds the Part by
    // name which is a bad idea usually.. but it's alright in this
    // case since our Part is made for this Shell
    KPluginLoader loader("libkxsldbgpart");
    KPluginFactory* factory = loader.factory();
    if (factory)
    {
        // now that the Part is loaded, we cast it to a Part to get
        // our hands on it
        m_part = static_cast<KParts::ReadOnlyPart *>(factory->create(this, "KParts::ReadOnlyPart"));

        if (m_part)
        {
            m_part->setObjectName("kxsldbg_part");
            // tell the KParts::MainWindow that this is indeed the main widget
            setCentralWidget(m_part->widget());

            // and integrate the part's GUI with the shell's
            createGUI(m_part);
        }else{
		// if we couldn't find our Part, we exit since the Shell by
		// itself can't do anything useful
		KMessageBox::error(this, i18n("Could not create our part."));
		kapp->quit();
	}
    }
    else
    {
		// if we couldn't find our Part, we exit since the Shell by
		// itself can't do anything useful
		KMessageBox::error(this, i18n("Could not find our part."));
		kapp->quit();
    }
}

KXsldbg::~KXsldbg()
{
    if (m_part)
	m_part->closeUrl();

    delete m_part;
}

void KXsldbg::quit()
{
    closeUrl();
    close();
}

bool KXsldbg::closeUrl()
{
    if (m_part)
	m_part->closeUrl();

    return true;
}

void KXsldbg::setupActions()
{
    KAction *act = KStandardAction::quit(kapp, SLOT(quit()), actionCollection());
    connect(act, SIGNAL(activated()), this, SLOT(quit()));

    m_statusbarAction = KStandardAction::showStatusbar(this, SLOT(optionsShowStatusbar()), actionCollection());

    KStandardAction::keyBindings(this, SLOT(optionsConfigureKeys()), actionCollection());
    KStandardAction::configureToolbars(this, SLOT(optionsConfigureToolbars()), actionCollection());
}

void KXsldbg::optionsShowToolbar()
{
    // this is all very cut and paste code for showing/hiding the
    // toolbar
    if (m_toolbarAction->isChecked())
        toolBar()->show();
    else
        toolBar()->hide();
}

void KXsldbg::optionsShowStatusbar()
{
    // this is all very cut and paste code for showing/hiding the
    // statusbar
    if (m_statusbarAction->isChecked())
        statusBar()->show();
    else
        statusBar()->hide();
}

void KXsldbg::optionsConfigureKeys()
{
    //KShortcutsDialog::configure(actionCollection(), "kxsldbg_shell.rc");
	KShortcutsDialog::configure( actionCollection());

}

void KXsldbg::optionsConfigureToolbars()
{
    saveMainWindowSettings(KGlobal::config()->group( "MainWindow") );

    // use the standard toolbar editor
    KEditToolBar dlg(factory());
    connect(&dlg, SIGNAL(newToolbarConfig()),
            this, SLOT(applyNewToolbarConfig()));
    dlg.exec();
}

void KXsldbg::applyNewToolbarConfig()
{
    applyMainWindowSettings(KGlobal::config()->group( "MainWindow") );
}


void KXsldbg::newCursorPosition(const QString &file, int lineNumber, int columnNumber)
{
    statusBar()->clearMessage();
    statusBar()->showMessage( i18n("File: %1  Line: %2  Col: %3", file, lineNumber, columnNumber));
}

void KXsldbg::newDebuggerPosition(const QString &file, int lineNumber)
{
    // maybe do something extra here later
    newCursorPosition(file, lineNumber, 0);
}

#include "kxsldbg.moc"
