//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  @brief A time zone selection widget.
    ///  <b></b>etail:
    ///  This class provides for selection of one or more time zones.
    ///  <b></b>xample:
    ///  To use the class to implement a system timezone selection feature:
    ///  <pre>
    ///   // This adds a time zone widget to a dialog.
    ///   m_timezones = new KTimeZoneWidget(this);
    ///   ...
    ///  </pre>
    ///  To use the class to implement a multiple-choice custom time zone selector:
    ///  <pre>
    ///   m_timezones = new KTimeZoneWidget( this, "Time zones", vcalendarTimezones );
    ///   m_timezones.SetSelectionMode( QTreeView.MultiSelection );
    ///   ...
    ///  </pre>
    /// </remarks>        <author> S.R.Haque <srhaque@iee.org>
    ///  </author>
    ///         <short>    @brief A time zone selection widget.</short>
    [SmokeClass("KTimeZoneWidget")]
    public class KTimeZoneWidget : QTreeWidget, IDisposable {
        protected KTimeZoneWidget(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KTimeZoneWidget), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KTimeZoneWidget() {
            staticInterceptor = new SmokeInvocation(typeof(KTimeZoneWidget), null);
        }
        /// <remarks>
        ///  Constructs a time zone selection widget.
        /// <param> name="parent" The parent widget.
        /// </param><param> name="timeZones" The time zone database to use. If 0, the system time zone
        ///                   database is used.
        ///      </param></remarks>        <short>    Constructs a time zone selection widget.</short>
        public KTimeZoneWidget(QWidget parent, KTimeZones timeZones) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KTimeZoneWidget##", "KTimeZoneWidget(QWidget*, KTimeZones*)", typeof(void), typeof(QWidget), parent, typeof(KTimeZones), timeZones);
        }
        public KTimeZoneWidget(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KTimeZoneWidget#", "KTimeZoneWidget(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public KTimeZoneWidget() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KTimeZoneWidget", "KTimeZoneWidget()", typeof(void));
        }
        /// <remarks>
        ///  Returns the currently selected time zones. See QTreeView.SelectionChanged().
        /// </remarks>        <return> a list of time zone names, in the format used by the database
        ///          supplied to the {@link KTimeZoneWidget() } constructor.
        ///      </return>
        ///         <short>    Returns the currently selected time zones.</short>
        public List<string> Selection() {
            return (List<string>) interceptor.Invoke("selection", "selection() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Select/deselect the named time zone.
        /// <param> name="zone" The time zone name to be selected. Ignored if not recognized!
        /// </param><param> name="selected" The new selection state.
        ///      </param></remarks>        <short>    Select/deselect the named time zone.</short>
        public void SetSelected(string zone, bool selected) {
            interceptor.Invoke("setSelected$$", "setSelected(const QString&, bool)", typeof(void), typeof(string), zone, typeof(bool), selected);
        }
        ~KTimeZoneWidget() {
            interceptor.Invoke("~KTimeZoneWidget", "~KTimeZoneWidget()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KTimeZoneWidget", "~KTimeZoneWidget()", typeof(void));
        }
        /// <remarks>
        ///  Format a time zone name in a standardised manner. The returned value is
        ///  transformed via an i18n lookup, so the caller should previously have
        ///  set the time zone catalog:
        ///  <pre>
        ///    KGlobal.Locale().InsertCatalog( "timezones4" );
        ///  </pre>
        /// </remarks>        <return> formatted time zone name.
        ///      </return>
        ///         <short>    Format a time zone name in a standardised manner.</short>
        public static string DisplayName(KTimeZone zone) {
            return (string) staticInterceptor.Invoke("displayName#", "displayName(const KTimeZone&)", typeof(string), typeof(KTimeZone), zone);
        }
        protected new IKTimeZoneWidgetSignals Emit {
            get { return (IKTimeZoneWidgetSignals) Q_EMIT; }
        }
    }

    public interface IKTimeZoneWidgetSignals : IQTreeWidgetSignals {
    }
}
