/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pminsertpopup.h"
#include <klocale.h>
#include <kiconloader.h>
#include <qcursor.h>

PMInsertPopup::PMInsertPopup( QWidget* parent, bool multipleObjects,
                              int items, bool canInsertAllAsFirstChildren,
                              bool canInsertAllAsLastChildren,
                              bool canInsertAllAsSiblings, const char* )
      : KMenu( parent )
{
   QString itemText;
   if( multipleObjects )
   {
      addTitle( i18n( "Insert Objects As" ) );
      if( ( items & PMIFirstChild ) == PMIFirstChild )
      {
         itemText = i18n( "First Children" );
         if( !canInsertAllAsFirstChildren )
            itemText += " (" + i18n( "some" ) + ")";
         addAction( SmallIcon( "pminsertfirstchild" ), itemText);
      }
      if( ( items & PMILastChild ) == PMILastChild )
      {
         itemText = i18n( "Last Children" );
         if( !canInsertAllAsLastChildren )
            itemText += " (" + i18n( "some" ) + ")";
         addAction( SmallIcon( "pminsertlastchild" ), itemText );
      }
      if( ( items & PMISibling ) == PMISibling )
      {
         itemText = i18n( "Siblings" );
         if( !canInsertAllAsSiblings )
            itemText += " (" + i18n( "some" ) + ")";
         addAction( SmallIcon( "pminsertsibling" ), itemText );
      }
   }
   else
   {
      addTitle( i18n( "Insert Object As" ) );
      if( ( items & PMIFirstChild ) == PMIFirstChild )
         addAction( SmallIcon( "pminsertfirstchild" ), i18n( "First Child" ) );
      if( ( items & PMILastChild ) == PMILastChild )
         addAction( SmallIcon( "pminsertlastchild" ), i18n( "Last Child" ) );
      if( ( items & PMISibling ) == PMISibling )
         addAction( SmallIcon( "pminsertsibling" ), i18n( "Sibling" ) );
   }
}

int PMInsertPopup::choosePlace( QWidget* parent, bool multipleObjects,
                                int items, bool canInsertAllAsFirstChildren,
                                bool canInsertAllAsLastChildren,
                                bool canInsertAllAsSiblings )
{
   int result;
   PMInsertPopup* popup = new PMInsertPopup( parent, multipleObjects, items,
                                             canInsertAllAsFirstChildren,
                                             canInsertAllAsLastChildren,
                                             canInsertAllAsSiblings );
   result = popup->actions().indexOf(popup->exec(QCursor::pos( )));
   if( result < 0 )
      result = 0;
   delete popup;

   return result;
}
