/* This file is part of the KDE project

   Copyright (C) 2001 Andreas Schlapbach <schlpbch@iam.unibe.ch>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include <qlabel.h>
#include <kvbox.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <QGroupBox>
//Added by qt3to4:
#include <QVBoxLayout>
#include <kconfig.h>

#include <klocale.h>

#include "validatorsdialog.h"
#include "validatorsdialog.moc"

ValidatorsDialog::ValidatorsDialog(QWidget *parent )
  : KDialog( parent)
{
  setCaption(i18n("Configure"));
  setButtons(Ok|Cancel);
  setDefaultButton(Ok);
  setModal(false);
  showButtonSeparator(true);
  setCaption(i18n("Configure Validating Servers"));
  setMinimumWidth(300);

  KVBox *page = new KVBox(this);
  setMainWidget(page);

  QGroupBox *tgroup = new QGroupBox( i18n("HTML/XML Validator"), page );
  QVBoxLayout *vlay = new QVBoxLayout(tgroup);
  vlay->setSpacing(spacingHint());

  vlay->addWidget(new QLabel( i18n("URL:"), tgroup));

  m_WWWValidatorCB = new QComboBox(tgroup);
  m_WWWValidatorCB->setEditable(true);
  m_WWWValidatorCB->setDuplicatesEnabled(false);
  vlay->addWidget( m_WWWValidatorCB );

  vlay->addWidget(new QLabel( i18n("Upload:"), tgroup));

  m_WWWValidatorUploadCB = new QComboBox(tgroup);
  m_WWWValidatorUploadCB->setEditable(true);
  m_WWWValidatorUploadCB->setDuplicatesEnabled(false);
  vlay->addWidget( m_WWWValidatorUploadCB );

  ///

  QGroupBox *group2= new QGroupBox( i18n("CSS Validator"), page );
  QVBoxLayout *vlay2 = new QVBoxLayout(group2);
  vlay2->setSpacing(spacingHint());

  vlay2->addWidget(new QLabel( i18n("URL:"), group2));

  m_CSSValidatorCB = new QComboBox(group2);
  m_CSSValidatorCB->setEditable(true);
  m_CSSValidatorCB->setDuplicatesEnabled(false);
  vlay2->addWidget( m_CSSValidatorCB );

  vlay2->addWidget(new QLabel( i18n("Upload:"), group2));

  m_CSSValidatorUploadCB = new QComboBox(group2);
  m_CSSValidatorUploadCB->setEditable(true);
  m_CSSValidatorUploadCB->setDuplicatesEnabled(false);
  vlay2->addWidget( m_CSSValidatorUploadCB );

  ///

  QGroupBox *group3= new QGroupBox( i18n("Link Validator"), page );
  QVBoxLayout *vlay3 = new QVBoxLayout(group3);
  vlay3->setSpacing(spacingHint());

  vlay3->addWidget(new QLabel( i18n("URL:"), group3));

  m_linkValidatorCB = new QComboBox(group3);
  m_linkValidatorCB->setEditable(true);
  m_linkValidatorCB->setDuplicatesEnabled(false);
  vlay3->addWidget( m_linkValidatorCB );

  connect(this,SIGNAL(okClicked()),this,SLOT(slotOk()));
  connect(this,SIGNAL(cancelClicked()),this,SLOT(slotCancel()));
  load();
}

ValidatorsDialog::~ValidatorsDialog()
{
    delete m_config;
}

void ValidatorsDialog::load()
{
  m_config = new KConfig("validatorsrc");
  KConfigGroup group = m_config->group("Addresses");

  m_WWWValidatorCB->addItems(group.readEntry("WWWValidatorUrl",QStringList()));
  if (m_WWWValidatorCB->count()==0) {
    m_WWWValidatorCB->addItem("http://validator.w3.org/check");
  }
  m_WWWValidatorCB->setCurrentIndex(group.readEntry("WWWValidatorUrlIndex",0));

  m_CSSValidatorCB->addItems(group.readEntry("CSSValidatorUrl",QStringList()));
  if (m_CSSValidatorCB->count()==0) {
    m_CSSValidatorCB->addItem("http://jigsaw.w3.org/css-validator/validator");
  }
  m_CSSValidatorCB->setCurrentIndex(group.readEntry("CSSValidatorUrlIndex",0));

  m_linkValidatorCB->addItems(group.readEntry("LinkValidatorUrl",QStringList()));
  if (m_linkValidatorCB->count()==0) {
    m_linkValidatorCB->addItem("http://validator.w3.org/checklink");
  }
  m_linkValidatorCB->setCurrentIndex(group.readEntry("LinkValidatorUrlIndex",0));

  m_WWWValidatorUploadCB->addItems(group.readEntry("WWWValidatorUploadUrl",QStringList()));
  if (m_WWWValidatorUploadCB->count()==0) {
    m_WWWValidatorUploadCB->addItem("http://validator.w3.org/file-upload.html");
  }
  m_WWWValidatorUploadCB->setCurrentIndex(group.readEntry("WWWValidatorUploadUrlIndex",0));

  m_CSSValidatorUploadCB->addItems(group.readEntry("CSSValidatorUploadUrl",QStringList()));
  if (m_CSSValidatorUploadCB->count()==0) {
    m_CSSValidatorUploadCB->addItem("http://jigsaw.w3.org/css-validator/validator-upload.html" );
  }
  m_CSSValidatorUploadCB->setCurrentIndex(group.readEntry("CSSValidatorUploadUrlIndex",0));
}

void ValidatorsDialog::save()
{
  KConfigGroup group = m_config->group("Addresses");
  QStringList strList;
  for (int i = 0; i < m_WWWValidatorCB->count(); i++) {
    strList.append(m_WWWValidatorCB->itemText(i));
  }
  group.writeEntry( "WWWValidatorUrl", strList );
  strList.clear();
  for (int i = 0; i < m_CSSValidatorCB->count(); i++) {
    strList.append(m_CSSValidatorCB->itemText(i));
  }
  group.writeEntry( "CSSValidatorUrl", strList );
  strList.clear();
  for (int i = 0; i < m_linkValidatorCB->count(); i++) {
    strList.append(m_linkValidatorCB->itemText(i));
  }
  group.writeEntry( "LinkValidatorUrl", strList );
  strList.clear();
  for (int i = 0; i < m_WWWValidatorUploadCB->count(); i++) {
    strList.append(m_WWWValidatorUploadCB->itemText(i));
  }
  group.writeEntry( "WWWValidatorUploadUrl", strList );
  strList.clear();
  for (int i = 0; i < m_CSSValidatorUploadCB->count(); i++) {
    strList.append(m_CSSValidatorUploadCB->itemText(i));
  }
  group.writeEntry( "CSSValidatorUploadUrl", strList );

  group.writeEntry( "WWWValidatorUrlIndex", m_WWWValidatorCB->currentIndex() );
  group.writeEntry( "CSSValidatorUrlIndex", m_CSSValidatorCB->currentIndex() );
  group.writeEntry( "LinkValidatorUrlIndex", m_linkValidatorCB->currentIndex() );
  group.writeEntry( "WWWValidatorUploadUrlIndex", m_WWWValidatorUploadCB->currentIndex() );
  group.writeEntry( "CSSValidatorUploadUrlIndex", m_CSSValidatorUploadCB->currentIndex() );
  group.sync();
}

void ValidatorsDialog::slotOk()
{
   save();
   hide();
}

void ValidatorsDialog::slotCancel()
{
   load();
   hide();
}
