
;;; copy-downloads.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: copy-downloads.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Unix Backup
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun copy-downloads ()
  (interactive)
  (setq c-downloads "/media/www/C1TB/Downloads/")
  (setq f-downloads "/media/www/CC8EF01C8EEFFD30/Downloads/")
  (let (ptr list len count)
    (setq list (directory-files-deep c-downloads))
    (setq ptr list)
    (setq len (length list))
    (setq count 0)
    (while ptr
      (make-directory (file-name-directory (concat f-downloads (car ptr))) 'PARENTS)
      (condition-case err
          (if (file-directory-p (concat f-downloads (car ptr)))
              (make-directory (concat f-downloads (car ptr)) 'PARENTS)
            (message "Copying file %s progress=%s" (car ptr) (/ (* 100 count) len))
            (copy-file (concat c-downloads (car ptr))
                       (concat f-downloads (car ptr))
                       nil
                       'KEEP-TIME))
        (error nil))
      (incf count)
      (setq ptr (cdr ptr))))
  (let (ptr list len count)
    (setq list (directory-files-deep f-downloads))
    (setq ptr list)
    (setq len (length list))
    (setq count 0)
    (while ptr
      (if (file-exists-p (concat c-downloads (car ptr)))
          (condition-case err
              (if (file-directory-p (concat c-downloads (car ptr)))
                  (make-directory (concat c-downloads (car ptr)) 'PARENTS)
                (message "Copying file %s progress=%s" (car ptr) (/ (* 100 count) len))
                (copy-file (concat f-downloads (car ptr))
                           (concat c-downloads (car ptr))
                           nil
                           'KEEP-TIME))
            (error nil)))
      (incf count)
      (setq ptr (cdr ptr)))))
