/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

var relationChecker = require("js_checker/relation_checker").relationChecker;
var checkTypes = require("js_checker/constant_types").checkTypes;
var scriptsCached = require("script_entries/scripts_cache").scriptsCached;

/*
 * 
 * List of free libraries and their SHA256 hash.
 * This is used to recognize the most common free libraries.
 * 
 */

var freeLibraries = {
    
    "3fa74bb289537fcdee796b26968e47d53d38f903": {filename: "underscore.1.3.2.underscore.js"},

    "e1c9252b3e60673e4fa1bb1648cb18cd33139535": {filename: "jquery.1.1.3.1.jquery-1.1.3.1.js"},

    "d5203dbbb97db1a68ca5a3adf265f17cdaea738d": {filename: "jqueryui.1.8.8.jquery-ui.js"},

    "a6edefef305d9164212fa140426629c7d8a58c93": {filename: "dojo.1.1.1.dojo.xd.js.uncompressed.js"},

    "c43a38fce1aa745d59b1a6f7ab7def81f28701a4": {filename: "mootools.1.2.3.mootools.js"},

    "fe91b37266d1cdb4b4f51297f69326e271704f35": {filename: "mootools.1.3.1.mootools-yui-compressed.js"},

    "0c89448016629bb2ea758f4e98529c2e166a122d": {filename: "mootools.1.4.1.mootools.js"},

    "1b96be82b697e835b903c6c22799c8e4e55e285c": {filename: "jqueryui.1.8.6.jquery-ui.js"},

    "384cbfe95d92a30d7c86ac07ea5de56f79c15f6a": {filename: "jquery.1.2.1.jquery-1.2.1.js"},

    "3dc9f7c2642efff4482e68c9d9df874bf98f5bcb": {filename: "jquery.1.3.2.min.jquery-1.3.2.min.js"},

    "fa05290dadfb7d2659a55c50b77595e23f999a74": {filename: "jquery.1.0.1.jquery-1.0.1.js"},

    "960e36796c42dadf66fafb63bba6087c7d6e1d85": {filename: "jqueryui.1.8.0.jquery-ui.js"},

    "0cafb88edcaebad82c207cdf124de1889364c9f3": {filename: "jquery.1.2.1.min.jquery-1.2.1.min.js"},

    "a4fadcd6f68d7823a9fd9d1f6089025041a3212a": {filename: "yui.2.8.2.yuiloader-min.js"},

    "3e5c6d7c6e09965d36df8c1e3d9dca6462c41ec1": {filename: "jquery.1.6.3.jquery-1.6.3.js"},

    "5c83aac1a3409dc1ec3a228e4c765292eb4434d4": {filename: "ext-debug.3.0.0.ext-core-debug.js"},

    "f78ae3cdaf4a6a21dfb2565491f5d295462d8be3": {filename: "jqueryui.1.7.1.jquery-ui.min.js"},

    "83d1b489e30275a03f568f7e3fa6537d695e0197": {filename: "jquery.1.2.pack.jquery-1.2.pack.js"},

    "8b95d59f6b28b072ceb4228a6db107b934500a02": {filename: "dojo.1.4.0.dojo.xd.js"},

    "aa113da84ddbad46a8002ea22393a238eccf9ee4": {filename: "yui.2.9.0.yuiloader-min.js"},

    "7df0e9aae795337db012b3efd0b9ee9cc7719b56": {filename: "mootools.1.3.0.mootools.js"},

    "5846c870e0f1daca152db22277915adb6520ffa3": {filename: "underscore.1.0.0.underscore.js"},

    "55bba460dcbb70562536ddd5c8734b311f38c42d": {filename: "mootools.1.2.1.mootools.js"},

    "b87f7150da2b0811ed143443af4038e3e2d41eda": {filename: "jqueryui.1.7.0.jquery-ui.js"},

    "c34d6c84ec67d4a61af87b1634bc007f2d46ba91": {filename: "dojo.uncompressed.1.3.3.js"},

    "da851ac384c279992d1855d59257f8d98c603063": {filename: "jqueryui.1.7.0.jquery-ui.min.js"},

    "70b1fe9dd4ebec0b5d417647e549bca8f9200020": {filename: "dojo.1.3.1.dojo.xd.js"},

    "a90b5f6afb6c78b30c3539392d49e45fd9dfe3d9": {filename: "dojo.1.5.1.dojo.xd.js.uncompressed.js"},

    "0c3d725fac553c73368496769ff77c3045103704": {filename: "jqueryui.1.8.11.jquery-ui.js"},

    "cf36297804ca93709e18a7f9de289610bc97f9c5": {filename: "jquery.1.6.min.jquery-1.6.min.js"},

    "65fe3b80fae349ecb3acd6541ef651d1ff4961f6": {filename: "mootools.1.2.1.mootools-yui-compressed.js"},

    "058cbd179f032f667823545519aa2d10b0b69508": {filename: "underscore.1.1.2.underscore.js"},

    "b47730ffaec4272a8a01756af2ef13ecea1c4e92": {filename: "jquery.1.7.1.jquery-1.7.1.js"},

    "bff995d3a845903f281b0b51fea421059459a808": {filename: "jquery.1.4.1.min.jquery-1.4.1.min.js"},

    "772b2587aa2fa345fb760eff9ebe5acd97937243": {filename: "underscore.1.3.3.underscore.js"},

    "19214655c4152b79f204e222a481d1e18da84972": {filename: "dojo.1.3.1.dojo.xd.js.uncompressed.js"},

    "61c88c8898ae6bd653737a9dae52209a98998def": {filename: "jqueryui.1.8.2.jquery-ui.js"},

    "09fdd3d9aebc9086b27b45b3fb051ebded272b39": {filename: "jqueryui.1.8.1.jquery-ui.min.js"},

    "63f6a94752e5fde78627529763e67ecd4ef78f12": {filename: "underscore.1.2.4.underscore-min.js"},

    "e1db767afb82018ab6a695fe52334f2f5d81a0e3": {filename: "dojo.1.6.1.dojo.xd.js.uncompressed.js"},

    "5de53da57fc8b7ab6c77d597c22875d747352fef": {filename: "underscore.1.1.1.underscore-min.js"},

    "65cbff4e9d95d47a6f31d96ab4ea361c1f538a7b": {filename: "jquery.1.4.2.min.jquery-1.4.2.min.js"},

    "d2fc56e1b9f2014fb7710d186a355a57e3acd283": {filename: "dojo.1.2.3.dojo.xd.js"},

    "677c1ad6d84705c818d63a43298ee3a12959c1b3": {filename: "jquery.1.2.3.pack.jquery-1.2.3.pack.js"},

    "f4d4125bcd5151aad69dd849a11fc1ca589cc64b": {filename: "mootools.1.3.1.mootools.js"},

    "df60c759fdccee4cb04169c2e3ff2f77a3c83907": {filename: "dojo.1.0.3.js"},

    "6869cb783670d6a4923aaccfe4331015961ed8d6": {filename: "jquery.1.2.4.pack.jquery-1.2.4.pack.js"},

    "0d7896e2bb23f88e26e52b22a075350b354df447": {filename: "jquery.1.7.2.jquery-1.7.2.js"},

    "4dc6c77a03258ee7fbe5e877a1ed97311bc45652": {filename: "swfobject.2.2.swfobject_src.js"},

    "b5efe44645f5358e3d785091af3440f80afa85e3": {filename: "jquery.1.4.min.jquery-1.4.min.js"},

    "f2fa9179d764f6a688dc0c99b1b5283f1b680249": {filename: "underscore.1.1.1.underscore.js"},

    "6fca78dac2797c02d86a4bf6514eda398b7dbe62": {filename: "jquery.1.6.1.min.jquery-1.6.1.min.js"},

    "3f1b0e9e54af1af2db2c8a639530448723462151": {filename: "jquery.1.7.min.jquery-1.7.min.js"},

    "d9f710afddaba467707c0d6e7b187a8beae1e1f2": {filename: "yui.2.8.2.yuiloader.js"},

    "4c12e01d990bd2b1075812d9f28e3ffa50ca59df": {filename: "jquery.1.0.3.jquery-1.0.3.js"},

    "1185da1043863517c6aa0a4e0a3bc433dfb98313": {filename: "underscore.1.2.2.underscore-min.js"},

    "e5de581f09ac990adae2b4aede35264f1dc5cd72": {filename: "jqueryui.1.8.10.jquery-ui.js"},

    "0a15952061f6fb7a5493281f6ff8eb916a417e2f": {filename: "underscore.1.3.1.underscore-min.js"},

    "7dc1b4f3e358c58030c4676c990eff60a0fc838f": {filename: "ext-core.3.1.0.ext-core.js"},

    "1be9c3684054001f53fa7ff6d85ec3cb573a9cd2": {filename: "jquery.1.2.6.min.jquery-1.2.6.min.js"},

    "d3b30b0fead39e4c40fb0c91408e74439020a279": {filename: "jquery.1.0.2.jquery-1.0.2.js"},

    "493afa22594fdff6e6fc4f21f99c626533c35b06": {filename: "mootools.1.3.0.mootools-yui-compressed.js"},

    "db895a7ed5c8b42e27de2b3ef3199d038a259fdb": {filename: "jqueryui.1.8.8.jquery-ui.min.js"},

    "741b8eeb65774256a8a76ea1af91f976357fcd81": {filename: "dojo.1.5.1.dojo.xd.js"},

    "c753cf372377ef0b5a18204cd86df8d4792fa8f5": {filename: "dojo.1.4.1.dojo.xd.js"},

    "ddb4126bf4713cb4e0f2310401e58cb9e3f98997": {filename: "jquery.1.0.3.pack.jquery-1.0.3.pack.js"},

    "53dd39212504739ac18790a4461b9a67c50f2728": {filename: "jqueryui.1.8.13.jquery-ui.js"},

    "d8afec39893c1a99139212feb40888847f8a5253": {filename: "dojo.1.2.0.dojo.xd.js.uncompressed.js"},

    "fe56013bb04c602e676feb34bb49add4da2e0225": {filename: "scriptaculous.1.8.3.scriptaculous.js"},

    "c89d76123c2bff1cd9d21f21b3b155f36977152f": {filename: "yui.2.7.0.yuiloader-min.js"},

    "8b71e136c6275d0eeed2b55b9e718a54ce343015": {filename: "jqueryui.1.8.7.jquery-ui.js"},

    "6be187a67b639b65dc8427eb8e790e42bbe4d7dd": {filename: "jquery.1.3.1.jquery-1.3.1.js"},

    "67070ff953d6b0f886083edba723f6d66fa6cbca": {filename: "jqueryui.1.8.15.jquery-ui.min.js"},

    "3d9fc65389ce7de16f87909039aa2e728c693b3d": {filename: "mootools.1.2.5.mootools.js"},

    "3bb92e84642c03cf0fe49174d0e1c420d46d2e18": {filename: "jquery.1.2.4.jquery-1.2.4.js"},

    "97be02d1785b7bb4f41ae116a6a9bef74cb018d6": {filename: "jquery.1.4.3.min.jquery-1.4.3.min.js"},

    "868141351efa758d031779c776e608e3a049d823": {filename: "underscore.1.1.4.underscore.js"},

    "a90b5f6afb6c78b30c3539392d49e45fd9dfe3d9": {filename: "dojo.1.5.dojo.xd.js.uncompressed.js"},

    "741b8eeb65774256a8a76ea1af91f976357fcd81": {filename: "dojo.1.5.dojo.xd.js"},

    "66851ab2133e27b97c4f3048416b947aa7ed82c5": {filename: "swfobject.2.1.swfobject.js"},

    "14184a9b570b05f005a50f5657d317b45d0b6fd1": {filename: "underscore.1.1.6.underscore-min.js"},

    "133de2283d03193cb06f62f92c494afe098460a5": {filename: "underscore.1.2.0.underscore.js"},

    "99b7a6ecd023a00fdb104f2da21859e6bb9d49fa": {filename: "jquery.1.5.min.jquery-1.5.min.js"},

    "5ed6bdacae842fc530dbc83aabb9a466c7f2b5a1": {filename: "jqueryui.1.6.0.jquery-ui.min.js"},

    "08341cd159e29f561ca0ec16c99bf4b85e43d30f": {filename: "jquery.1.0.1.pack.jquery-1.0.1.pack.js"},

    "265a86a9d9df5dfdbad77e06c85605bec4beb32a": {filename: "jquery.1.4.2.jquery-1.4.2.js"},

    "71adcc2cae87e412e521e4a7276efeaee2347927": {filename: "jquery.1.2.2.jquery-1.2.2.js"},

    "b6d2c0b655b327407966b52303449dedce084ded": {filename: "dojo.1.4.3.dojo.xd.js.uncompressed.js"},

    "6463e558dd79d51a2e8464806824c7bbc18c77fd": {filename: "jquery.1.2.3.min.jquery-1.2.3.min.js"},

    "f0b95e99225f314fbe37ccf6b74ce2f916c517de": {filename: "jquery.1.3.2.jquery-1.3.2.js"},

    "8c135fc57355fe5d5a18f3dbe5736bc772bb20a7": {filename: "dojo.1.3.2.dojo.xd.js"},

    "4cc838a3be933fda21bbbfc8f52b01e14a1e70a5": {filename: "dojo.1.4.1.dojo.xd.js.uncompressed.js"},

    "1f102103bea71c5e173a916137c563dc62a97cdb": {filename: "jqueryui.1.8.1.jquery-ui.js"},

    "2e140b943f459e383f569227b3e5569f0dbc6f34": {filename: "jqueryui.1.8.14.jquery-ui.js"},

    "33f5808531e82f2f6e8859da3a765c4d8a0073d2": {filename: "jqueryui.1.8.11.jquery-ui.min.js"},

    "37c2a4215a6a5c94824b34161f37f10f0c1a3c7d": {filename: "mootools.1.4.0.mootools.js"},

    "2fee700150a7de876acc21403f77e57dae2f5618": {filename: "underscore.1.1.5.underscore.js"},

    "8fdfbe7ccaf0bdcde4c0b34738c0cd73b4587a45": {filename: "jqueryui.1.8.6.jquery-ui.min.js"},

    "9564fa7a6a001e4e56b0244ccda03eef3940813e": {filename: "underscore.1.1.3.underscore.js"},

    "74974f9dc0810ea359367589cb273dd5174d80df": {filename: "scriptaculous.1.8.1.scriptaculous.js"},

    "6b911b0dc178423b946b0299851d9661004c21ef": {filename: "jquery.1.4.1.jquery-1.4.1.js"},

    "8d84b347dfe4f5b75f7b5f670326ca5c8041b7a9": {filename: "underscore.1.2.3.underscore.js"},

    "034970f98cb529c779c8f961b2b7c09ecb499240": {filename: "jquery.1.6.jquery-1.6.js"},

    "b509dd44ba3f9c72cf8bba6fcb5f06fae15cabf6": {filename: "jquery.1.5.2.jquery-1.5.2.js"},

    "88c03b5c437ac3551661ecfbe6e1de155c3099c4": {filename: "jquery.1.0.pack.jquery-1.0.pack.js"},

    "c82ea9768b18696832408b6cc729e2e121def691": {filename: "jquery.1.2.3.jquery-1.2.3.js"},

    "7f7859e006f0644a43a7294b50b39e7e9159b3a2": {filename: "jqueryui.1.7.2.jquery-ui.js"},

    "c21c366b65bfea1823cdd3775b7f949fe739b670": {filename: "yui.3.3.0.yui.min.js"},

    "788bb58005b75a004cd7abbd26f942eea0391f47": {filename: "jquery.1.1.2.jquery-1.1.2.js"},

    "6952564ff6404bd93cb523f1634b451ac1cc8fec": {filename: "jqueryui.1.8.14.jquery-ui.min.js"},

    "6d07e7229066e4d995e951027cac9e2ce9a9c30c": {filename: "yui.2.8.0r4.yuiloader-min.js"},

    "348b6c9e71b2628dfbba85d75a76889564c32ad7": {filename: "yui.2.7.0.yuiloader.js"},

    "9025fe9334566eb919ddca85a8f949b01c7d837d": {filename: "jquery.1.2.5.pack.jquery-1.2.5.pack.js"},

    "f978dcb9ea6ecfbc7f8a2f9948bacd679c0cd1b4": {filename: "jqueryui.1.7.2.jquery-ui.min.js"},

    "bcdd63e18a8a7cf728253f738556ad3b88d74649": {filename: "underscore.1.1.2.underscore-min.js"},

    "55c7f265deba4afc1335071fafbbf7fda8f02bbe": {filename: "jquery.1.2.6.jquery-1.2.6.js"},

    "2804fac51308f459c3eb9c3d20e7ee009a8ba31c": {filename: "jqueryui.1.8.5.jquery-ui.js"},

    "9718416c0fc55875d8a1599c230498c647a631ec": {filename: "jqueryui.1.5.2.jquery-ui.js"},

    "8f1cfeefecc782f53f411de1bf64c77b48b8ba56": {filename: "yui.2.8.1.yuiloader-min.js"},

    "66e2758fc5064cf25969c6ffd42ba9677d45506e": {filename: "yui.3.3.0.yui.js"},

    "ca0aea084a63d0a56e1bbf17fde5061f631b391f": {filename: "jquery.1.2.1.pack.jquery-1.2.1.pack.js"},

    "4a5dc1389aad050a44ee5e81408238a317ab3413": {filename: "jquery.1.5.1.min.jquery-1.5.1.min.js"},

    "c7f5b42b2306a79f67988ee073ac98c2a1d5782f": {filename: "dojo.1.2.3.dojo.xd.js.uncompressed.js"},

    "9fa29ea8f3ec6714b3b6236eb2ce6e1ce905c560": {filename: "yui.2.6.0.yuiloader.js"},

    "8e8b0dccbacc70dc6406023be9e35dfa4f3a944e": {filename: "jqueryui.1.8.16.jquery-ui.min.js"},

    "e5335c2a82f26e49b1324edc21e452de040d5cdc": {filename: "mootools.1.2.4.mootools.js"},

    "71cce71820cc47b3bd1098618d248325fcf24ddb": {filename: "jquery.1.6.4.min.jquery-1.6.4.min.js"},

    "669d164e3bff6156b21084cf035979d62433df75": {filename: "mootools.1.2.2.mootools-yui-compressed.js"},

    "a7e07121debf460f86aa77073676c1e936478c22": {filename: "jquery.1.1.3.jquery-1.1.3.js"},

    "ee68308411c690cd51cc8a43fe6ae60d3d1678af": {filename: "underscore.1.0.4.underscore-min.js"},

    "02d2e4a524b0da52c3cb236619ad065fec44d69a": {filename: "jqueryui.1.8.5.jquery-ui.min.js"},

    "97f93241957893ebd7febc5b5bac9a7bd1d94a0f": {filename: "underscore.1.0.3.underscore-min.js"},

    "ad0775c89a87111019840dc7bbf902d832e4ccdf": {filename: "underscore.1.0.0.underscore-min.js"},

    "4a2c9fd552e1ca9ad66feaaad365990b1e664a8f": {filename: "jquery.1.0.4.pack.jquery-1.0.4.pack.js"},

    "86f0df8662b511142dfc4e0ce9c81d805c8d7a7e": {filename: "mootools.1.4.0.mootools-yui-compressed.js"},

    "cdacc2b0045fa1b920b64664b88b155d0c0df169": {filename: "underscore.1.0.2.underscore.js"},

    "2de2ecea5ba12e7235ffb44d6892cc77fe6f4abe": {filename: "underscore.1.1.4.underscore-min.js"},

    "427300f82762288c5af967dbf642fbec58c201ea": {filename: "jquery.1.4.4.jquery-1.4.4.js"},

    "cfbc3fa20d685d100308e123c3310dc9600ef0fd": {filename: "underscore.1.2.3.underscore-min.js"},

    "4c977634c87efbd2b7113993d36dad603b8dcf2f": {filename: "underscore.1.2.1.underscore.js"},

    "22c1eefcce5be20a3e0966f5bcdf88ed81e9f5e7": {filename: "jquery.1.6.1.jquery-1.6.1.js"},

    "9bdf0dfad487422fd36693d4119b59175f0112ee": {filename: "yui.2.8.1.yuiloader.js"},

    "bd9624f882f7d3d29292ddc7f484987b3e991cb5": {filename: "underscore.1.3.0.underscore.js"},

    "842cb8f83614f6de98f70fa7de2f866eecae7ab4": {filename: "jqueryui.1.7.1.jquery-ui.js"},

    "9262d972b175f4550aa10926e07dd3ecc42f5c46": {filename: "dojo.1.1.2.js"},

    "d0d4200eedc83fe692dd65aeab5a548bfe840d06": {filename: "jquery.1.1.3.1.pack.jquery-1.1.3.1.pack.js"},

    "d19d40a20252730e9fd9af1c7867c0f5417ebe32": {filename: "ext-core.3.0.0.ext-core.js"},

    "b8dcaa1c866905c0bdb0b70c8e564ff1c3fe27ad": {filename: "jquery.1.5.2.min.jquery-1.5.2.min.js"},

    "49a747d3284b1d04f3eb823a4188f7725004f823": {filename: "underscore.1.1.0.underscore-min.js"},

    "d97ecac3f1b3ccf1f0f68434e8406f87f5acc907": {filename: "jquery.1.2.2.min.jquery-1.2.2.min.js"},

    "5847ed101f55d51c53538a7078971e7de8fb6762": {filename: "swfobject.2.2.swfobject.js"},

    "31555f340a206de7622fb760718ef4a1b296ed44": {filename: "jquery.1.1.jquery-1.1.js"},

    "0d2bc9db63acd9cc238a4925e79f9a3079490970": {filename: "jquery.1.2.4.min.jquery-1.2.4.min.js"},

    "b1a271458ae47d0b47c9e0996956091a93dec16f": {filename: "mootools.1.4.1.mootools-yui-compressed.js"},

    "7361e8afa72bd0098e2520584786474c9c4a5064": {filename: "underscore.1.0.2.underscore-min.js"},

    "8980e43d4750c63eb57cfff5f0723f118d243c67": {filename: "dojo.1.3.0.dojo.xd.js"},

    "08f37f8169e620c6ecd87635c18fc2b22e3e850e": {filename: "scriptaculous.1.9.0.scriptaculous.js"},

    "15c3f73c75bb3ab87040fe55240f9dd5ea69b6bf": {filename: "ext-debug.3.1.0.ext-core-debug.js"},

    "28e41c3ce9232633468013342c49fd62a4f5f6bd": {filename: "underscore.1.2.2.underscore.js"},

    "0e9545b59077541c44f521769243a8b717d83aae": {filename: "mootools.1.2.5.mootools-yui-compressed.js"},

    "d9b48fef067caa58d4e1dec54801c22fe0ea7449": {filename: "jqueryui.1.8.16.jquery-ui.js"},

    "015cf89260f3e8f0b86f5a17558125c933692989": {filename: "prototype.1.6.0.2.prototype.js"},

    "f02e1f7f1bb966d5fcf16b03daa79ee077a993f8": {filename: "jquery.1.4.jquery-1.4.js"},

    "ea6cc893792569fdbb344181034eb668261f2b24": {filename: "jquery.1.5.1.jquery-1.5.1.js"},

    "bbf7ce8f5ce8d8f9d207f8973328527ac0093b17": {filename: "jqueryui.1.8.2.jquery-ui.min.js"},

    "c1dff1c5dbb68af6e22bd401afd28aab970a8aff": {filename: "underscore.1.0.3.underscore.js"},

    "abcd2ba13348f178b17141b445bc99f1917d47af": {filename: "jquery.1.7.2.min.jquery-1.7.2.min.js"},

    "a192b2ef3371febba192179ff86e3da3f633160d": {filename: "jqueryui.1.8.9.jquery-ui.min.js"},

    "0cf62d1dd0c483b423f5dfd655f62d03ed2668f6": {filename: "jquery.1.6.3.min.jquery-1.6.3.min.js"},

    "c147a1a86a2c33e60f160b8861501f43f4638c8d": {filename: "prototype.1.6.1.0.prototype.js"},

    "03a65e56fc95caea1b85a591c984e9b6c080726d": {filename: "mootools.1.1.1.mootools-yui-compressed.js"},

    "8963108fa84c2033a1052d47079d7f75a7e5b60e": {filename: "jquery.1.2.5.jquery-1.2.5.js"},

    "2710cce192fcc4dc676d9572cd852f104ea59387": {filename: "jquery.1.2.2.pack.jquery-1.2.2.pack.js"},

    "e956e4de8f223992e2d1362d78c5b5bb33e27497": {filename: "mootools.1.2.4.mootools-yui-compressed.js"},

    "81eff28ad7eb0f8037d887200d158f25140faca7": {filename: "underscore.1.1.0.underscore.js"},

    "b9c72aa78de3c124248f30234c64bf6f3b1a7cb5": {filename: "jquery.1.1.3.pack.jquery-1.1.3.pack.js"},

    "5717e22c3b2c7caf870fc0772a64344962b59ee6": {filename: "underscore.1.1.6.underscore.js"},

    "6c445baf655cccb16ee2788714827ab186ed94bf": {filename: "scriptaculous.1.8.2.scriptaculous.js"},

    "2bab42610adee25cdc0d3a4ba96b94f1e9ccd115": {filename: "dojo.1.2.0.dojo.xd.js"},

    "083bbcd739b7b1336f13c72603e1704b164c02bd": {filename: "underscore.1.2.1.underscore-min.js"},

    "ffd1b70071749bf5f4802db4b1b6a60937d58d24": {filename: "dojo.1.2.4.js"},

    "a3e5c42f93722ad28cda811f8635bddf213819ed": {filename: "dojo.1.6.1.dojo.xd.js"},

    "24dd74d65d2e02aae973af97ebbb31b9820a5bbb": {filename: "jquery.1.1.1.pack.jquery-1.1.1.pack.js"},

    "34454bfed864addf8ec4aacdd9adf872f8360ed3": {filename: "underscore.1.3.1.underscore.js"},

    "e67cf6a985999c7ef5595772e4ffefeacd0c6ac3": {filename: "underscore.1.0.1.underscore.js"},

    "20860bad9c83c3890be57052f009b9d97848c9ec": {filename: "jquery.1.2.5.min.jquery-1.2.5.min.js"},

    "921e7702ac9e4c4a4bca052b7bc83b0304440ee3": {filename: "jquery.1.6.4.jquery-1.6.4.js"},

    "3c1ddf62af20a1f5c5de7a3af180b32528dc47db": {filename: "mootools.1.2.2.mootools.js"},

    "07c089df7b7a5da16f434870087d6b0e1c45d3b5": {filename: "jquery.1.1.2.pack.jquery-1.1.2.pack.js"},

    "9d6f8bdcadd59eba977e9e31066bf393c9fdf8a4": {filename: "jquery.1.0.4.jquery-1.0.4.js"},

    "7b3bca1ff4ab9e8225776a8406de5f40f706791c": {filename: "jqueryui.1.6.0.jquery-ui.js"},

    "35a54ef9e4073d390afdb39874c82198cafc78f6": {filename: "dojo.uncompressed.1.0.3.js"},

    "c0c37b7d3119f29d3759fdaf7eb8bc4670ea9e7f": {filename: "mootools.1.1.1.mootools.js"},

    "84b1514a01def3bc0b52f6fa03d0d9fa349bef72": {filename: "jquery.1.0.2.pack.jquery-1.0.2.pack.js"},

    "9b719fdcb41dc4953d5ed938776c9db87a65d80c": {filename: "jqueryui.1.5.3.jquery-ui.js"},

    "c10dbe0c2b23444d0794f3376398702d84f41583": {filename: "jquery.1.2.6.pack.jquery-1.2.6.pack.js"},

    "81afb4cd3755671fea5e74d7118d7d460c475308": {filename: "underscore.1.1.7.underscore-min.js"},

    "b48e01c35c1e6ad622386b9a3161bd1bf02723c8": {filename: "jqueryui.1.8.13.jquery-ui.min.js"},

    "16306f8187df578589821e6eb6b807ac4d467d1f": {filename: "jquery.1.1.pack.jquery-1.1.pack.js"},

    "d26763498c38c5f245e81eb26d46604c39040d6d": {filename: "jquery.1.7.jquery-1.7.js"},

    "f444ee6b041735ee6109dd2fe3c3a7755fa949f7": {filename: "dojo.1.3.0.dojo.xd.js.uncompressed.js"},

    "990dbb08231ef9c9c59653051f5ac7c1e2185d46": {filename: "jqueryui.1.8.15.jquery-ui.js"},

    "f3abd53f3725675e3e049c414749e16df11951ba": {filename: "jquery.1.3.jquery-1.3.js"},

    "90fab357529f510e5134ad0dcdad3f654894d4fc": {filename: "jqueryui.1.7.3.jquery-ui.js"},

    "7d6e352b0d26655ba851863561b5d912cc24caa7": {filename: "underscore.1.2.0.underscore-min.js"},

    "5f970c3c8ca26a94c14a1ae1e7321621cf4eae0c": {filename: "mootools.1.1.2.mootools-yui-compressed.js"},

    "df435b881e8364ddfbd44d5f786b10c75f964175": {filename: "dojo.1.3.2.dojo.xd.js.uncompressed.js"},

    "84650b1c627bfd5b2af722bdbebc9f3af51b44d3": {filename: "yui.2.8.0r4.yuiloader.js"},

    "eeee9d4604e71f2e01b818fc1439f7b5baf1be7a": {filename: "jquery.1.6.2.jquery-1.6.2.js"},

    "8ab3016267333541f4c2b10aa49efd9950e4c398": {filename: "dojo.uncompressed.1.1.2.js"},

    "0c80055d513ce3103bb70ca956be005f63e32922": {filename: "jquery.1.1.4.pack.jquery-1.1.4.pack.js"},

    "7622c9ac2335be6dcd3ab8b47132e94089cef931": {filename: "jquery.1.6.2.min.jquery-1.6.2.min.js"},

    "97e561dfeb842c21b35e6f9963914316221cca1d": {filename: "dojo.1.3.3.js"},

    "5af7abb29b3b091080db17e53ef6ddcfa555dbe6": {filename: "jquery.1.1.4.jquery-1.1.4.js"},

    "dd7783b4c8d4ecaad4091d1d32df2f97d7b10ddc": {filename: "mootools.1.1.2.mootools.js"},

    "fc21f8084ad4040ddbf620ba79acd3998fb3dc7b": {filename: "mootools.1.3.2.mootools-yui-compressed.js"},

    "24fdaa88685c8b2dadcc94559ceef318fdcd115b": {filename: "jquery.1.1.1.jquery-1.1.1.js"},

    "710c3a99f0bd456c2fd6dcbcbd1e500e0646ec19": {filename: "underscore.1.0.1.underscore-min.js"},

    "e55462193a857ffe36e42bfcbecfebf1ca33d0b8": {filename: "mootools.1.3.2.mootools.js"},

    "5cd73db8238d48c08c88f12fe9e5b99b6fa644f7": {filename: "jqueryui.1.8.12.jquery-ui.js"},

    "9eb9ac595e9b5544e2dc79fff7cd2d0b4b5ef71f": {filename: "jquery.1.7.1.min.jquery-1.7.1.min.js"},

    "34d32c47711aa10bdeb196c55d489962296a64c4": {filename: "jqueryui.1.8.12.jquery-ui.min.js"},

    "86752ba2e4f3855a8a5e45d5f07567ea70a9cc98": {filename: "underscore.1.3.0.underscore-min.js"},

    "8dda5f159c9bedee9f4a6b7a7a6028a554977994": {filename: "dojo.1.4.3.dojo.xd.js"},

    "2ef4341a4ca0b9a0fc1aea422d85b5d9771fde87": {filename: "dojo.1.4.0.dojo.xd.js.uncompressed.js"},

    "fed603a4db640b82de54b246de4be7a1cffa8780": {filename: "jquery.1.3.1.min.jquery-1.3.1.min.js"},

    "ede1d022640f26eaa6109da9e924670f6ed14cce": {filename: "underscore.1.3.2.underscore-min.js"},

    "3d542e33a9f3eb3cb45e06fe93d08dd4b7490496": {filename: "prototype.1.7.0.0.prototype.js"},

    "cc66556593e147584f19b41b697405f828f7562e": {filename: "jquery.1.5.jquery-1.5.js"},

    "278d68b8e9edad4895836e272fbc8f78ec4f2f3e": {filename: "prototype.1.6.0.3.prototype.js"},

    "f3e20ad41082a93dbd09202590717da71aebd316": {filename: "mootools.1.2.3.mootools-yui-compressed.js"},

    "3aca6488dfb65cf0e600a7a70376ca1354b7377c": {filename: "jquery.1.2.jquery-1.2.js"},

    "b5f2733aac4e257929a5f1ff93410ee0bda311b6": {filename: "jqueryui.1.7.3.jquery-ui.min.js"},

    "e80905e4a45e31075b89189f5ba4913fc0451fdf": {filename: "yui.2.9.0.yuiloader.js"},

    "42936431058c6c4663e64e2c07931b9159083c31": {filename: "jqueryui.1.8.4.jquery-ui.min.js"},

    "28780fdb8fc54bf7d80b1f223abca4f77cd89e85": {filename: "swfobject.2.1.swfobject_src.js"},

    "5b59bc1a7087c3a83abd5b9ff559a88428ceab0a": {filename: "jqueryui.1.5.2.jquery-ui.min.js"},

    "5f47da5d3c8902e763ef6ae02e9307a63a95ae5a": {filename: "yui.2.6.0.yuiloader-min.js"},

    "973e1554af7d9240e059e38165f2e7b5fc7aa0a5": {filename: "jqueryui.1.8.10.jquery-ui.min.js"},

    "e0c497fc264d7706da23235266ed52acf2c7b89a": {filename: "jquery.1.2.min.jquery-1.2.min.js"},

    "9e389ede8ed7f782c5ecf2f87c3afa3b1e309bff": {filename: "underscore.1.1.3.underscore-min.js"},

    "06adc576409427237ce3c269bb9a568d3cd53c9b": {filename: "jqueryui.1.8.7.jquery-ui.min.js"},

    "c71ddb1b3843c24e909a31595b7e873d7e6da45d": {filename: "jqueryui.1.8.9.jquery-ui.js"},

    "6bb906d86dd239add79d0779a9fcdf9740aa7e3b": {filename: "dojo.1.1.1.dojo.xd.js"},

    "e002b335c75b5edefcd251962f61f53a2ab8e0f2": {filename: "jqueryui.1.8.0.jquery-ui.min.js"},

    "f665459959c5167c0905974a62ffe923f2c19813": {filename: "underscore.1.1.5.underscore-min.js"},

    "fe810f47883364fbc4dc2c61e03a3aca0f74fed7": {filename: "jqueryui.1.5.3.jquery-ui.min.js"},

    "a3e5c42f93722ad28cda811f8635bddf213819ed": {filename: "dojo.1.6.dojo.xd.js"},

    "7b9e8594368d30387059e5fdef9d662095dbbf7a": {filename: "jquery.1.3.min.jquery-1.3.min.js"},

    "6de97a1416cfe0510f290946f44b7c44170b200b": {filename: "dojo.uncompressed.1.2.4.js"},

    "b842a8ca5e996e001e648fc8c73316cd55e496ed": {filename: "underscore.1.0.4.underscore.js"},

    "f188985665f8b3d94f5d73609b211405db0b0d09": {filename: "jqueryui.1.8.4.jquery-ui.js"},

    "baa693e82387a328abccf9694c6d2db571ac8aca": {filename: "underscore.1.3.3.underscore-min.js"},

    "e1db767afb82018ab6a695fe52334f2f5d81a0e3": {filename: "dojo.1.6.dojo.xd.js.uncompressed.js"},

    "7e0294019938a772f4ddd7799501496074e0f0fb": {filename: "underscore.1.1.7.underscore.js"},

    "07916c0b7274275f916fe288d01b254545b17d9a": {filename: "underscore.1.2.4.underscore.js"}


};

/**
 * 
 */
var init = function () {

    // relationChecker, which roughly checks if variables are window
    //  variables or not, is useless in this case.  Use the same
    //  object for all entries.
    var rc = relationChecker();
    var library, hash;

    for (hash in freeLibraries) {

	library = freeLibraries[hash];

	// assign empty relationChecker object.
	library.relationChecker = rc;

	// make them free and nontrivial.
	library.result = checkTypes.FREE_NONTRIVIAL_GLOBAL;

	scriptsCached.addObjectEntry(hash, library);


    }

};

init();