#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}-${VER}-//"`
export FULLPKG=${PKG}-${VER}-${REL}
export src_orig_pkg_name=${PKG}-${VER}.tar.bz2
export src_orig_doc_pkg_name=${PKG}-${VER}-doc.tar.bz2
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_orig_doc_pkg=${topdir}/${src_orig_doc_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
#host=i686-pc-cygwin
#host=x86_64-pc-cygwin
#target=i686-pc-cygwin
#target=x86_64-pc-cygwin
prefix=/usr
pnoslash=`echo $prefix | sed -e 's#^/##'`
sysconfdir=/etc
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
datadir=${prefix}/share
infodir=${datadir}/info
mandir=${datadir}/man
MY_CFLAGS=
MY_LDFLAGS=

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  tar xvjf ${src_orig_pkg} && \
  if [ -f ${src_orig_doc_pkg} ] ; then \
    tar xvjf ${src_orig_doc_pkg} ; \
  fi && \
  cd ${srcdir} && \
  if [ -f ${src_patch} ] ; then \
    patch -p1 < ${src_patch} ; \
  fi && \
  cd ${topdir} && \
  mkdirs ) 
}
devprep() {
  (cd ${topdir} && \
  tar xvjf ${src_orig_pkg} && \
  if [ -f ${src_orig_doc_pkg} ] ; then \
    tar xvjf ${src_orig_doc_pkg} ; \
  fi && \
  mv ${FULLPKG} ${PKG}-${VER} && \
  cd ${srcdir} && \
  if [ -f ${src_patch} ] ; then \
    patch -p1 < ${src_patch} ; \
  fi && \
  mkdirs ) 
}
doautoconf() {
  (cd ${srcdir} && \
   rm -rf autom4te.cache && \
   echo "Running autoconf" && autoconf && \
   echo "Running autoheader" && autoheader && \
   echo > stamp-h.in)
}
conf() {
  (cd ${objdir} && \
  ${srcdir}/configure \
  --srcdir=${srcdir} \
  --prefix=${prefix} \
  --sysconfdir=${sysconfdir} \
  --infodir=${infodir} \
  --mandir=${mandir} \
  --localstatedir=/var \
  --enable-symlinks \
  --enable-function-subdirs \
  --enable-pcre \
  --enable-multibyte \
  --with-curses-terminfo \
  --with-install-prefix=${instdir} \
  ${ZSHCONFDEBUG} )
}
build() {
# (cd ${objdir} && \
# CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" make ) 
  (cd ${objdir} && \
  make all ) 
}
check() {
  (cd ${objdir} && \
  make check | tee ${checkfile} 2>&1 )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  for dirn in ${prefix}/bin ${prefix}/share ; do \
    if [ ! -d ${instdir}${dirn} ]; then \
      mkdir -p ${instdir}${dirn} ; \
    fi ; \
  done && \
  cd ${objdir} && \
  make install install.info install.html DESTDIR=${instdir} && \
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ -f ${instdir}${prefix}/share/info/dir ] ; then \
    rm ${instdir}${prefix}/share/info/dir ; \
  fi && \
  for dirn in ${prefix}/share/doc/Cygwin ${prefix}/share/doc/${PKG}-${VER} \
              ${sysconfdir}/postinstall ${sysconfdir}/preremove \
              ${sysconfdir}/profile.d ; do \
    if [ ! -d ${instdir}${dirn} ]; then \
      mkdir -p ${instdir}${dirn} ; \
    fi ; \
  done && \
  templist=""; \
  for f in ${srcdir}/README ${srcdir}/INSTALL ${srcdir}/LICENCE \
           ${srcdir}/META-FAQ ${srcdir}/CYGWIN-PATCHES/FAQ ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -c -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER} ; \
  fi && \
  echo "Copying example Functions and StartupFiles" && \
  cp -ar ${srcdir}/Functions ${instdir}${prefix}/share/doc/${PKG}-${VER} && \
  mkdir -p ${instdir}${prefix}/share/doc/${PKG}-${VER}/StartupFiles/etc && \
  cp -ar ${srcdir}/StartupFiles/* ${instdir}${prefix}/share/doc/${PKG}-${VER}/StartupFiles/etc && \
  templist=""; \
  for f in ${srcdir}/CYGWIN-PATCHES/StartupFiles/etc/* ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -c -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER}/StartupFiles/etc ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/CYGWIN-PATCHES/bin/* ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -c -m 755 $templist ${instdir}${prefix}/bin ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/CYGWIN-PATCHES/profile.d/* ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -c -m 755 $templist ${instdir}${sysconfdir}/profile.d ; \
  fi && \
  echo "Generating postinstall files" && \
  for f in ${srcdir}/CYGWIN-PATCHES/postinstall/* ; do \
    templist=`basename ${f}`; \
    sed "s/%VERSION%/${VER}/" < ${f} > /tmp/.inst.postinstall && \
    /usr/bin/install -c -m 755 /tmp/.inst.postinstall ${instdir}${sysconfdir}/postinstall/${templist} && \
    rm -f /tmp/.inst.postinstall ; \
  done && \
  echo "Generating preremove files" && \
  for f in ${srcdir}/CYGWIN-PATCHES/preremove/* ; do \
    templist=`basename ${f}`; \
    sed "s/%VERSION%/${VER}/" < ${f} > /tmp/.inst.preremove && \
    /usr/bin/install -c -m 755 /tmp/.inst.preremove ${instdir}${sysconfdir}/preremove/${templist} && \
    rm -f /tmp/.inst.preremove ; \
  done && \
  echo "Generating ${PKG}-${VER}.README" && \
  /usr/bin/install -c -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README && \
  (cd ${instdir} && \
  (find . -type f | sort | sed 's/^\./  /' > /tmp/.inst.lis) && \
  sed -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README.sed < ${srcdir}/CYGWIN-PATCHES/${PKG}.README > /tmp/.inst.README && \
  /usr/bin/install -c -m 644 /tmp/.inst.README ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README && \
  rm -f /tmp/.inst.lis /tmp/.inst.README ) )
}
mkpatch() {
  (cd ${srcdir} && \
  tar xvjf ${src_orig_pkg} && \
  if [ -f ${src_orig_doc_pkg} ] ; then \
    tar xvjf ${src_orig_doc_pkg} ; \
  fi && \
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' -x 'autom4te.cache' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}
devmkpatch() {
  (cd ${srcdir} && \
  tar xvjf ${src_orig_pkg} && \
  if [ -f ${src_orig_doc_pkg} ] ; then \
    tar xvjf ${src_orig_doc_pkg} ; \
  fi && \
  mv ${FULLPKG} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}
strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip > /dev/null 2>&1 
  find . -name "*.dll" | xargs strip > /dev/null 2>&1 )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} * )
}
spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  if [ -f ${src_orig_doc_pkg} ] ; then \
    cp ${src_orig_doc_pkg} ${srcinstdir}/${src_orig_doc_pkg_name} ; \
  fi && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
devspkg() {
  (devmkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  if [ -f ${src_orig_doc_pkg} ] ; then \
    cp ${src_orig_doc_pkg} ${srcinstdir}/${src_orig_doc_pkg_name} ; \
  fi && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  rm -rf ${srcdir}
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  devprep)	devprep ; STATUS=$? ;;
  mkdirs)	mkdirs ; STATUS=$? ;;
  autoconf)	doautoconf ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkpatch ; STATUS=$? ;;
  devmkpatch) devmkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  devspkg)	devspkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     pkg && spkg && finish ; STATUS=$? ;;
  *) echo "Error: bad arguments" ; STATUS=1 ;;
esac
exit ${STATUS}
