/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A collection of widgets (qt designer plugin).
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgwidgetcollectiondesignerplugin.h"

#include <QtPlugin>

#include "skgcomboboxdesignerplugin.h"
#include "skgcolorbuttondesignerplugin.h"
#include "skglineeditdesignerplugin.h"
#include "skgtableviewdesignerplugin.h"
#include "skgtreeviewdesignerplugin.h"
#include "skgdateeditdesignerplugin.h"
#include "skgcalculatoreditdesignerplugin.h"
#include "skggraphicsviewdesignerplugin.h"
#include "skgtablewithgraphdesignerplugin.h"
#include "skgtabwidgetdesignerplugin.h"
#include "skgtablewidgetdesignerplugin.h"
#include "skgwebviewdesignerplugin.h"
#include "skgzoomselectordesignerplugin.h"
#include "skgshowdesignerplugin.h"
#include "skgfilteredtableviewdesignerplugin.h"
#include "skgwidgetselectordesignerplugin.h"
#include "skgprogressbardesignerplugin.h"
#include "skgperiodeditdesignerplugin.h"

SKGWidgetCollectionDesignerPlugin::SKGWidgetCollectionDesignerPlugin(QObject* iParent)
    : QObject(iParent)
{
    m_widgets.append(new SKGCalculatorEditDesignerPlugin(this));
    m_widgets.append(new SKGComboBoxDesignerPlugin(this));
    m_widgets.append(new SKGColorButtonDesignerPlugin(this));
    m_widgets.append(new SKGLineEditDesignerPlugin(this));
    m_widgets.append(new SKGDateEditDesignerPlugin(this));
    m_widgets.append(new SKGFilteredTableViewDesignerPlugin(this));
    m_widgets.append(new SKGGraphicsViewDesignerPlugin(this));
    m_widgets.append(new SKGShowDesignerPlugin(this));
    m_widgets.append(new SKGTableViewDesignerPlugin(this));
    m_widgets.append(new SKGTreeViewDesignerPlugin(this));
    m_widgets.append(new SKGTableWithGraphDesignerPlugin(this));
    m_widgets.append(new SKGTabWidgetDesignerPlugin(this));
    m_widgets.append(new SKGTableWidgetDesignerPlugin(this));
    m_widgets.append(new SKGWebViewDesignerPlugin(this));
    m_widgets.append(new SKGWidgetSelectorDesignerPlugin(this));
    m_widgets.append(new SKGZoomSelectorDesignerPlugin(this));
    m_widgets.append(new SKGProgressBarDesignerPlugin(this));
    m_widgets.append(new SKGPeriodEditDesignerPlugin(this));
}

QList<QDesignerCustomWidgetInterface*> SKGWidgetCollectionDesignerPlugin::customWidgets() const
{
    return m_widgets;
}

Q_EXPORT_PLUGIN2(skgbaseui, SKGWidgetCollectionDesignerPlugin)  // NOLINT(readability/fn_size)
