# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64-unknown-unknown -mcpu=tt-ascalon-d8 --iterations=1 < %s | FileCheck %s

mul t0, a0, t0
sub s2, a2, a3
div t1, t2, t3
add t1, a4, x3
div a1, a2, a3
add t1, a0, t0
mul s0, a5, s0
add t2, t2, t2
sub s1, s0, s1
fcvt.s.w f1, t3
add s2, s2, s2
fcvt.w.s t5, f3

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      12
# CHECK-NEXT: Total Cycles:      22
# CHECK-NEXT: Total uOps:        12

# CHECK:      Dispatch Width:    8
# CHECK-NEXT: uOps Per Cycle:    0.55
# CHECK-NEXT: IPC:               0.55
# CHECK-NEXT: Block RThroughput: 17.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     1.00                        mul	t0, a0, t0
# CHECK-NEXT:  1      1     0.17                        sub	s2, a2, a3
# CHECK-NEXT:  1      7     7.00                        div	t1, t2, t3
# CHECK-NEXT:  1      1     0.17                        add	t1, a4, gp
# CHECK-NEXT:  1      7     7.00                        div	a1, a2, a3
# CHECK-NEXT:  1      1     0.17                        add	t1, a0, t0
# CHECK-NEXT:  1      3     1.00                        mul	s0, s0, a5
# CHECK-NEXT:  1      1     0.17                        add	t2, t2, t2
# CHECK-NEXT:  1      1     0.17                        sub	s1, s0, s1
# CHECK-NEXT:  1      1     1.00                        fcvt.s.w	ft1, t3
# CHECK-NEXT:  1      1     0.17                        add	s2, s2, s2
# CHECK-NEXT:  1      1     1.00                        fcvt.w.s	t5, ft3

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - AscalonFP
# CHECK-NEXT: [0.1] - AscalonFP
# CHECK-NEXT: [1]   - AscalonFXA
# CHECK-NEXT: [2]   - AscalonFXB
# CHECK-NEXT: [3.0] - AscalonFXC
# CHECK-NEXT: [3.1] - AscalonFXC
# CHECK-NEXT: [4.0] - AscalonFXD
# CHECK-NEXT: [4.1] - AscalonFXD
# CHECK-NEXT: [5.0] - AscalonLS
# CHECK-NEXT: [5.1] - AscalonLS
# CHECK-NEXT: [5.2] - AscalonLS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5.0]  [5.1]  [5.2]
# CHECK-NEXT:  -      -     17.00  1.00   2.00   2.00   1.00   1.00    -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5.0]  [5.1]  [5.2]  Instructions:
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -     mul	t0, a0, t0
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -     sub	s2, a2, a3
# CHECK-NEXT:  -      -     7.00    -      -      -      -      -      -      -      -     div	t1, t2, t3
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -      -      -     add	t1, a4, gp
# CHECK-NEXT:  -      -     7.00    -      -      -      -      -      -      -      -     div	a1, a2, a3
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -     add	t1, a0, t0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -     mul	s0, s0, a5
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -     add	t2, t2, t2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -     sub	s1, s0, s1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -      -      -      -     fcvt.s.w	ft1, t3
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -     add	s2, s2, s2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -     fcvt.w.s	t5, ft3
