; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=vector-combine -S %s | FileCheck %s

define <vscale x 4 x float> @scalarize_scalable(float %0, float %1, float %2, float %3) {
; CHECK-LABEL: @scalarize_scalable(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DOTSCALAR:%.*]] = fadd fast float [[TMP1:%.*]], [[TMP0:%.*]]
; CHECK-NEXT:    [[DOTSCALAR1:%.*]] = fadd fast float [[TMP2:%.*]], [[DOTSCALAR]]
; CHECK-NEXT:    [[DOTSCALAR2:%.*]] = fadd fast float [[TMP3:%.*]], [[DOTSCALAR1]]
; CHECK-NEXT:    [[TMP4:%.*]] = insertelement <vscale x 4 x float> poison, float [[DOTSCALAR2]], i64 0
; CHECK-NEXT:    [[TMP5:%.*]] = shufflevector <vscale x 4 x float> [[TMP4]], <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP5]]
;
entry:
  %broadcast.splatinsert = insertelement <vscale x 4 x float> poison, float %0, i64 0
  %broadcast.splatinsert28 = insertelement <vscale x 4 x float> poison, float %1, i64 0
  %broadcast.splatinsert30 = insertelement <vscale x 4 x float> poison, float %2, i64 0
  %broadcast.splatinsert32 = insertelement <vscale x 4 x float> poison, float %3, i64 0
  %4 = fadd fast <vscale x 4 x float> %broadcast.splatinsert28, %broadcast.splatinsert
  %5 = fadd fast <vscale x 4 x float> %broadcast.splatinsert30, %4
  %6 = fadd fast <vscale x 4 x float> %broadcast.splatinsert32, %5
  %7 = shufflevector <vscale x 4 x float> %6, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  ret <vscale x 4 x float> %7
}

define <vscale x 4 x i32> @scalarize_scalable_udiv(i32 %x, i32 %y) {
; CHECK-LABEL: @scalarize_scalable_udiv(
; CHECK-NEXT:    [[R_SCALAR:%.*]] = udiv i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = insertelement <vscale x 4 x i32> poison, i32 [[R_SCALAR]], i64 0
; CHECK-NEXT:    ret <vscale x 4 x i32> [[R]]
;
  %splatx = insertelement <vscale x 4 x i32> poison, i32 %x, i64 0
  %splaty = insertelement <vscale x 4 x i32> splat (i32 1), i32 %y, i64 0
  %r = udiv <vscale x 4 x i32> %splatx, %splaty
  ret <vscale x 4 x i32> %r
}

define <vscale x 4 x i1> @scalarize_scalable_icmp(i32 %x, i32 %y) {
; CHECK-LABEL: @scalarize_scalable_icmp(
; CHECK-NEXT:    [[R_SCALAR:%.*]] = icmp sgt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = insertelement <vscale x 4 x i1> poison, i1 [[R_SCALAR]], i64 0
; CHECK-NEXT:    ret <vscale x 4 x i1> [[R]]
;
  %splatx = insertelement <vscale x 4 x i32> poison, i32 %x, i64 0
  %splaty = insertelement <vscale x 4 x i32> poison, i32 %y, i64 0
  %r = icmp sgt <vscale x 4 x i32> %splatx, %splaty
  ret <vscale x 4 x i1> %r
}
