; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

define void @test_bitcast_1(i1 %c, ptr %ptr) {
; CHECK-LABEL: @test_bitcast_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[B0:%.*]], label [[B1:%.*]]
; CHECK:       b0:
; CHECK-NEXT:    call void @use(ptr [[PTR:%.*]])
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    store i8 0, ptr [[PTR]], align 1
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %b0, label %b1

b0:
  call void @use(ptr %ptr)
  br label %end

b1:
  br label %end

end:
  %p = phi ptr [ %ptr, %b0 ], [ %ptr, %b1 ]
  store i8 0, ptr %p
  ret void
}

define void @test_bitcast_2(i1 %c, ptr %ptr) {
; CHECK-LABEL: @test_bitcast_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[B0:%.*]], label [[B1:%.*]]
; CHECK:       b0:
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    call void @use(ptr [[PTR:%.*]])
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    store i8 0, ptr [[PTR]], align 1
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %b0, label %b1

b0:
  br label %end

b1:
  call void @use(ptr %ptr)
  br label %end

end:
  %p = phi ptr [ %ptr, %b0 ], [ %ptr, %b1 ]
  store i8 0, ptr %p
  ret void
}


define void @test_bitcast_3(i1 %c, ptr %ptr) {
; CHECK-LABEL: @test_bitcast_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LOAD_PTR:%.*]] = load ptr, ptr [[PTR:%.*]], align 8
; CHECK-NEXT:    br i1 [[C:%.*]], label [[B0:%.*]], label [[B1:%.*]]
; CHECK:       b0:
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    call void @use(ptr [[LOAD_PTR]])
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    store i8 0, ptr [[LOAD_PTR]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %load.ptr = load ptr, ptr %ptr
  br i1 %c, label %b0, label %b1

b0:
  br label %end

b1:
  call void @use(ptr %load.ptr)
  br label %end

end:
  %p = phi ptr [ %load.ptr, %b0 ], [ %load.ptr, %b1 ]
  store i8 0, ptr %p
  ret void
}

define void @test_bitcast_loads_in_different_bbs(i1 %c, ptr %ptr.0, ptr %ptr.1) {
; CHECK-LABEL: @test_bitcast_loads_in_different_bbs(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[B0:%.*]], label [[B1:%.*]]
; CHECK:       b0:
; CHECK-NEXT:    [[LOAD_PTR_0:%.*]] = load ptr, ptr [[PTR_0:%.*]], align 8
; CHECK-NEXT:    call void @use(ptr [[LOAD_PTR_0]])
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    [[LOAD_PTR_1:%.*]] = load ptr, ptr [[PTR_1:%.*]], align 8
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[LOAD_PTR_0]], [[B0]] ], [ [[LOAD_PTR_1]], [[B1]] ]
; CHECK-NEXT:    store i8 0, ptr [[P]], align 1
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %b0, label %b1

b0:
  %load.ptr.0 = load ptr, ptr %ptr.0
  call void @use(ptr %load.ptr.0)
  br label %end

b1:
  %load.ptr.1 = load ptr, ptr %ptr.1
  br label %end

end:
  %p = phi ptr [ %load.ptr.0, %b0 ], [ %load.ptr.1, %b1 ]
  store i8 0, ptr %p
  ret void
}

define void @test_gep_1(i1 %c, ptr %ptr) {
; CHECK-LABEL: @test_gep_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[B0:%.*]], label [[B1:%.*]]
; CHECK:       b0:
; CHECK-NEXT:    call void @use.i32(ptr [[PTR:%.*]])
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    store i32 0, ptr [[PTR]], align 4
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %b0, label %b1

b0:
  call void @use.i32(ptr %ptr)
  br label %end

b1:
  br label %end

end:
  %p = phi ptr [ %ptr, %b0 ], [ %ptr, %b1 ]
  store i32 0, ptr %p
  ret void
}

define void @test_bitcast_not_foldable(i1 %c, ptr %ptr.0, ptr %ptr.1) {
; CHECK-LABEL: @test_bitcast_not_foldable(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[B0:%.*]], label [[B1:%.*]]
; CHECK:       b0:
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    call void @use(ptr [[PTR_1:%.*]])
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[PTR_0:%.*]], [[B0]] ], [ [[PTR_1]], [[B1]] ]
; CHECK-NEXT:    store i8 0, ptr [[P]], align 1
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %b0, label %b1

b0:
  br label %end

b1:
  call void @use(ptr %ptr.1)
  br label %end

end:
  %p = phi ptr [ %ptr.0, %b0 ], [ %ptr.1, %b1 ]
  store i8 0, ptr %p
  ret void
}

define void @test_bitcast_with_extra_use(i1 %c, ptr %ptr) {
; CHECK-LABEL: @test_bitcast_with_extra_use(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[B0:%.*]], label [[B1:%.*]]
; CHECK:       b0:
; CHECK-NEXT:    call void @use(ptr [[PTR:%.*]])
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    store i8 0, ptr [[PTR]], align 1
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %b0, label %b1

b0:
  call void @use(ptr %ptr)
  br label %end

b1:
  br label %end

end:
  %p = phi ptr [ %ptr, %b0 ], [ %ptr, %b1 ]
  store i8 0, ptr %p
  ret void
}

define void @test_bitcast_different_bases(i1 %c, ptr %ptr.0, ptr %ptr.1) {
; CHECK-LABEL: @test_bitcast_different_bases(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[B0:%.*]], label [[B1:%.*]]
; CHECK:       b0:
; CHECK-NEXT:    call void @use(ptr [[PTR_0:%.*]])
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[PTR_0]], [[B0]] ], [ [[PTR_1:%.*]], [[B1]] ]
; CHECK-NEXT:    store i8 0, ptr [[P]], align 1
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %b0, label %b1

b0:
  call void @use(ptr %ptr.0)
  br label %end

b1:
  br label %end

end:
  %p = phi ptr [ %ptr.0, %b0 ], [ %ptr.1, %b1 ]
  store i8 0, ptr %p
  ret void
}

define void @test_bitcast_gep_chains(i1 %c, ptr %ptr) {
; CHECK-LABEL: @test_bitcast_gep_chains(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[B0:%.*]], label [[B1:%.*]]
; CHECK:       b0:
; CHECK-NEXT:    call void @use(ptr [[PTR:%.*]])
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    call void @use.i32(ptr [[PTR]])
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    store i8 0, ptr [[PTR]], align 1
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %b0, label %b1

b0:
  call void @use(ptr %ptr)
  br label %end

b1:
  call void @use.i32(ptr %ptr)
  br label %end

end:
  %p = phi ptr [ %ptr, %b0 ], [ %ptr, %b1 ]
  store i8 0, ptr %p
  ret void
}

define void @test_4_incoming_values_different_bases_1(i32 %c, ptr %ptr.0, ptr %ptr.1) {
; CHECK-LABEL: @test_4_incoming_values_different_bases_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i32 [[C:%.*]], label [[END_2:%.*]] [
; CHECK-NEXT:    i32 0, label [[B0:%.*]]
; CHECK-NEXT:    i32 1, label [[B1:%.*]]
; CHECK-NEXT:    i32 2, label [[B2:%.*]]
; CHECK-NEXT:    i32 3, label [[B3:%.*]]
; CHECK-NEXT:    ]
; CHECK:       b0:
; CHECK-NEXT:    call void @use(ptr [[PTR_0:%.*]])
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    br label [[END]]
; CHECK:       b2:
; CHECK-NEXT:    br label [[END]]
; CHECK:       b3:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[PTR_0]], [[B0]] ], [ [[PTR_1:%.*]], [[B1]] ], [ [[PTR_0]], [[B2]] ], [ [[PTR_0]], [[B3]] ]
; CHECK-NEXT:    store i8 0, ptr [[P]], align 1
; CHECK-NEXT:    ret void
; CHECK:       end.2:
; CHECK-NEXT:    ret void
;
entry:
  switch i32 %c, label %end.2 [ i32 0, label %b0
  i32 1, label %b1
  i32 2, label %b2
  i32 3, label %b3]

b0:
  call void @use(ptr %ptr.0)
  br label %end

b1:
  br label %end

b2:
  br label %end

b3:
  br label %end

end:
  %p = phi ptr [ %ptr.0, %b0 ], [ %ptr.1, %b1 ], [ %ptr.0, %b2 ], [ %ptr.0, %b3]
  store i8 0, ptr %p
  ret void

end.2:
  ret void
}

define void @test_4_incoming_values_different_bases_2(i32 %c, ptr %ptr.0, ptr %ptr.1) {
; CHECK-LABEL: @test_4_incoming_values_different_bases_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i32 [[C:%.*]], label [[END_2:%.*]] [
; CHECK-NEXT:    i32 0, label [[B0:%.*]]
; CHECK-NEXT:    i32 1, label [[B1:%.*]]
; CHECK-NEXT:    i32 2, label [[B2:%.*]]
; CHECK-NEXT:    i32 3, label [[B3:%.*]]
; CHECK-NEXT:    ]
; CHECK:       b0:
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    call void @use(ptr [[PTR_0:%.*]])
; CHECK-NEXT:    br label [[END]]
; CHECK:       b2:
; CHECK-NEXT:    br label [[END]]
; CHECK:       b3:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[PTR_1:%.*]], [[B0]] ], [ [[PTR_0]], [[B1]] ], [ [[PTR_0]], [[B2]] ], [ [[PTR_0]], [[B3]] ]
; CHECK-NEXT:    store i8 0, ptr [[P]], align 1
; CHECK-NEXT:    ret void
; CHECK:       end.2:
; CHECK-NEXT:    ret void
;
entry:
  switch i32 %c, label %end.2 [ i32 0, label %b0
  i32 1, label %b1
  i32 2, label %b2
  i32 3, label %b3]

b0:
  br label %end

b1:
  call void @use(ptr %ptr.0)
  br label %end

b2:
  br label %end

b3:
  br label %end

end:
  %p = phi ptr [ %ptr.1, %b0 ], [ %ptr.0, %b1 ], [ %ptr.0, %b2 ], [ %ptr.0, %b3]
  store i8 0, ptr %p
  ret void

end.2:
  ret void
}

define void @test_4_incoming_values_different_bases_3(i32 %c, ptr %ptr.0, ptr %ptr.1) {
; CHECK-LABEL: @test_4_incoming_values_different_bases_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i32 [[C:%.*]], label [[END_2:%.*]] [
; CHECK-NEXT:    i32 0, label [[B0:%.*]]
; CHECK-NEXT:    i32 1, label [[B1:%.*]]
; CHECK-NEXT:    i32 2, label [[B2:%.*]]
; CHECK-NEXT:    i32 3, label [[B3:%.*]]
; CHECK-NEXT:    ]
; CHECK:       b0:
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    br label [[END]]
; CHECK:       b2:
; CHECK-NEXT:    call void @use(ptr [[PTR_0:%.*]])
; CHECK-NEXT:    br label [[END]]
; CHECK:       b3:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[PTR_0]], [[B0]] ], [ [[PTR_0]], [[B1]] ], [ [[PTR_0]], [[B2]] ], [ [[PTR_1:%.*]], [[B3]] ]
; CHECK-NEXT:    store i8 0, ptr [[P]], align 1
; CHECK-NEXT:    ret void
; CHECK:       end.2:
; CHECK-NEXT:    ret void
;
entry:
  switch i32 %c, label %end.2 [ i32 0, label %b0
  i32 1, label %b1
  i32 2, label %b2
  i32 3, label %b3]

b0:
  br label %end

b1:
  br label %end

b2:
  call void @use(ptr %ptr.0)
  br label %end

b3:
  br label %end

end:
  %p = phi ptr [ %ptr.0, %b0 ], [ %ptr.0, %b1 ], [ %ptr.0, %b2 ], [ %ptr.1, %b3]
  store i8 0, ptr %p
  ret void

end.2:
  ret void
}

define void @test_addrspacecast_1(i1 %c, ptr %ptr) {
; CHECK-LABEL: @test_addrspacecast_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[B0:%.*]], label [[B1:%.*]]
; CHECK:       b0:
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       b1:
; CHECK-NEXT:    [[CAST_1:%.*]] = addrspacecast ptr [[PTR:%.*]] to ptr addrspace(1)
; CHECK-NEXT:    call void @use.i8.addrspace1(ptr addrspace(1) [[CAST_1]])
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[P:%.*]] = addrspacecast ptr [[PTR]] to ptr addrspace(1)
; CHECK-NEXT:    store i8 0, ptr addrspace(1) [[P]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %cast.0 = addrspacecast ptr %ptr to ptr addrspace(1)
  %cast.1 = addrspacecast ptr %ptr to ptr addrspace(1)
  br i1 %c, label %b0, label %b1

b0:
  br label %end

b1:
  call void @use.i8.addrspace1(ptr addrspace(1) %cast.1)
  br label %end

end:
  %p = phi ptr addrspace(1) [ %cast.0, %b0 ], [ %cast.1, %b1 ]
  store i8 0, ptr addrspace(1) %p
  ret void
}

declare void @use(ptr)
declare void @use.i32(ptr)
declare void @use.i8.addrspace1(ptr addrspace(1))
