; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use16(i16)
declare void @usev4(<4 x i4>)

define i1 @icmp_shl_ugt_1(i8 %x) {
; CHECK-LABEL: @icmp_shl_ugt_1(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = shl i8 %x, 1
  %cmp = icmp ugt i8 %add, %x
  ret i1 %cmp
}

define <2 x i1> @icmp_shl_ugt_2(<2 x i32> %_x) {
; CHECK-LABEL: @icmp_shl_ugt_2(
; CHECK-NEXT:    [[X:%.*]] = add <2 x i32> [[_X:%.*]], splat (i32 42)
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt <2 x i32> [[X]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %x = add <2 x i32> <i32 42, i32 42>, %_x ; thwart complexity-based canonicalization
  %add = shl <2 x i32> %x, <i32 1, i32 1>
  %cmp = icmp ugt <2 x i32> %x, %add
  ret <2 x i1> %cmp
}

define <3 x i1> @icmp_shl_uge_1(<3 x i7> %x) {
; CHECK-LABEL: @icmp_shl_uge_1(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt <3 x i7> [[X:%.*]], splat (i7 -1)
; CHECK-NEXT:    ret <3 x i1> [[CMP]]
;
  %add = shl <3 x i7> %x, <i7 1, i7 1, i7 1>
  %cmp = icmp uge <3 x i7> %add, %x
  ret <3 x i1> %cmp
}

define i1 @icmp_shl_uge_2(i5 %_x) {
; CHECK-LABEL: @icmp_shl_uge_2(
; CHECK-NEXT:    [[X:%.*]] = add i5 [[_X:%.*]], 10
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i5 [[X]], 1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %x = add i5 42, %_x ; thwart complexity-based canonicalization
  %add = shl i5 %x, 1
  %cmp = icmp uge i5 %x, %add
  ret i1 %cmp
}

define i1 @icmp_shl_ult_1(i16 %x) {
; CHECK-LABEL: @icmp_shl_ult_1(
; CHECK-NEXT:    [[ADD:%.*]] = shl i16 [[X:%.*]], 1
; CHECK-NEXT:    call void @use16(i16 [[ADD]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i16 [[X]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = shl i16 %x, 1
  call void @use16(i16 %add) ; extra use of shl
  %cmp = icmp ult i16 %add, %x
  ret i1 %cmp
}

define <4 x i1> @icmp_shl_ult_2(<4 x i4> %_x) {
; CHECK-LABEL: @icmp_shl_ult_2(
; CHECK-NEXT:    [[X:%.*]] = add <4 x i4> [[_X:%.*]], splat (i4 -6)
; CHECK-NEXT:    [[ADD:%.*]] = shl <4 x i4> [[X]], splat (i4 1)
; CHECK-NEXT:    call void @usev4(<4 x i4> [[ADD]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt <4 x i4> [[X]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[CMP]]
;
  %x = add <4 x i4> <i4 42, i4 42, i4 42, i4 42>, %_x ; thwart complexity-based canonicalization
  %add = shl <4 x i4> %x, <i4 1, i4 1, i4 1, i4 1>
  call void @usev4(<4 x i4> %add) ; extra use of shl
  %cmp = icmp ult <4 x i4> %x, %add
  ret <4 x i1> %cmp
}

define <2 x i1> @icmp_shl_ule_1(<2 x i8> %x) {
; CHECK-LABEL: @icmp_shl_ule_1(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt <2 x i8> [[X:%.*]], splat (i8 1)
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %add = shl <2 x i8> %x, <i8 1, i8 poison>
  %cmp = icmp ule <2 x i8> %add, %x
  ret <2 x i1> %cmp
}

define i1 @icmp_shl_ule_2(i8 %_x) {
; CHECK-LABEL: @icmp_shl_ule_2(
; CHECK-NEXT:    [[X:%.*]] = add i8 [[_X:%.*]], 42
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %x = add i8 42, %_x ; thwart complexity-based canonicalization
  %add = shl i8 %x, 1
  %cmp = icmp ule i8 %x, %add
  ret i1 %cmp
}

define i1 @icmp_shl_eq_1(i8 %x) {
; CHECK-LABEL: @icmp_shl_eq_1(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = shl i8 %x, 1
  %cmp = icmp eq i8 %add, %x
  ret i1 %cmp
}

define <2 x i1> @icmp_shl_eq_2(<2 x i8> %_x) {
; CHECK-LABEL: @icmp_shl_eq_2(
; CHECK-NEXT:    [[X:%.*]] = sdiv <2 x i8> splat (i8 42), [[_X:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i8> [[X]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %x = sdiv <2 x i8> <i8 42, i8 42>, %_x ; thwart complexity-based canonicalization
  %add = shl <2 x i8> %x, <i8 1, i8 1>
  %cmp = icmp eq <2 x i8> %x, %add
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_shl_ne_1(<2 x i8> %x) {
; CHECK-LABEL: @icmp_shl_ne_1(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i8> [[X:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %add = shl <2 x i8> %x, <i8 1, i8 1>
  %cmp = icmp ne <2 x i8> %add, %x
  ret <2 x i1> %cmp
}

define i1 @icmp_shl_ne_2(i8 %_x) {
; CHECK-LABEL: @icmp_shl_ne_2(
; CHECK-NEXT:    [[X:%.*]] = sdiv i8 42, [[_X:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[X]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %x = sdiv i8 42, %_x ; thwart complexity-based canonicalization
  %add = shl i8 %x, 1
  %cmp = icmp ne i8 %x, %add
  ret i1 %cmp
}

define i1 @negative_test_signed_pred(i8 %x) {
; CHECK-LABEL: @negative_test_signed_pred(
; CHECK-NEXT:    [[ADD:%.*]] = shl i8 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[ADD]], [[X]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = shl i8 %x, 1
  %cmp = icmp slt i8 %add, %x
  ret i1 %cmp
}

define i1 @negative_test_shl_more_than_1(i16 %x) {
; CHECK-LABEL: @negative_test_shl_more_than_1(
; CHECK-NEXT:    [[ADD:%.*]] = shl i16 [[X:%.*]], 2
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i16 [[ADD]], [[X]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = shl i16 %x, 2
  %cmp = icmp ult i16 %add, %x
  ret i1 %cmp
}

define i1 @negative_test_compare_with_different_value(i16 %x, i16 %y) {
; CHECK-LABEL: @negative_test_compare_with_different_value(
; CHECK-NEXT:    [[ADD:%.*]] = shl i16 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i16 [[ADD]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %add = shl i16 %x, 1
  %cmp = icmp ult i16 %add, %y
  ret i1 %cmp
}
