; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefix=X64

declare void @use.i1(i1)
declare void @use.i32(i32)
define i32 @sitofp_signbit_only(i32 %i_in) nounwind {
; X86-LABEL: sitofp_signbit_only:
; X86:       # %bb.0:
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    fildl (%esp)
; X86-NEXT:    fstps {{[0-9]+}}(%esp)
; X86-NEXT:    movl $-2147483648, %eax # imm = 0x80000000
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl $8, %esp
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_signbit_only:
; X64:       # %bb.0:
; X64-NEXT:    cvtsi2ss %edi, %xmm0
; X64-NEXT:    movmskps %xmm0, %eax
; X64-NEXT:    shll $31, %eax
; X64-NEXT:    retq
  %f = sitofp i32 %i_in to float
  %i = bitcast float %f to i32
  %r = and i32 %i, 2147483648
  ret i32 %r
}

define i32 @sitofp_signbit_only_okay_width(i16 %i_in) nounwind {
; X86-LABEL: sitofp_signbit_only_okay_width:
; X86:       # %bb.0:
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X86-NEXT:    filds {{[0-9]+}}(%esp)
; X86-NEXT:    fstps {{[0-9]+}}(%esp)
; X86-NEXT:    movl $-2147483648, %eax # imm = 0x80000000
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl $8, %esp
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_signbit_only_okay_width:
; X64:       # %bb.0:
; X64-NEXT:    movswl %di, %eax
; X64-NEXT:    cvtsi2ss %eax, %xmm0
; X64-NEXT:    movmskps %xmm0, %eax
; X64-NEXT:    shll $31, %eax
; X64-NEXT:    retq
  %f = sitofp i16 %i_in to float
  %i = bitcast float %f to i32
  %r = and i32 %i, 2147483648
  ret i32 %r
}

define i32 @sitofp_signbit_only_fail_bad_width1(i64 %i_in) nounwind {
; X86-LABEL: sitofp_signbit_only_fail_bad_width1:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    fildll {{[0-9]+}}(%esp)
; X86-NEXT:    fstps (%esp)
; X86-NEXT:    movl $-2147483648, %eax # imm = 0x80000000
; X86-NEXT:    andl (%esp), %eax
; X86-NEXT:    popl %ecx
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_signbit_only_fail_bad_width1:
; X64:       # %bb.0:
; X64-NEXT:    cvtsi2ss %rdi, %xmm0
; X64-NEXT:    movmskps %xmm0, %eax
; X64-NEXT:    shll $31, %eax
; X64-NEXT:    retq
  %f = sitofp i64 %i_in to float
  %i = bitcast float %f to i32
  %r = and i32 %i, 2147483648
  ret i32 %r
}

define <2 x i16> @sitofp_signbit_only_fail_bad_width2(i32 %i_in) nounwind {
; X86-LABEL: sitofp_signbit_only_fail_bad_width2:
; X86:       # %bb.0:
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    fildl (%esp)
; X86-NEXT:    fstps {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    shrl $16, %edx
; X86-NEXT:    andl $32768, %eax # imm = 0x8000
; X86-NEXT:    andl $32768, %edx # imm = 0x8000
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    # kill: def $dx killed $dx killed $edx
; X86-NEXT:    addl $8, %esp
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_signbit_only_fail_bad_width2:
; X64:       # %bb.0:
; X64-NEXT:    cvtsi2ss %edi, %xmm0
; X64-NEXT:    andps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-NEXT:    retq
  %f = sitofp i32 %i_in to float
  %i2xi16 = bitcast float %f to <2 x i16>
  %r = and <2 x i16> %i2xi16, <i16 32768, i16 32768>
  ret <2 x i16> %r
}

define i32 @sitofp_many_bits_fail(i32 %i_in) nounwind {
; X86-LABEL: sitofp_many_bits_fail:
; X86:       # %bb.0:
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    fildl (%esp)
; X86-NEXT:    fstps {{[0-9]+}}(%esp)
; X86-NEXT:    movl $-2147483647, %eax # imm = 0x80000001
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl $8, %esp
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_many_bits_fail:
; X64:       # %bb.0:
; X64-NEXT:    cvtsi2ss %edi, %xmm0
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $-2147483647, %eax # imm = 0x80000001
; X64-NEXT:    retq
  %f = sitofp i32 %i_in to float
  %i = bitcast float %f to i32
  %r = and i32 %i, 2147483649
  ret i32 %r
}

define i32 @sitofp_multiuse_fail(i32 %i_in) nounwind {
; X86-LABEL: sitofp_multiuse_fail:
; X86:       # %bb.0:
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    fildl {{[0-9]+}}(%esp)
; X86-NEXT:    fsts {{[0-9]+}}(%esp)
; X86-NEXT:    fstps (%esp)
; X86-NEXT:    calll use.i32@PLT
; X86-NEXT:    movl $-2147483648, %eax # imm = 0x80000000
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_multiuse_fail:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rbx
; X64-NEXT:    cvtsi2ss %edi, %xmm0
; X64-NEXT:    movd %xmm0, %ebx
; X64-NEXT:    movl %ebx, %edi
; X64-NEXT:    callq use.i32@PLT
; X64-NEXT:    andl $-2147483648, %ebx # imm = 0x80000000
; X64-NEXT:    movl %ebx, %eax
; X64-NEXT:    popq %rbx
; X64-NEXT:    retq
  %f = sitofp i32 %i_in to float
  %i = bitcast float %f to i32
  call void @use.i32(i32 %i)
  %r = and i32 %i, 2147483648
  ret i32 %r
}

define i32 @sitofp_multiuse_okay(i32 %i_in) nounwind {
; X86-LABEL: sitofp_multiuse_okay:
; X86:       # %bb.0:
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    fildl {{[0-9]+}}(%esp)
; X86-NEXT:    fsts {{[0-9]+}}(%esp)
; X86-NEXT:    fstps (%esp)
; X86-NEXT:    calll use.i1@PLT
; X86-NEXT:    movl $-2147483648, %eax # imm = 0x80000000
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
;
; X64-LABEL: sitofp_multiuse_okay:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rbx
; X64-NEXT:    cvtsi2ss %edi, %xmm0
; X64-NEXT:    movd %xmm0, %ebx
; X64-NEXT:    movl %ebx, %edi
; X64-NEXT:    callq use.i1@PLT
; X64-NEXT:    andl $-2147483648, %ebx # imm = 0x80000000
; X64-NEXT:    movl %ebx, %eax
; X64-NEXT:    popq %rbx
; X64-NEXT:    retq
  %f = sitofp i32 %i_in to float
  %i = bitcast float %f to i32
  %cmp = icmp slt i32 %i, 0
  call void @use.i1(i32 %i)
  %r = and i32 %i, 2147483648
  ret i32 %r
}

define i32 @uitofp_signbit_only(i32 %i_in) nounwind {
; X86-LABEL: uitofp_signbit_only:
; X86:       # %bb.0:
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_signbit_only:
; X64:       # %bb.0:
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
  %f = uitofp i32 %i_in to float
  %i = bitcast float %f to i32
  %r = and i32 %i, 2147483648
  ret i32 %r
}

define i32 @uitofp_signbit_only_okay_width(i16 %i_in) nounwind {
; X86-LABEL: uitofp_signbit_only_okay_width:
; X86:       # %bb.0:
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_signbit_only_okay_width:
; X64:       # %bb.0:
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
  %f = uitofp i16 %i_in to float
  %i = bitcast float %f to i32
  %r = and i32 %i, 2147483648
  ret i32 %r
}

define i32 @uitofp_signbit_only_okay_width1(i64 %i_in) nounwind {
; X86-LABEL: uitofp_signbit_only_okay_width1:
; X86:       # %bb.0:
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_signbit_only_okay_width1:
; X64:       # %bb.0:
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
  %f = uitofp i64 %i_in to float
  %i = bitcast float %f to i32
  %r = and i32 %i, 2147483648
  ret i32 %r
}

define <2 x i16> @uitofp_signbit_only_fail_bad_width2(i32 %i_in) nounwind {
; X86-LABEL: uitofp_signbit_only_fail_bad_width2:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $16, %esp
; X86-NEXT:    movl 8(%ebp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl $0, {{[0-9]+}}(%esp)
; X86-NEXT:    fildll {{[0-9]+}}(%esp)
; X86-NEXT:    fstps {{[0-9]+}}(%esp)
; X86-NEXT:    movl $32768, %eax # imm = 0x8000
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_signbit_only_fail_bad_width2:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    cvtsi2ss %rax, %xmm0
; X64-NEXT:    andps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-NEXT:    retq
  %f = uitofp i32 %i_in to float
  %i2xi16 = bitcast float %f to <2 x i16>
  %r = and <2 x i16> %i2xi16, <i16 32768, i16 32768>
  ret <2 x i16> %r
}

define i32 @uitofp_many_bits_fail(i32 %i_in) nounwind {
; X86-LABEL: uitofp_many_bits_fail:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $16, %esp
; X86-NEXT:    movl 8(%ebp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl $0, {{[0-9]+}}(%esp)
; X86-NEXT:    fildll {{[0-9]+}}(%esp)
; X86-NEXT:    fstps {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_many_bits_fail:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    cvtsi2ss %rax, %xmm0
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $1, %eax
; X64-NEXT:    retq
  %f = uitofp i32 %i_in to float
  %i = bitcast float %f to i32
  %r = and i32 %i, 2147483649
  ret i32 %r
}

define i32 @uitofp_multiuse_fail(i32 %i_in) nounwind {
; X86-LABEL: uitofp_multiuse_fail:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $16, %esp
; X86-NEXT:    movl 8(%ebp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl $0, {{[0-9]+}}(%esp)
; X86-NEXT:    fildll {{[0-9]+}}(%esp)
; X86-NEXT:    fstps (%esp)
; X86-NEXT:    calll use.i32@PLT
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_multiuse_fail:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rax
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    cvtsi2ss %rax, %xmm0
; X64-NEXT:    movd %xmm0, %edi
; X64-NEXT:    callq use.i32@PLT
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    popq %rcx
; X64-NEXT:    retq
  %f = uitofp i32 %i_in to float
  %i = bitcast float %f to i32
  call void @use.i32(i32 %i)
  %r = and i32 %i, 2147483648
  ret i32 %r
}

define i32 @uitofp_multiuse_okay(i32 %i_in) nounwind {
; X86-LABEL: uitofp_multiuse_okay:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $16, %esp
; X86-NEXT:    movl 8(%ebp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl $0, {{[0-9]+}}(%esp)
; X86-NEXT:    fildll {{[0-9]+}}(%esp)
; X86-NEXT:    fstps (%esp)
; X86-NEXT:    calll use.i1@PLT
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64-LABEL: uitofp_multiuse_okay:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rax
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    cvtsi2ss %rax, %xmm0
; X64-NEXT:    movd %xmm0, %edi
; X64-NEXT:    callq use.i1@PLT
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    popq %rcx
; X64-NEXT:    retq
  %f = uitofp i32 %i_in to float
  %i = bitcast float %f to i32
  %cmp = icmp slt i32 %i, 0
  call void @use.i1(i32 %i)
  %r = and i32 %i, 2147483648
  ret i32 %r
}
