; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; Test vector rotate left instructions with scalar rotate amount.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

declare <16 x i8> @llvm.fshl.v16i8(<16 x i8>, <16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.fshl.v8i16(<8 x i16>, <8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.fshl.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.fshl.v2i64(<2 x i64>, <2 x i64>, <2 x i64>)

; Test a v16i8 rotate left.
define <16 x i8> @f1(<16 x i8> %dummy, <16 x i8> %val, i32 %scalar) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verllb %v24, %v26, 0(%r2)
; CHECK-NEXT:    br %r14

  %scalar_tmp = trunc i32 %scalar to i8
  %tmp = insertelement <16 x i8> undef, i8 %scalar_tmp, i32 0
  %amt = shufflevector <16 x i8> %tmp, <16 x i8> undef,
                       <16 x i32> zeroinitializer

  %inv = sub <16 x i8> <i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8,
                        i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8, i8 8>, %amt
  %parta = shl <16 x i8> %val, %amt
  %partb = lshr <16 x i8> %val, %inv

  %rotl = or <16 x i8> %parta, %partb

  ret <16 x i8> %rotl
}

; Test a v16i8 rotate left (matched from fshl).
define <16 x i8> @f2(<16 x i8> %dummy, <16 x i8> %val, i32 %scalar) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verllb %v24, %v26, 0(%r2)
; CHECK-NEXT:    br %r14

  %scalar_tmp = trunc i32 %scalar to i8
  %tmp = insertelement <16 x i8> undef, i8 %scalar_tmp, i32 0
  %amt = shufflevector <16 x i8> %tmp, <16 x i8> undef,
                       <16 x i32> zeroinitializer

  %rotl = tail call <16 x i8> @llvm.fshl.v16i8(<16 x i8> %val, <16 x i8> %val, <16 x i8> %amt)

  ret <16 x i8> %rotl
}

; Test a v8i16 rotate left.
define <8 x i16> @f3(<8 x i16> %dummy, <8 x i16> %val, i32 %scalar) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verllh %v24, %v26, 0(%r2)
; CHECK-NEXT:    br %r14

  %scalar_tmp = trunc i32 %scalar to i16
  %tmp = insertelement <8 x i16> undef, i16 %scalar_tmp, i32 0
  %amt = shufflevector <8 x i16> %tmp, <8 x i16> undef,
                       <8 x i32> zeroinitializer

  %inv = sub <8 x i16> <i16 16, i16 16, i16 16, i16 16,
                        i16 16, i16 16, i16 16, i16 16>, %amt
  %parta = shl <8 x i16> %val, %amt
  %partb = lshr <8 x i16> %val, %inv

  %rotl = or <8 x i16> %parta, %partb

  ret <8 x i16> %rotl
}

; Test a v8i16 rotate left (matched from fshl).
define <8 x i16> @f4(<8 x i16> %dummy, <8 x i16> %val, i32 %scalar) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verllh %v24, %v26, 0(%r2)
; CHECK-NEXT:    br %r14

  %scalar_tmp = trunc i32 %scalar to i16
  %tmp = insertelement <8 x i16> undef, i16 %scalar_tmp, i32 0
  %amt = shufflevector <8 x i16> %tmp, <8 x i16> undef,
                       <8 x i32> zeroinitializer

  %rotl = tail call <8 x i16> @llvm.fshl.v8i16(<8 x i16> %val, <8 x i16> %val, <8 x i16> %amt)

  ret <8 x i16> %rotl
}

; Test a v4i32 rotate left.
define <4 x i32> @f5(<4 x i32> %dummy, <4 x i32> %val, i32 %scalar) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verllf %v24, %v26, 0(%r2)
; CHECK-NEXT:    br %r14

  %tmp = insertelement <4 x i32> undef, i32 %scalar, i32 0
  %amt = shufflevector <4 x i32> %tmp, <4 x i32> undef,
                       <4 x i32> zeroinitializer

  %inv = sub <4 x i32> <i32 32, i32 32, i32 32, i32 32>, %amt
  %parta = shl <4 x i32> %val, %amt
  %partb = lshr <4 x i32> %val, %inv

  %rotl = or <4 x i32> %parta, %partb

  ret <4 x i32> %rotl
}

; Test a v4i32 rotate left (matched from fshl).
define <4 x i32> @f6(<4 x i32> %dummy, <4 x i32> %val, i32 %scalar) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verllf %v24, %v26, 0(%r2)
; CHECK-NEXT:    br %r14

  %tmp = insertelement <4 x i32> undef, i32 %scalar, i32 0
  %amt = shufflevector <4 x i32> %tmp, <4 x i32> undef,
                       <4 x i32> zeroinitializer

  %rotl = tail call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %val, <4 x i32> %val, <4 x i32> %amt)

  ret <4 x i32> %rotl
}

; Test a v2i64 rotate left.
define <2 x i64> @f7(<2 x i64> %dummy, <2 x i64> %val, i32 %scalar) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verllg %v24, %v26, 0(%r2)
; CHECK-NEXT:    br %r14

  %scalar_tmp = zext i32 %scalar to i64
  %tmp = insertelement <2 x i64> undef, i64 %scalar_tmp, i32 0
  %amt = shufflevector <2 x i64> %tmp, <2 x i64> undef,
                       <2 x i32> zeroinitializer

  %inv = sub <2 x i64> <i64 64, i64 64>, %amt
  %parta = shl <2 x i64> %val, %amt
  %partb = lshr <2 x i64> %val, %inv

  %rotl = or <2 x i64> %parta, %partb

  ret <2 x i64> %rotl
}

; Test a v2i64 rotate left (matched from fshl).
define <2 x i64> @f8(<2 x i64> %dummy, <2 x i64> %val, i32 %scalar) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verllg %v24, %v26, 0(%r2)
; CHECK-NEXT:    br %r14

  %scalar_tmp = zext i32 %scalar to i64
  %tmp = insertelement <2 x i64> undef, i64 %scalar_tmp, i32 0
  %amt = shufflevector <2 x i64> %tmp, <2 x i64> undef,
                       <2 x i32> zeroinitializer

  %rotl = tail call <2 x i64> @llvm.fshl.v2i64(<2 x i64> %val, <2 x i64> %val, <2 x i64> %amt)

  ret <2 x i64> %rotl
}

; Test a v2i64 rotate left (matched from fshl).
define <2 x i64> @f9(<2 x i64> %dummy, <2 x i64> %val, i64 %scalar) {
; CHECK-LABEL: f9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verllg %v24, %v26, 0(%r2)
; CHECK-NEXT:    br %r14

  %tmp = insertelement <2 x i64> undef, i64 %scalar, i32 0
  %amt = shufflevector <2 x i64> %tmp, <2 x i64> undef,
                       <2 x i32> zeroinitializer

  %rotl = tail call <2 x i64> @llvm.fshl.v2i64(<2 x i64> %val, <2 x i64> %val, <2 x i64> %amt)

  ret <2 x i64> %rotl
}
