; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+experimental-xqcibm -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32IXQCIBM
; RUN: llc -mtriple=riscv32 -mattr=+experimental-xqcibm,+zbs -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32IXQCIBMZBS


define i32 @test_ori(i32 %a) nounwind {
; RV32I-LABEL: test_ori:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ori a0, a0, 511
; RV32I-NEXT:    ret
;
; RV32IXQCIBM-LABEL: test_ori:
; RV32IXQCIBM:       # %bb.0:
; RV32IXQCIBM-NEXT:    ori a0, a0, 511
; RV32IXQCIBM-NEXT:    ret
;
; RV32IXQCIBMZBS-LABEL: test_ori:
; RV32IXQCIBMZBS:       # %bb.0:
; RV32IXQCIBMZBS-NEXT:    ori a0, a0, 511
; RV32IXQCIBMZBS-NEXT:    ret
  %or = or i32 %a, 511
  ret i32 %or
}

define i32 @test_insbi_mask(i32 %a) nounwind {
; RV32I-LABEL: test_insbi_mask:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IXQCIBM-LABEL: test_insbi_mask:
; RV32IXQCIBM:       # %bb.0:
; RV32IXQCIBM-NEXT:    qc.insbi a0, -1, 16, 0
; RV32IXQCIBM-NEXT:    ret
;
; RV32IXQCIBMZBS-LABEL: test_insbi_mask:
; RV32IXQCIBMZBS:       # %bb.0:
; RV32IXQCIBMZBS-NEXT:    qc.insbi a0, -1, 16, 0
; RV32IXQCIBMZBS-NEXT:    ret
  %or = or i32 %a, 65535
  ret i32 %or
}

define i32 @test_insbi_mask_mv(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: test_insbi_mask_mv:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IXQCIBM-LABEL: test_insbi_mask_mv:
; RV32IXQCIBM:       # %bb.0:
; RV32IXQCIBM-NEXT:    mv a0, a1
; RV32IXQCIBM-NEXT:    qc.insbi a0, -1, 16, 0
; RV32IXQCIBM-NEXT:    ret
;
; RV32IXQCIBMZBS-LABEL: test_insbi_mask_mv:
; RV32IXQCIBMZBS:       # %bb.0:
; RV32IXQCIBMZBS-NEXT:    mv a0, a1
; RV32IXQCIBMZBS-NEXT:    qc.insbi a0, -1, 16, 0
; RV32IXQCIBMZBS-NEXT:    ret
  %or = or i32 %b, 65535
  ret i32 %or
}

define i32 @test_insbi_shifted_mask(i32 %a) nounwind {
; RV32I-LABEL: test_insbi_shifted_mask:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 15
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IXQCIBM-LABEL: test_insbi_shifted_mask:
; RV32IXQCIBM:       # %bb.0:
; RV32IXQCIBM-NEXT:    qc.insbi a0, -1, 4, 12
; RV32IXQCIBM-NEXT:    ret
;
; RV32IXQCIBMZBS-LABEL: test_insbi_shifted_mask:
; RV32IXQCIBMZBS:       # %bb.0:
; RV32IXQCIBMZBS-NEXT:    qc.insbi a0, -1, 4, 12
; RV32IXQCIBMZBS-NEXT:    ret
  %or = or i32 %a, 61440
  ret i32 %or
}

define i32 @test_insbi_shifted_mask_multiple_uses(i32 %a) nounwind {
; RV32I-LABEL: test_insbi_shifted_mask_multiple_uses:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 15
; RV32I-NEXT:    or a1, a0, a1
; RV32I-NEXT:    addi a0, a0, 10
; RV32I-NEXT:    xor a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IXQCIBM-LABEL: test_insbi_shifted_mask_multiple_uses:
; RV32IXQCIBM:       # %bb.0:
; RV32IXQCIBM-NEXT:    lui a1, 15
; RV32IXQCIBM-NEXT:    or a1, a1, a0
; RV32IXQCIBM-NEXT:    addi a0, a0, 10
; RV32IXQCIBM-NEXT:    xor a0, a0, a1
; RV32IXQCIBM-NEXT:    ret
;
; RV32IXQCIBMZBS-LABEL: test_insbi_shifted_mask_multiple_uses:
; RV32IXQCIBMZBS:       # %bb.0:
; RV32IXQCIBMZBS-NEXT:    lui a1, 15
; RV32IXQCIBMZBS-NEXT:    or a1, a1, a0
; RV32IXQCIBMZBS-NEXT:    addi a0, a0, 10
; RV32IXQCIBMZBS-NEXT:    xor a0, a0, a1
; RV32IXQCIBMZBS-NEXT:    ret
  %or = or i32 %a, 61440
  %add = add i32 %a, 10
  %xor = xor i32 %or, %add
  ret i32 %xor
}

define i32 @test_single_bit_set(i32 %a) nounwind {
; RV32I-LABEL: test_single_bit_set:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IXQCIBM-LABEL: test_single_bit_set:
; RV32IXQCIBM:       # %bb.0:
; RV32IXQCIBM-NEXT:    qc.insbi a0, -1, 1, 12
; RV32IXQCIBM-NEXT:    ret
;
; RV32IXQCIBMZBS-LABEL: test_single_bit_set:
; RV32IXQCIBMZBS:       # %bb.0:
; RV32IXQCIBMZBS-NEXT:    bseti a0, a0, 12
; RV32IXQCIBMZBS-NEXT:    ret
  %or = or i32 %a, 4096
  ret i32 %or
}
